/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.common.service.etl;

import java.lang.reflect.Type;
import java.nio.charset.Charset;
import mulesoft.common.Predefined;
import mulesoft.common.collections.Colls;
import mulesoft.common.collections.ImmutableList;
import mulesoft.common.collections.Seq;
import mulesoft.common.media.MediaType;
import mulesoft.common.media.Mime;
import mulesoft.common.service.Headers;
import mulesoft.common.service.etl.MessageConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractMessageConverter<T>
implements MessageConverter<T> {
    private final Seq<MediaType> supportedMimes;
    protected static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");

    protected AbstractMessageConverter() {
        this(MediaType.ALL);
    }

    protected AbstractMessageConverter(MediaType mediaType) {
        this((Seq<MediaType>)Colls.listOf((Object)mediaType));
    }

    protected AbstractMessageConverter(MediaType ... mediaTypes) {
        this((Seq<MediaType>)ImmutableList.fromArray((Object[])mediaTypes));
    }

    private AbstractMessageConverter(@NotNull Seq<MediaType> supportedMimes) {
        this.supportedMimes = supportedMimes;
    }

    @Override
    public boolean canRead(Class<?> type, Type genericType, MediaType contentType) {
        return this.supports(type) && this.canRead(contentType);
    }

    @Override
    public boolean canWrite(Class<?> type, Type genericType, MediaType contentType) {
        return this.supports(type) && this.canWrite(contentType);
    }

    @Override
    public void write(T payload, MediaType contentType, Headers headers) {
        if (contentType == null && !this.supportedMimes.isEmpty()) {
            headers.setContentType((MediaType)this.supportedMimes.getFirst().get());
        }
        if (contentType != null && headers.getContentType() == null) {
            headers.setContentType(contentType);
        }
        if (headers.getAccept().isEmpty()) {
            headers.setAccept((Iterable<MediaType>)this.supportedMimes);
        }
    }

    @Override
    public Seq<MediaType> getSupportedMediaTypes() {
        return this.supportedMimes;
    }

    protected boolean canRead(MediaType mediaType) {
        if (mediaType == null) {
            return true;
        }
        for (MediaType supported : this.getSupportedMediaTypes()) {
            if (!supported.includes(mediaType)) continue;
            return true;
        }
        return false;
    }

    protected boolean canWrite(@Nullable MediaType mediaType) {
        if (mediaType == null || Mime.ALL == mediaType.getMime()) {
            return true;
        }
        for (MediaType supported : this.getSupportedMediaTypes()) {
            if (!supported.includes(mediaType)) continue;
            return true;
        }
        return false;
    }

    protected abstract boolean supports(Class<?> var1);

    @NotNull
    protected Charset getContentTypeCharsetOrDefault(@Nullable MediaType mediaType, @NotNull Charset defaultCharset) {
        if (mediaType != null) {
            return (Charset)Predefined.notNull((Object)mediaType.getCharset(), (Object)defaultCharset);
        }
        return defaultCharset;
    }
}

