/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.common.service.etl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import mulesoft.common.core.DateOnly;
import mulesoft.common.core.DateTime;
import mulesoft.common.media.MediaType;
import mulesoft.common.service.etl.AbstractMessageConverter;
import mulesoft.common.util.Conversions;
import mulesoft.common.util.Files;
import org.jetbrains.annotations.Nullable;

public class BasicTypeMessageConverter
extends AbstractMessageConverter<Object> {
    private final Charset charset;

    public BasicTypeMessageConverter() {
        this(DEFAULT_CHARSET);
    }

    public BasicTypeMessageConverter(Charset charset) {
        super(MediaType.TEXT_PLAIN);
        this.charset = charset;
    }

    @Override
    public Object read(Class<?> type, Type genericType, @Nullable MediaType contentType, InputStream stream) throws IOException {
        Charset c = this.getContentTypeCharsetOrDefault(contentType, this.charset);
        String content = Files.readInput((Reader)new InputStreamReader(stream, c));
        return Conversions.fromString((String)content, type);
    }

    @Override
    public void write(Object content, @Nullable MediaType contentType, OutputStream stream) throws IOException {
        Charset c = this.getContentTypeCharsetOrDefault(contentType, this.charset);
        stream.write(Conversions.toString((Object)content).getBytes(c));
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        return Boolean.class.equals(clazz) || Integer.class.equals(clazz) || Double.class.equals(clazz) || BigDecimal.class.equals(clazz) || DateTime.class.equals(clazz) || DateOnly.class.equals(clazz) || clazz.isEnum();
    }
}

