/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.common.service.etl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.function.Function;
import mulesoft.common.collections.Colls;
import mulesoft.common.collections.MultiMap;
import mulesoft.common.media.MediaType;
import mulesoft.common.service.etl.AbstractMessageConverter;
import org.jetbrains.annotations.NotNull;

public class FormMessageConverter
extends AbstractMessageConverter<MultiMap<String, String>> {
    @NotNull
    private final Charset charset;

    public FormMessageConverter() {
        this(DEFAULT_CHARSET);
    }

    public FormMessageConverter(@NotNull Charset charset) {
        super(MediaType.APPLICATION_FORM_URLENCODED);
        this.charset = charset;
    }

    @Override
    public MultiMap<String, String> read(Class<? extends MultiMap<String, String>> type, Type genericType, MediaType contentType, InputStream stream) throws IOException {
        throw new IllegalStateException("FormMessageConverter is a write only converter!");
    }

    @Override
    public void write(MultiMap<String, String> content, MediaType contentType, OutputStream stream) throws IOException {
        Charset c = this.getContentTypeCharsetOrDefault(contentType, this.charset);
        StringBuilder builder = new StringBuilder();
        Function<String, String> encoder = this.createEncoder(c);
        for (Map.Entry entry : content.asMap().entrySet()) {
            if (builder.length() != 0) {
                builder.append("&");
            }
            String name = encoder.apply((String)entry.getKey());
            String parameter = Colls.map((Iterable)((Iterable)entry.getValue()), encoder).map(value -> name + "=" + value).mkString("&");
            builder.append(parameter);
        }
        OutputStreamWriter writer = new OutputStreamWriter(stream, c);
        writer.write(builder.toString());
        ((Writer)writer).flush();
    }

    @Override
    protected boolean canRead(MediaType mediaType) {
        return false;
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        return MultiMap.class.equals(clazz);
    }

    private Function<String, String> createEncoder(Charset c) {
        return value -> {
            try {
                return URLEncoder.encode(value, c.name());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return "";
            }
        };
    }
}

