/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.common.service.etl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import mulesoft.common.env.context.Context;
import mulesoft.common.media.MediaType;
import mulesoft.common.service.etl.AbstractMessageConverter;
import mulesoft.common.util.Files;
import mulesoft.service.html.Html;
import mulesoft.service.html.HtmlBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlReadMessageConverter
extends AbstractMessageConverter<Html> {
    @NotNull
    protected final Charset charset;

    public HtmlReadMessageConverter() {
        this(DEFAULT_CHARSET);
    }

    public HtmlReadMessageConverter(@NotNull Charset charset) {
        super(MediaType.TEXT_HTML);
        this.charset = charset;
    }

    @Override
    public boolean canWrite(Class<?> type, Type genericType, MediaType contentType) {
        return !this.isReadOnly() && super.canWrite(type, genericType, contentType);
    }

    @Override
    public Html read(Class<? extends Html> type, Type genericType, MediaType contentType, InputStream stream) throws IOException {
        Charset c = this.getContentTypeCharsetOrDefault(contentType, this.charset);
        String content = Files.readInput((Reader)new InputStreamReader(stream, c));
        HtmlBuilder builder = (HtmlBuilder)Context.getContext().getSingleton(HtmlBuilder.class);
        return (Html)builder.staticSource(content).build();
    }

    @Override
    public void write(Html content, @Nullable MediaType contentType, OutputStream stream) throws IOException {
        throw new IllegalStateException("HtmlReadMessageConverter is a read only html converter!");
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        return Html.class.isAssignableFrom(clazz);
    }

    protected boolean isReadOnly() {
        return true;
    }
}

