/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.common.service.etl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import mulesoft.common.media.MediaType;
import mulesoft.common.service.etl.AbstractMessageConverter;
import mulesoft.common.util.Files;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringMessageConverter
extends AbstractMessageConverter<String> {
    @NotNull
    private final Charset charset;

    public StringMessageConverter() {
        this(DEFAULT_CHARSET);
    }

    public StringMessageConverter(@NotNull Charset charset) {
        super(MediaType.TEXT_PLAIN);
        this.charset = charset;
    }

    @Override
    public String read(Class<? extends String> type, Type genericType, @Nullable MediaType contentType, InputStream stream) throws IOException {
        Charset c = this.getContentTypeCharsetOrDefault(contentType, this.charset);
        return Files.readInput((Reader)new InputStreamReader(stream, c));
    }

    @Override
    public void write(String content, MediaType mediaType, OutputStream stream) throws IOException {
        Charset c = this.getContentTypeCharsetOrDefault(mediaType, this.charset);
        OutputStreamWriter writer = new OutputStreamWriter(stream, c);
        writer.write(content);
        ((Writer)writer).flush();
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        return String.class.equals(clazz);
    }
}

