/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.common.service.etl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import mulesoft.common.logging.Logger;
import mulesoft.common.media.MediaType;
import mulesoft.common.service.etl.AbstractMessageConverter;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlMessageConverter
extends AbstractMessageConverter<Document> {
    @NotNull
    private final Charset charset;
    private static final Logger logger = Logger.getLogger(XmlMessageConverter.class);

    public XmlMessageConverter() {
        this(DEFAULT_CHARSET);
    }

    public XmlMessageConverter(@NotNull Charset charset) {
        super(MediaType.APPLICATION_XML, MediaType.TEXT_XML);
        this.charset = charset;
    }

    @Override
    public Document read(Class<? extends Document> type, Type genericType, MediaType contentType, InputStream stream) throws IOException {
        Charset c = this.getContentTypeCharsetOrDefault(contentType, this.charset);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = factory.newDocumentBuilder();
            InputSource source = new InputSource();
            source.setCharacterStream(new InputStreamReader(stream, c));
            return db.parse(source);
        }
        catch (ParserConfigurationException | SAXException e) {
            logger.error((Throwable)e);
            return null;
        }
    }

    @Override
    public void write(Document content, MediaType contentType, OutputStream stream) throws IOException {
        Charset c = this.getContentTypeCharsetOrDefault(contentType, this.charset);
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            OutputStreamWriter writer = new OutputStreamWriter(stream, c);
            transformer.transform(new DOMSource(content), new StreamResult(writer));
            writer.flush();
        }
        catch (TransformerException e) {
            logger.error((Throwable)e);
        }
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        return Document.class.isAssignableFrom(clazz);
    }
}

