/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.common.service.exception;

import java.util.List;
import mulesoft.common.collections.Colls;
import mulesoft.common.service.Status;
import org.jetbrains.annotations.NotNull;

public class ServiceException
extends RuntimeException {
    private final Status status;
    private static final long serialVersionUID = 2938773822301041984L;

    private ServiceException(Status status, String msg) {
        super(msg);
        this.status = status;
    }

    public Status getStatus() {
        return this.status;
    }

    public static ServiceException invalidParameter(String name, String kind, String value) {
        return new ServiceException(Status.BAD_REQUEST, String.format("Invalid parameter '%s' of type '%s' with value: %s", name, kind, value));
    }

    public static ServiceException requiredParameters(@NotNull List<String> parameters) {
        String s = "Missing required " + (parameters.size() > 1 ? "parameters: " : "parameter: ");
        return new ServiceException(Status.BAD_REQUEST, s + Colls.mkString(parameters, (String)","));
    }

    public static ServiceException unspecifiedContentLength() {
        return new ServiceException(Status.LENGTH_REQUIRED, "Unspecified Content-Length. Expected Content-Length for POST/PUT methods");
    }
}

