/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.common.tools.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.Nullable;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class ConcurrentRule
implements TestRule {
    @Nullable
    private CyclicBarrier allDone = null;
    @Nullable
    private CyclicBarrier allReady = null;
    private final List<AssertionError> assertionErrors = Collections.synchronizedList(new ArrayList());
    private final List<Throwable> exceptions = Collections.synchronizedList(new ArrayList());
    private final List<Future<?>> futures = new ArrayList();
    private final List<Consumer<Integer>> runnableList = new ArrayList<Consumer<Integer>>();
    private final AtomicBoolean startTimeout = new AtomicBoolean();
    private int startWait = 10;
    @Nullable
    private ExecutorService threadPool = null;
    private int waitTime = 5000;
    private static final int DEFAULT_WAIT_TIME = 5000;

    public int add(Consumer<Integer> r) {
        this.runnableList.add(r);
        return this.runnableList.size() - 1;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    base.evaluate();
                    ConcurrentRule.this.runAndWait();
                }
                finally {
                    if (ConcurrentRule.this.threadPool != null) {
                        ConcurrentRule.this.threadPool.shutdownNow();
                    }
                }
            }
        };
    }

    public void cancel(int n) {
        this.futures.get(n).cancel(true);
    }

    public Barrier createBarrier() {
        return new Barrier();
    }

    public <T> Exchanger<T> createExchanger() {
        return new Exchanger();
    }

    public synchronized void doWait(int ms) {
        try {
            this.wait(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void setStartingWaitByThread(int milliseconds) {
        this.startWait = milliseconds;
    }

    public void setWaitTime(int milliseconds) {
        this.waitTime = milliseconds;
    }

    private void markEnd() {
        try {
            if (this.allDone != null) {
                this.allDone.await();
            }
        }
        catch (InterruptedException | BrokenBarrierException exception) {
            // empty catch block
        }
    }

    private void runAndWait() throws InterruptedException {
        int n = this.runnableList.size();
        if (n == 0) {
            return;
        }
        this.threadPool = Executors.newFixedThreadPool(n);
        this.allReady = new CyclicBarrier(n);
        this.allDone = new CyclicBarrier(n + 1);
        this.futures.clear();
        for (Consumer<Integer> c : this.runnableList) {
            this.futures.add(this.threadPool.submit(this.runConsumer(c)));
        }
        boolean timeout = this.waitForExecution();
        if (this.startTimeout.get()) {
            Assertions.fail((String)"Timeout initializing threads! Perform long lasting initializations before starting them");
        }
        if (!this.assertionErrors.isEmpty()) {
            throw this.assertionErrors.get(0);
        }
        if (!this.exceptions.isEmpty()) {
            Assertions.fail((String)"Test failed with exception(s)", (Throwable)this.exceptions.get(0));
        }
        if (timeout) {
            Assertions.fail((String)"Timeout! waiting for finalization");
        }
    }

    private Runnable runConsumer(Consumer<Integer> r) {
        return () -> {
            if (this.allDone == null) {
                return;
            }
            try {
                int pos = this.waitForStartUp();
                if (pos >= 0) {
                    r.accept(pos);
                    this.markEnd();
                    return;
                }
            }
            catch (AssertionError e) {
                this.assertionErrors.add(e);
            }
            catch (Throwable e) {
                this.exceptions.add(e);
            }
            this.allDone.reset();
        };
    }

    private boolean waitForExecution() throws InterruptedException {
        boolean timeout = false;
        try {
            if (this.allDone != null) {
                this.allDone.await(this.waitTime, TimeUnit.MILLISECONDS);
            }
        }
        catch (BrokenBarrierException | TimeoutException ignore) {
            timeout = true;
        }
        return timeout;
    }

    private int waitForStartUp() {
        try {
            if (this.allReady != null) {
                return this.allReady.getParties() - this.allReady.await(this.startWait * this.runnableList.size(), TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException | BrokenBarrierException | TimeoutException e) {
            this.startTimeout.set(true);
        }
        return -1;
    }

    public static class Exchanger<T> {
        private final java.util.concurrent.Exchanger<T> e = new java.util.concurrent.Exchanger();

        public T exchange(T n) {
            try {
                return this.e.exchange(n);
            }
            catch (InterruptedException e1) {
                throw new AssertionError((Object)"Interrupted Exception");
            }
        }
    }

    public class Barrier {
        private CyclicBarrier b = null;

        public int await() {
            return this.doWait(0L);
        }

        public int await(long timeoutMillis) {
            return this.doWait(timeoutMillis);
        }

        private int doWait(long l) {
            if (this.b == null) {
                this.b = new CyclicBarrier(ConcurrentRule.this.runnableList.size());
            }
            try {
                int await = l == 0L ? this.b.await() : this.b.await(l, TimeUnit.MILLISECONDS);
                return this.b.getParties() - await;
            }
            catch (InterruptedException | BrokenBarrierException | TimeoutException e) {
                return -1;
            }
        }
    }
}

