/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.common.tools.test;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import mulesoft.common.logging.Logger;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class LoggerCollectRule
implements TestRule {
    private final Class<?>[] initialLoggers;
    private final List<String> loggerErrors = new ArrayList<String>();
    private final Handler collectorHandler = new Handler(){

        @Override
        public void publish(LogRecord record) {
            LoggerCollectRule.this.loggerErrors.add(record.getMessage());
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    };
    private final List<java.util.logging.Logger> loggers = new ArrayList<java.util.logging.Logger>();

    public LoggerCollectRule(Class<?> ... loggers) {
        this.initialLoggers = loggers;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                for (Class l : LoggerCollectRule.this.initialLoggers) {
                    LoggerCollectRule.this.collect(l);
                }
                try {
                    base.evaluate();
                }
                finally {
                    for (java.util.logging.Logger l : LoggerCollectRule.this.loggers) {
                        l.setUseParentHandlers(true);
                        l.removeHandler(LoggerCollectRule.this.collectorHandler);
                    }
                }
            }
        };
    }

    public void collect(Class<?> c) {
        java.util.logging.Logger l = Logger.getLogger(c).getTargetLogger();
        l.setUseParentHandlers(false);
        l.addHandler(this.collectorHandler);
        this.loggers.add(l);
    }

    public List<String> getLoggerErrors() {
        return this.loggerErrors;
    }
}

