/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.common.tools.test;

import java.util.HashMap;
import java.util.Map;
import mulesoft.common.Predefined;
import mulesoft.common.core.Option;
import mulesoft.common.core.Tuple;
import mulesoft.common.logging.Logger;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class MuteRule
implements TestRule {
    private final Class<?>[] initialLoggers;
    private final Map<String, Tuple<Logger, Option<Logger.Level>>> mutedLoggers = new HashMap<String, Tuple<Logger, Option<Logger.Level>>>();

    public MuteRule(Class<?> ... loggers) {
        this.initialLoggers = loggers;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                MuteRule.this.mutedLoggers.clear();
                for (Class l : MuteRule.this.initialLoggers) {
                    MuteRule.this.mute(l);
                }
                try {
                    base.evaluate();
                }
                finally {
                    MuteRule.this.mutedLoggers.values().forEach(x$0 -> MuteRule.restore((Tuple<Logger, Option<Logger.Level>>)x$0));
                }
            }
        };
    }

    public void mute(Class<?> logger) {
        Logger l = Logger.getLogger(logger);
        Logger.Level level = l.getLevel();
        l.setLevel(Logger.Level.OFF);
        this.mutedLoggers.put(logger.getName(), (Tuple<Logger, Option<Logger.Level>>)Tuple.tuple((Object)l, (Object)Predefined.option((Object)level)));
    }

    public void restore(Class<?> logger) {
        MuteRule.restore(this.mutedLoggers.remove(logger.getName()));
    }

    private static void restore(Tuple<Logger, Option<Logger.Level>> e) {
        if (e != null) {
            ((Option)e.second()).ifPresent(level -> ((Logger)e.first()).setLevel(level));
        }
    }
}

