/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.common.tools.test;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Random;
import mulesoft.common.collections.ImmutableList;
import mulesoft.common.collections.Seq;
import mulesoft.common.core.Option;
import mulesoft.common.util.Diff;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Tests {
    private Tests() {
    }

    public static boolean assertEquals(File outFile, File goldenFile) {
        try {
            return Diff.trimming().diff((Reader)new FileReader(outFile), (Reader)new FileReader(goldenFile)).isEmpty();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
    }

    @NotNull
    public static <T> T assertNotNull(@Nullable T e) {
        Assertions.assertThat(e).isNotNull();
        return e;
    }

    public static void checkDiff(File outFile, File goldenFile) {
        Option<String> diff = Tests.diff(outFile, goldenFile);
        if (diff.isPresent()) {
            Assertions.fail((String)((String)diff.get()));
        }
    }

    public static void checkDiff(File a, Reader b) {
        try {
            Tests.checkDiff(new FileReader(a), a.toString(), b, "");
        }
        catch (FileNotFoundException e) {
            Assertions.fail((String)("Cannot Open File: " + a));
        }
    }

    public static void checkDiff(String val1, String val2) {
        List diffs = Diff.trimming().diff(val1, val2);
        if (!diffs.isEmpty()) {
            Assertions.fail((String)("\n" + Diff.makeString((Iterable)diffs)));
        }
    }

    public static void checkDiff(File outFile, File goldenFile, Diff.Equals<String> comparator) {
        List diffs = Diff.stringDiffer(comparator).diff(outFile, goldenFile);
        if (!diffs.isEmpty()) {
            Assertions.fail((String)("\ndiff -y -W 150 " + outFile + " " + goldenFile + "\n" + Diff.makeString((Iterable)diffs)));
        }
    }

    public static Option<String> diff(File outFile, File goldenFile) {
        if (!goldenFile.exists()) {
            Assertions.fail((String)String.format("Cannot Open Golden File: \n%s\nfor comparing \n%s", goldenFile.getAbsolutePath(), outFile.getAbsolutePath()));
        }
        try {
            return Tests.diff(new FileReader(outFile), outFile.toString(), new FileReader(goldenFile), goldenFile.toString());
        }
        catch (FileNotFoundException e) {
            Assertions.fail((String)("Cannot Open Target or Golden File: " + e.getMessage()));
            return Option.empty();
        }
    }

    public static GoldenTest goldenCreate(File testFile, String outputDir) {
        return new GoldenTest(testFile, outputDir);
    }

    public static GoldenTest goldenCreate(String testName, String outputDir, String goldenDir) {
        return new GoldenTest(testName, outputDir, goldenDir);
    }

    public static Seq<Object[]> listFiles(@NotNull String dirName, @NotNull String pattern) {
        return Tests.listFiles(new File(dirName), pattern);
    }

    /*
     * Exception decompiling
     */
    public static Seq<Object[]> listFiles(@NotNull File dir, @NotNull String pattern) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String randomString(int length) {
        Random r = new Random();
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            result.append((char)(97 + r.nextInt(25)));
        }
        return result.toString();
    }

    public static void sleep(int millis) {
        System.out.printf("Sleeping %d ms....", millis);
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("\r ");
    }

    public static Seq<Object[]> wrapForParameters(@Nullable Object[] args) {
        return Tests.wrapForParameters(ImmutableList.fromArray((Object[])args));
    }

    /*
     * Exception decompiling
     */
    public static Seq<Object[]> wrapForParameters(ImmutableList<?> args) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getHostName() {
        try {
            String host = InetAddress.getLocalHost().getHostName().replaceAll("-", "");
            return host.substring(0, Math.min(Tests.index(host, Character.valueOf('.')), Math.min(Tests.index(host, Character.valueOf('_')), Tests.index(host, Character.valueOf('-')))));
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }

    private static void checkDiff(Reader a, String aName, Reader b, String bName) {
        ImmutableList diffs = Diff.ignoreAllSpace().diff(a, b);
        if (!diffs.isEmpty()) {
            Assertions.fail((String)("\ndiff -y -W 150 " + aName + " " + bName + "\n" + Diff.makeString((Iterable)diffs)));
        }
    }

    private static Option<String> diff(Reader a, String aName, Reader b, String bName) {
        ImmutableList diffs = Diff.ignoreAllSpace().diff(a, b);
        return diffs.isEmpty() ? Option.empty() : Option.of((Object)("\ndiff -y -W 150 " + aName + " " + bName + "\n" + Diff.makeString((Iterable)diffs)));
    }

    private static int index(String s, Character chr) {
        int n = s.indexOf(chr.charValue());
        return n <= 0 ? s.length() : n;
    }

    public static class GoldenTest {
        private final File goldenFile;
        private final File outputFile;

        private GoldenTest(File testFile, String outputDirName) {
            String name = testFile.getName();
            this.outputFile = this.createOutputFile(outputDirName, name);
            int dot = name.lastIndexOf(46);
            String bareName = dot == -1 ? name : name.substring(0, dot);
            this.goldenFile = new File(testFile.getParent(), bareName + ".golden");
        }

        private GoldenTest(String testName, String outputDirName, String goldenDirName) {
            this.outputFile = this.createOutputFile(outputDirName, testName);
            this.goldenFile = new File(goldenDirName, testName);
        }

        public void check() {
            Tests.checkDiff(this.outputFile, this.goldenFile);
        }

        public File getGoldenFile() {
            return this.goldenFile;
        }

        public File getOutputFile() {
            return this.outputFile;
        }

        private File createOutputFile(String outputDirName, String name) {
            File outputDir = new File(outputDirName);
            outputDir.mkdirs();
            return new File(outputDir, name);
        }
    }
}

