/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.common.tools.test;

import java.util.function.LongSupplier;
import mulesoft.common.core.DateTime;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class TimeProviderRule
implements TestRule {
    private long currentTime;

    public TimeProviderRule() {
        this.currentTime = 0L;
    }

    public TimeProviderRule(DateTime currentTime) {
        this.currentTime = currentTime.toMilliseconds();
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                LongSupplier oldProvider = DateTime.setTimeSupplier(TimeProviderRule.this::getCurrentTime);
                try {
                    base.evaluate();
                }
                finally {
                    DateTime.setTimeSupplier((LongSupplier)oldProvider);
                }
            }
        };
    }

    public void increment(long inc) {
        this.currentTime += inc;
    }

    public long getCurrentTime() {
        return this.currentTime;
    }

    public void setCurrentTime(long currentTIme) {
        this.currentTime = currentTIme;
    }
}

