/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.common.tools.test.server;

import mulesoft.common.Predefined;
import mulesoft.common.logging.Logger;
import mulesoft.common.media.MediaType;
import mulesoft.common.service.Headers;
import mulesoft.common.tools.test.server.CookiesAssertion;
import mulesoft.common.tools.test.server.HeadersAssertion;
import org.jetbrains.annotations.NotNull;

class BaseExpectation<This extends BaseExpectation<This>> {
    protected final Headers headers = new Headers();
    private CookiesAssertion cookiesAssertion;
    private HeadersAssertion headersAssertion = HeadersAssertion.DEFAULT_HEADERS_ASSERTION;
    private static final Logger logger = Logger.getLogger(BaseExpectation.class);

    BaseExpectation() {
        this.cookiesAssertion = CookiesAssertion.DEFAULT_COOKIES_ASSERTION;
    }

    public This withContentType(@NotNull MediaType contentType) {
        this.headers.setContentType(contentType);
        return this.This();
    }

    public This withCookiesAssertion(@NotNull CookiesAssertion assertion) {
        this.cookiesAssertion = assertion;
        return this.This();
    }

    public This withHeader(@NotNull String name, @NotNull String value) {
        this.headers.put(name, value);
        return this.This();
    }

    public This withHeadersAssertion(@NotNull HeadersAssertion assertion) {
        this.headersAssertion = assertion;
        return this.This();
    }

    void log(@NotNull String action) {
        logger.info(String.format("%s > %s%n", action, this.toString()));
    }

    CookiesAssertion getCookiesAssertion() {
        return this.cookiesAssertion;
    }

    Headers getHeaders() {
        return this.headers;
    }

    HeadersAssertion getHeadersAssertion() {
        return this.headersAssertion;
    }

    private This This() {
        return (This)((BaseExpectation)Predefined.cast((Object)this));
    }
}

