/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.common.tools.test.server;

import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.junit.rules.ExternalResource;

public class ConnectionTimeoutRule
extends ExternalResource {
    private ServerSocket serverSocket = null;
    private final boolean useIpTables = "Linux".equals(System.getProperty("os.name")) && new File("/sbin/iptables").exists();
    private static final String SBIN_IPTABLES = "/sbin/iptables";
    private static final String SUDO = "sudo";
    private static final String DPORT = "--dport";

    public String connectionUrl() {
        return "http://localhost:" + this.serverSocket.getLocalPort();
    }

    protected void after() {
        if (this.useIpTables) {
            try {
                new ProcessBuilder(SUDO, SBIN_IPTABLES, "-D", "INPUT", "-p", "tcp", DPORT, String.valueOf(this.serverSocket.getLocalPort()), "-j", "DROP").start().waitFor();
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
        }
        if (!this.serverSocket.isClosed()) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void before() throws Throwable {
        this.serverSocket = new ServerSocket(0, 1);
        new Socket().connect(this.serverSocket.getLocalSocketAddress());
        if (this.useIpTables) {
            try {
                new ProcessBuilder(SUDO, SBIN_IPTABLES, "-A", "INPUT", "-p", "tcp", DPORT, String.valueOf(this.serverSocket.getLocalPort()), "-j", "DROP").start().waitFor();
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
        }
    }
}

