/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.common.tools.test.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import mulesoft.common.Predefined;
import mulesoft.common.collections.Colls;
import mulesoft.common.collections.ImmutableList;
import mulesoft.common.collections.MultiMap;
import mulesoft.common.collections.Seq;
import mulesoft.common.logging.Logger;
import mulesoft.common.media.MediaType;
import mulesoft.common.media.Mime;
import mulesoft.common.service.Headers;
import mulesoft.common.service.Method;
import mulesoft.common.service.Parameters;
import mulesoft.common.service.Status;
import mulesoft.common.service.cookie.Cookie;
import mulesoft.common.service.cookie.Cookies;
import mulesoft.common.service.cookie.MutableCookie;
import mulesoft.common.service.server.Request;
import mulesoft.common.service.server.Response;
import mulesoft.common.tools.test.server.SgHttpServer;
import mulesoft.common.util.Files;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NioSgHttpServer {
    private ChannelFuture binding;
    private NioEventLoopGroup bossGroup;
    private final SgHttpServer.SgExpectationHandler expectations;
    private final int port;
    private final AtomicReference<ServerState> state;
    private NioEventLoopGroup workerGroup;
    private static final int MAX_CONTENT_LENGTH = 8192;
    private static final Logger logger = Logger.getLogger(NioSgHttpServer.class);
    private static final int MAX_CONNECTIONS = 1024;

    NioSgHttpServer(int port, SgHttpServer.SgExpectationHandler expectations) {
        this.port = port;
        this.expectations = expectations;
        this.state = new AtomicReference<ServerState>(ServerState.CREATED);
        this.binding = null;
        this.bossGroup = null;
        this.workerGroup = null;
    }

    void shutdown() throws InterruptedException {
        if (!this.state.compareAndSet(ServerState.STARTED, ServerState.SHUTDOWN)) {
            throw new IllegalStateException("The server is already shutdown or wasn't started: " + (Object)((Object)this.state.get()));
        }
        try {
            this.binding.channel().close().await();
        }
        finally {
            Future bf = this.bossGroup.shutdownGracefully();
            Future wf = this.workerGroup.shutdownGracefully();
            bf.await();
            wf.await();
        }
    }

    void start() {
        if (!this.state.compareAndSet(ServerState.CREATED, ServerState.STARTING)) {
            throw new IllegalStateException("Server already started");
        }
        int processors = Runtime.getRuntime().availableProcessors();
        this.bossGroup = new NioEventLoopGroup(processors, (ThreadFactory)this.createThreadFactory("Boss"));
        this.workerGroup = new NioEventLoopGroup(processors * 2, (ThreadFactory)this.createThreadFactory("Worker"));
        try {
            ServerBootstrap b = new ServerBootstrap();
            b.option(ChannelOption.SO_BACKLOG, (Object)1024);
            ((ServerBootstrap)((ServerBootstrap)b.group((EventLoopGroup)this.bossGroup, (EventLoopGroup)this.workerGroup).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.DEBUG))).childHandler((ChannelHandler)new SgServerInitializer(this.expectations));
            this.binding = b.bind(this.port).sync();
            if (!this.binding.isSuccess()) {
                throw new RuntimeException(this.binding.cause());
            }
            this.state.set(ServerState.STARTED);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    int getServerPort() {
        return this.port;
    }

    private DefaultThreadFactory createThreadFactory(String type) {
        return new DefaultThreadFactory(String.format("%s-Server-%d", type, this.port));
    }

    private static class SgServerInitializer
    extends ChannelInitializer<SocketChannel> {
        private final SgHttpServer.SgExpectationHandler expectations;

        private SgServerInitializer(SgHttpServer.SgExpectationHandler expectations) {
            this.expectations = expectations;
        }

        public void initChannel(SocketChannel ch) {
            ChannelPipeline p = ch.pipeline();
            p.addLast(new ChannelHandler[]{new HttpServerCodec()});
            p.addLast(new ChannelHandler[]{new HttpObjectAggregator(8192)});
            p.addLast(new ChannelHandler[]{new SgServerHandler(this.expectations)});
        }
    }

    private static class SgServerHandler
    extends SimpleChannelInboundHandler<FullHttpRequest> {
        private final SgHttpServer.SgExpectationHandler expectations;

        private SgServerHandler(SgHttpServer.SgExpectationHandler expectations) {
            this.expectations = expectations;
        }

        public void channelReadComplete(ChannelHandlerContext ctx) {
            ctx.flush();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            if (!(cause instanceof IOException) || !Predefined.equal((Object)cause.getMessage(), (Object)"Connection reset by peer")) {
                logger.error(cause);
            }
            ctx.close();
        }

        protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest req) throws Exception {
            try {
                NioSgResponse response = new NioSgResponse();
                this.expectations.handle(new NioSgRequest(req), response);
                FullHttpResponse resp = response.toHttpResponse();
                resp.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)resp.content().readableBytes());
                boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)req);
                if (keepAlive) {
                    resp.headers().set((CharSequence)"Connection", (Object)HttpHeaderValues.KEEP_ALIVE);
                    ctx.write((Object)resp);
                } else {
                    ctx.write((Object)resp).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                }
            }
            catch (Throwable cause) {
                FullHttpResponse resp = this.writeErrorResponse(cause);
                ctx.write((Object)resp).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }

        private FullHttpResponse writeErrorResponse(Throwable cause) {
            logger.error(cause);
            HttpResponseStatus status = cause instanceof AssertionError ? HttpResponseStatus.EXPECTATION_FAILED : HttpResponseStatus.INTERNAL_SERVER_ERROR;
            String message = cause.getLocalizedMessage();
            if (message == null) {
                message = cause.getClass().getCanonicalName();
            }
            ByteBuf content = Unpooled.wrappedBuffer((byte[])message.getBytes());
            return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, content);
        }
    }

    private static class NioSgResponse
    implements Response {
        private final Headers headers;
        private final ByteArrayOutputStream output = new ByteArrayOutputStream();
        private Status status;

        private NioSgResponse() {
            this.headers = new Headers();
            this.status = Status.OK;
        }

        @Override
        @NotNull
        public Response withContentType(@NotNull MediaType mime) {
            this.headers.setContentType(mime);
            return this;
        }

        @Override
        @NotNull
        public Response withContentType(@NotNull Mime mime, @NotNull Charset charset) {
            this.headers.setContentType(MediaType.forMimeWithEncoding(mime, charset.name()));
            return this;
        }

        @Override
        public MutableCookie withCookie(@NotNull String name, @NotNull String value) {
            throw new UnsupportedOperationException("NioSgResponse::withCookie not implemented.");
        }

        @Override
        @NotNull
        public Response withHeader(String name, String value) {
            this.headers.put(name, value);
            return this;
        }

        @Override
        public OutputStream getContent() throws IOException {
            return this.output;
        }

        @Override
        @NotNull
        public Headers getHeaders() {
            return this.headers;
        }

        @Override
        @NotNull
        public Status getStatus() {
            return this.status;
        }

        @Override
        public void setStatus(@NotNull Status status) {
            this.status = status;
        }

        private FullHttpResponse toHttpResponse() {
            HttpResponseStatus s = HttpResponseStatus.valueOf((int)this.status.code());
            DefaultFullHttpResponse result = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, s, Unpooled.wrappedBuffer((byte[])this.output.toByteArray()));
            this.writeHeaders(result.headers());
            return result;
        }

        private void writeHeaders(HttpHeaders h) {
            for (Map.Entry<String, Collection<String>> entry : this.headers.asMap().entrySet()) {
                h.add((CharSequence)entry.getKey(), (Iterable)entry.getValue());
            }
        }
    }

    private static class NioSgRequest
    implements Request {
        private final byte[] bytes;
        private final ByteBuf content;
        private final Seq<Cookie> cookies;
        private final Headers headers;
        private final Method method;
        private final MultiMap<String, String> parameters;
        private final String path;
        private final String scheme;
        private final String uri;
        private static final byte[] EMPTY_CONTENT = new byte[0];

        NioSgRequest(FullHttpRequest request) {
            this.method = Method.valueOf(request.method().name());
            this.uri = request.uri();
            this.scheme = request.protocolVersion().protocolName();
            QueryStringDecoder decoder = new QueryStringDecoder(request.uri());
            this.path = decoder.path();
            this.parameters = this.createParameters(decoder);
            this.content = request.content();
            this.bytes = this.cacheContent();
            this.headers = this.createHeaders(request.headers());
            this.cookies = this.createCookies(request.headers());
        }

        @Override
        public void close() {
            this.content.discardReadBytes();
        }

        public String toString() {
            return "(" + this.hashCode() + ")NioSgRequest{method=" + (Object)((Object)this.method) + ", path='" + this.path + '\'' + ", parameters=" + this.parameters + '}';
        }

        @Override
        public Object getAttribute(@NotNull String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public InputStream getContent() throws IOException {
            return new ByteArrayInputStream(this.bytes);
        }

        @Override
        public int getContentLength() {
            return this.content.capacity();
        }

        @Override
        public Seq<Cookie> getCookies() {
            return this.cookies;
        }

        @Override
        @NotNull
        public Headers getHeaders() {
            return this.headers;
        }

        @Override
        public Method getMethod() {
            return this.method;
        }

        @Override
        public MultiMap<String, String> getParameters() {
            return this.parameters;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public String getQueryString() {
            return Parameters.mapToQueryString(this.parameters);
        }

        @Override
        public String getScheme() {
            return this.scheme;
        }

        @Override
        public String getUri() {
            return this.path;
        }

        @Override
        public String getUrl() {
            return this.uri;
        }

        private byte[] cacheContent() {
            return this.content.capacity() != 0 ? Files.toByteArray((InputStream)new ByteBufInputStream(this.content)) : EMPTY_CONTENT;
        }

        private ImmutableList<Cookie> createCookies(@NotNull HttpHeaders h) {
            String header = h.get((CharSequence)HttpHeaderNames.COOKIE);
            return Predefined.isEmpty((String)header) ? Colls.emptyList() : Colls.immutable((Set)ServerCookieDecoder.LAX.decode(header)).map(cookie -> new NioRequestCookieAdapter((io.netty.handler.codec.http.cookie.Cookie)cookie)).toList();
        }

        private Headers createHeaders(@NotNull HttpHeaders h) {
            Headers result = new Headers();
            for (String header : h.names()) {
                result.putAll(header, h.getAll((CharSequence)header));
            }
            return result;
        }

        private MultiMap<String, String> createParameters(@NotNull QueryStringDecoder decoder) {
            MultiMap result = MultiMap.createMultiMap();
            for (Map.Entry p : decoder.parameters().entrySet()) {
                result.putAll(p.getKey(), (Iterable)p.getValue());
            }
            return result;
        }
    }

    private static class NioRequestCookieAdapter
    implements MutableCookie {
        private final io.netty.handler.codec.http.cookie.Cookie cookie;

        private NioRequestCookieAdapter(io.netty.handler.codec.http.cookie.Cookie cookie) {
            this.cookie = cookie;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof Cookie && Cookies.equal(this, (Cookie)o);
        }

        public int hashCode() {
            return Cookies.hash(this);
        }

        public String toString() {
            return Cookies.toString(this);
        }

        @Override
        public MutableCookie withDomain(@Nullable String domain) {
            this.cookie.setDomain(domain);
            return this;
        }

        @Override
        public MutableCookie withHttpOnly(boolean flag) {
            this.cookie.setHttpOnly(flag);
            return this;
        }

        @Override
        public MutableCookie withMaxAge(long seconds) {
            this.cookie.setMaxAge(seconds);
            return this;
        }

        @Override
        public MutableCookie withPath(@Nullable String path) {
            this.cookie.setPath(path);
            return this;
        }

        @Override
        public MutableCookie withSecure(boolean secure) {
            this.cookie.setSecure(secure);
            return this;
        }

        @Override
        public MutableCookie withValue(@NotNull String value) {
            this.cookie.setValue(value);
            return this;
        }

        @Override
        @Nullable
        public String getDomain() {
            return this.cookie.domain();
        }

        @Override
        public boolean isSecure() {
            return this.cookie.isSecure();
        }

        @Override
        public long getMaxAge() {
            long maxAge = this.cookie.maxAge();
            return maxAge == Long.MIN_VALUE ? -1L : maxAge;
        }

        @Override
        @NotNull
        public String getName() {
            return this.cookie.name();
        }

        @Override
        @Nullable
        public String getPath() {
            return this.cookie.path();
        }

        @Override
        @NotNull
        public String getValue() {
            return this.cookie.value();
        }

        @Override
        public boolean isHttpOnly() {
            return this.cookie.isHttpOnly();
        }
    }

    private static enum ServerState {
        CREATED,
        STARTING,
        STARTED,
        SHUTDOWN;

    }
}

