/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.common.tools.test.server;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import mulesoft.common.collections.MultiMap;
import mulesoft.common.core.Option;
import mulesoft.common.media.MediaType;
import mulesoft.common.service.Method;
import mulesoft.common.service.Status;
import mulesoft.common.service.cookie.Cookies;
import mulesoft.common.service.cookie.MutableCookie;
import mulesoft.common.service.server.Request;
import mulesoft.common.tools.test.server.BaseExpectation;
import mulesoft.common.tools.test.server.ResponseExpectation;
import org.jetbrains.annotations.NotNull;

public class RequestExpectation
extends BaseExpectation<RequestExpectation> {
    private Option<Object> content;
    private final List<MutableCookie> cookies;
    private boolean keep;
    private final Method method;
    private Option<MultiMap<String, String>> parameters;
    private Option<String> path;
    private Option<ResponseExpectation> response;
    private int times;

    RequestExpectation(Method method) {
        this.method = method;
        this.path = Option.empty();
        this.response = Option.empty();
        this.content = Option.empty();
        this.parameters = Option.empty();
        this.times = 1;
        this.cookies = new ArrayList<MutableCookie>();
    }

    public RequestExpectation keep() {
        this.keep = true;
        return this;
    }

    public boolean mustKeep() {
        return this.keep;
    }

    public RequestExpectation on(@NotNull String path) {
        this.path = Option.some((Object)path);
        return this;
    }

    public RequestExpectation repeated(int times) {
        this.times = times;
        return this;
    }

    public ResponseExpectation respond(@NotNull Status status) {
        ResponseExpectation r = new ResponseExpectation(status);
        this.response = Option.some((Object)r);
        return r;
    }

    public ResponseExpectation respond(@NotNull Status status, @NotNull Object content) {
        return this.respond(status).withContent(content);
    }

    public ResponseExpectation respondOk() {
        return this.respond(Status.OK);
    }

    public ResponseExpectation respondOkWith(@NotNull Object content) {
        return this.respondOk().withContent(content);
    }

    public ResponseExpectation respondOkWith(@NotNull Function<Request, Object> content) {
        return this.respondOk().withContent(content);
    }

    public ResponseExpectation respondRaw(@NotNull Status status, @NotNull byte[] content) {
        return this.respond(status).withRawContent(content);
    }

    public String toString() {
        return "(" + this.hashCode() + ")RequestExpectation{content=" + this.content + ", method=" + (Object)((Object)this.method) + ", parameters=" + this.parameters + ", path=" + this.path + ", response=" + this.response + ", times=" + this.times + '}';
    }

    public RequestExpectation withAccept(MediaType ... accepts) {
        this.headers.setAccept(accepts);
        return this;
    }

    public RequestExpectation withContent(@NotNull Object content) {
        assert (this.method == Method.POST || this.method == Method.PUT);
        this.content = Option.some((Object)content);
        return this;
    }

    public RequestExpectation withCookie(@NotNull String name, @NotNull String value) {
        this.cookies.add(Cookies.create(name, value));
        return this;
    }

    public RequestExpectation withParameter(@NotNull String key, @NotNull String value) {
        if (this.parameters.isPresent()) {
            ((MultiMap)this.parameters.get()).put((Object)key, (Object)value);
        } else {
            this.parameters = Option.some((Object)MultiMap.createMultiMap());
            ((MultiMap)this.parameters.get()).put((Object)key, (Object)value);
        }
        return this;
    }

    public RequestExpectation withParameters(@NotNull MultiMap<String, String> parameters) {
        this.parameters = Option.some(parameters);
        return this;
    }

    public RequestExpectation withSgAppToken(String token) {
        this.headers.set("X-Tek-App-Token", token);
        return this;
    }

    boolean consume() {
        return --this.times > 0;
    }

    Option<Object> getContent() {
        return this.content;
    }

    List<MutableCookie> getCookies() {
        return this.cookies;
    }

    Method getMethod() {
        return this.method;
    }

    Option<MultiMap<String, String>> getParameters() {
        return this.parameters;
    }

    Option<String> getPath() {
        return this.path;
    }

    ResponseExpectation getResponse() {
        return (ResponseExpectation)this.response.orElse((Object)ResponseExpectation.DEFAULT_RESPONSE);
    }

    int getTimes() {
        return this.times;
    }
}

