/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.common.tools.test.server;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import mulesoft.common.collections.Colls;
import mulesoft.common.core.Option;
import mulesoft.common.media.MediaType;
import mulesoft.common.service.Status;
import mulesoft.common.service.cookie.Cookie;
import mulesoft.common.service.cookie.Cookies;
import mulesoft.common.service.cookie.MutableCookie;
import mulesoft.common.service.server.Request;
import mulesoft.common.tools.test.server.BaseExpectation;
import org.jetbrains.annotations.NotNull;

public class ResponseExpectation
extends BaseExpectation<ResponseExpectation> {
    private Option<Function<Request, byte[]>> bytes;
    private Option<Function<Request, Object>> content;
    private final List<Cookie> cookies;
    private Option<Integer> delay;
    private final Status status;
    public static final ResponseExpectation DEFAULT_RESPONSE = (ResponseExpectation)new ResponseExpectation(Status.OK).withContentType(MediaType.TEXT_PLAIN);

    ResponseExpectation(Status status) {
        this.status = status;
        this.content = Option.empty();
        this.bytes = Option.empty();
        this.delay = Option.empty();
        this.cookies = new ArrayList<Cookie>();
    }

    public ResponseExpectation delay(int responseDelay) {
        this.delay = Option.some((Object)responseDelay);
        return this;
    }

    public String toString() {
        return "(" + this.hashCode() + ")ResponseExpectation{status=" + (Object)((Object)this.status) + ", content=" + this.content + ", delay=" + this.delay + ", cookies=" + Colls.mkString(this.cookies, (String)"[", (String)",", (String)"]") + '}';
    }

    public ResponseExpectation withContent(@NotNull Function<Request, Object> retriever) {
        this.content = Option.some(retriever);
        return this;
    }

    public ResponseExpectation withContent(@NotNull Object responseContent) {
        return this.withContent(this.constant(responseContent));
    }

    public MutableCookie withCookie(@NotNull String name, @NotNull String value) {
        MutableCookie cookie = Cookies.create(name, value);
        this.cookies.add(cookie);
        return cookie;
    }

    public ResponseExpectation withRawContent(@NotNull byte[] raw) {
        this.withRawContent(this.constant(raw));
        return this;
    }

    public ResponseExpectation withRawContent(@NotNull Function<Request, byte[]> retriever) {
        this.bytes = Option.some(retriever);
        return this;
    }

    Option<Function<Request, Object>> getContentFn() {
        return this.content;
    }

    Iterable<Cookie> getCookies() {
        return this.cookies;
    }

    Option<Integer> getDelay() {
        return this.delay;
    }

    Option<Function<Request, byte[]>> getRawContentFn() {
        return this.bytes;
    }

    Status getStatus() {
        return this.status;
    }

    private <T> Function<Request, T> constant(T constant) {
        return value -> constant;
    }
}

