/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.common.tools.test.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Function;
import mulesoft.common.Predefined;
import mulesoft.common.collections.Colls;
import mulesoft.common.collections.MultiMap;
import mulesoft.common.collections.Seq;
import mulesoft.common.core.Option;
import mulesoft.common.logging.Logger;
import mulesoft.common.media.MediaType;
import mulesoft.common.service.Headers;
import mulesoft.common.service.Method;
import mulesoft.common.service.OutboundMessageWriter;
import mulesoft.common.service.cookie.Cookie;
import mulesoft.common.service.cookie.Cookies;
import mulesoft.common.service.cookie.MutableCookie;
import mulesoft.common.service.etl.BasicTypeMessageConverter;
import mulesoft.common.service.etl.ByteMessageConverter;
import mulesoft.common.service.etl.FormMessageConverter;
import mulesoft.common.service.etl.MessageConverter;
import mulesoft.common.service.etl.StringMessageConverter;
import mulesoft.common.service.etl.XmlMessageConverter;
import mulesoft.common.service.server.Request;
import mulesoft.common.service.server.Response;
import mulesoft.common.tools.test.server.BaseExpectation;
import mulesoft.common.tools.test.server.CookiesAssertion;
import mulesoft.common.tools.test.server.ExpectationsConfiguration;
import mulesoft.common.tools.test.server.HeadersAssertion;
import mulesoft.common.tools.test.server.NioSgHttpServer;
import mulesoft.common.tools.test.server.RequestExpectation;
import mulesoft.common.tools.test.server.ResponseExpectation;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SgHttpServer {
    private final EnumSet<ExpectationsConfiguration> configuration;
    private final List<MessageConverter<?>> converters = new ArrayList();
    private final SgExpectationHandler handler;
    private final NioSgHttpServer server;
    public static final Logger logger = Logger.getLogger(SgHttpServer.class);

    SgHttpServer(int port, EnumSet<ExpectationsConfiguration> configuration) {
        this.configuration = configuration;
        this.handler = new SgExpectationHandler(this.converters, configuration);
        this.server = new NioSgHttpServer(port, this.handler);
        this.withConverter(new ByteMessageConverter());
        this.withConverter(new XmlMessageConverter());
        this.withConverter(new BasicTypeMessageConverter());
        this.withConverter(new StringMessageConverter());
        this.withConverter(new FormMessageConverter());
    }

    public void assertNoLeftExpectations() {
        ((IterableAssert)Assertions.assertThat((Iterable)Colls.immutable((Collection)this.handler.expectations).filter(e -> !e.mustKeep())).as("Some expectations are left behind!", new Object[0])).isEmpty();
    }

    void assertShutdownLeftExpectations() {
        if (this.configuration.contains((Object)ExpectationsConfiguration.FAIL_REMAINING)) {
            ((IterableAssert)Assertions.assertThat((Iterable)Colls.immutable((Collection)this.handler.expectations).filter(e -> !e.mustKeep())).as("Server is shutting down and some expectations are left behind!", new Object[0])).isEmpty();
        }
    }

    RequestExpectation expectRequest(@NotNull Method method) {
        RequestExpectation request = new RequestExpectation(method);
        this.handler.expect(request);
        return request;
    }

    void shutdown() {
        try {
            this.server.shutdown();
        }
        catch (InterruptedException e) {
            logger.error("Exception occurred while shutting down server", (Throwable)e);
        }
    }

    void start() {
        this.server.start();
    }

    void withConverter(@NotNull MessageConverter<?> converter) {
        this.converters.add(0, converter);
    }

    int getPort() {
        return this.server.getServerPort();
    }

    static class SgExpectationHandler {
        private final EnumSet<ExpectationsConfiguration> configuration;
        private final List<MessageConverter<?>> converters;
        private final ConcurrentLinkedDeque<RequestExpectation> expectations = new ConcurrentLinkedDeque();

        private SgExpectationHandler(List<MessageConverter<?>> converters, EnumSet<ExpectationsConfiguration> configuration) {
            this.converters = converters;
            this.configuration = configuration;
        }

        void handle(@NotNull Request request, @NotNull Response response) {
            ((IterableAssert)Assertions.assertThat(this.expectations).as("Received request %s but no expectations were defined!", new Object[]{request})).isNotEmpty();
            RequestExpectation expectation = this.match(request);
            if (expectation != null) {
                this.logExpectation("REQUEST MATCHED: ", expectation);
                this.queueRepetitions(expectation);
                this.createResponse(request, response, expectation.getResponse());
            }
            Assertions.assertThat((Object)expectation).as("Received request %s but no expectation matched!", new Object[]{request}).isNotNull();
        }

        private <T> boolean checkRequestContent(Request request, RequestExpectation expectation) {
            if (expectation.getContent().isEmpty()) {
                return false;
            }
            try {
                long length = request.getHeaders().getContentLength();
                ((AbstractLongAssert)Assertions.assertThat((long)length).as("Expected content on request", new Object[0])).isGreaterThan(0L);
                InputStream stream = request.getContent();
                Object expected = expectation.getContent().get();
                Class responseType = (Class)Predefined.cast(expected.getClass());
                Headers requestHeaders = expectation.getHeaders();
                MediaType contentType = requestHeaders.getContentType();
                MessageConverter<T> converter = this.getSuitableConverter(this.converters, contentType, responseType, responseType);
                if (converter == null) {
                    String message = "Could not extract response from request: no suitable converter found for response type " + responseType + " and content type '" + contentType + "'";
                    throw new RuntimeException(message);
                }
                T actual = converter.read(responseType, responseType, contentType, stream);
                Assertions.assertThat(actual).isEqualTo(expected);
            }
            catch (IOException e) {
                return false;
            }
            return true;
        }

        private boolean checkRequestCookies(Seq<Cookie> actual, List<MutableCookie> expected, CookiesAssertion assertion) {
            assertion.assertCookies((List<Cookie>)actual.toList(), (List)Predefined.cast(expected));
            return assertion != CookiesAssertion.DEFAULT_COOKIES_ASSERTION || !expected.isEmpty();
        }

        private boolean checkRequestHeaders(Headers actual, Headers expected, HeadersAssertion assertion) {
            assertion.assertHeaders(expected, actual);
            return assertion != HeadersAssertion.DEFAULT_HEADERS_ASSERTION || !expected.asMap().isEmpty();
        }

        private void checkRequestMethod(Method actual, Method expected) {
            ((AbstractCharSequenceAssert)Assertions.assertThat((String)actual.name()).as("Request method does not match", new Object[0])).isEqualTo((Object)expected.name());
        }

        private boolean checkRequestParameters(MultiMap<String, String> actual, Option<MultiMap<String, String>> expected) {
            if (expected.isPresent()) {
                for (Map.Entry entry : ((MultiMap)expected.get()).asMap().entrySet()) {
                    ((IterableAssert)Assertions.assertThat((Iterable)actual.get(entry.getKey())).as("Request parameter '%s'", new Object[]{entry.getKey()})).containsAll((Iterable)entry.getValue());
                }
                return true;
            }
            return false;
        }

        private boolean checkRequestPath(String path, Option<String> expected) {
            if (expected.isPresent()) {
                ((AbstractCharSequenceAssert)Assertions.assertThat((String)path).as("Request path does not match", new Object[0])).isEqualTo(expected.get());
                return true;
            }
            return false;
        }

        private void createResponse(Request request, Response response, ResponseExpectation expectation) {
            this.responseDelay(expectation);
            response.setStatus(expectation.getStatus());
            this.writeHeaders(expectation.getHeaders(), expectation.getCookies(), response);
            if (expectation.getRawContentFn().isPresent()) {
                byte[] content = (byte[])((Function)expectation.getRawContentFn().get()).apply(request);
                this.writeRawContent(response, content);
            } else if (expectation.getContentFn().isPresent()) {
                this.writeContent(response, ((Function)expectation.getContentFn().get()).apply(request));
            }
            Headers reqHeaders = request.getHeaders();
            if (reqHeaders.getFirst("X-OFFSET").isPresent()) {
                response.getHeaders().put("X-OFFSET", (String)reqHeaders.getFirst("X-OFFSET").get());
            }
            if (reqHeaders.getFirst("X-limit").isPresent()) {
                response.getHeaders().put("X-limit", (String)reqHeaders.getFirst("X-limit").get());
            }
            this.logExpectation("RETURNING RESPONSE: ", expectation);
        }

        private void expect(@NotNull RequestExpectation request) {
            this.expectations.add(request);
        }

        private void logExpectation(String action, @NotNull BaseExpectation<?> expectation) {
            if (this.configuration.contains((Object)ExpectationsConfiguration.VERBOSE)) {
                expectation.log(action);
            }
        }

        @Nullable
        private RequestExpectation match(@NotNull Request request) {
            return this.configuration.contains((Object)ExpectationsConfiguration.ORDERED) ? this.matchNextExpectation(request) : this.matchBestExpectation(request);
        }

        @Nullable
        private RequestExpectation matchBestExpectation(Request request) {
            ExpectationScore best = null;
            for (RequestExpectation expectation : this.expectations) {
                ExpectationScore score = ExpectationScore.calculate(this, request, expectation);
                best = score.pickBest(best);
            }
            if (best != null) {
                this.expectations.remove(best.expectation);
                return best.expectation;
            }
            for (RequestExpectation failed : this.expectations) {
                this.logExpectation("FAILED MATCH: ", failed);
            }
            return null;
        }

        @NotNull
        private RequestExpectation matchNextExpectation(Request request) {
            RequestExpectation expectation = this.expectations.poll();
            ExpectationScore.assertion(this, request, expectation);
            return expectation;
        }

        private void queueRepetitions(@NotNull RequestExpectation expectation) {
            if (this.configuration.contains((Object)ExpectationsConfiguration.REPEATABLE)) {
                this.expectations.addLast(expectation);
            } else if (expectation.consume() || expectation.mustKeep()) {
                this.expectations.addFirst(expectation);
            }
        }

        private void responseDelay(ResponseExpectation expectation) {
            for (Integer delay : expectation.getDelay()) {
                try {
                    if (delay <= 0) continue;
                    Thread.sleep(delay.intValue());
                }
                catch (InterruptedException e) {
                    throw new AssertionError("Interrupted!", e);
                }
            }
        }

        private void writeContent(Response response, Object content) {
            OutboundMessageWriter writer = new OutboundMessageWriter();
            try {
                writer.write(response, this.converters, content);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        private void writeHeaders(Headers headers, Iterable<Cookie> cookies, Response response) {
            Cookies.encodeServerCookies(response.getHeaders(), cookies);
            for (Map.Entry<String, Collection<String>> header : headers.asMap().entrySet()) {
                response.getHeaders().putAll(header.getKey(), (Iterable<String>)header.getValue());
            }
        }

        private void writeRawContent(Response response, byte[] content) {
            try {
                response.getContent().write(content);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        private <T> MessageConverter<T> getSuitableConverter(List<MessageConverter<?>> cs, MediaType contentType, Class<?> responseType, Class<?> genericType) {
            for (MessageConverter<?> converter : cs) {
                if (!converter.canRead(responseType, genericType, contentType)) continue;
                return (MessageConverter)Predefined.cast(converter);
            }
            return null;
        }
    }

    private static class ExpectationScore {
        private final RequestExpectation expectation;
        private final int scoring;

        private ExpectationScore(boolean fail, SgExpectationHandler h, Request r, RequestExpectation expectation) {
            this.expectation = expectation;
            this.scoring = this.scoring(fail, h, r);
        }

        public ExpectationScore pickBest(ExpectationScore other) {
            return this.scoring == 0 ? other : (other == null || other.scoring < this.scoring ? this : other);
        }

        private int scoring(boolean fail, SgExpectationHandler h, Request r) {
            int result = 8;
            try {
                h.checkRequestMethod(r.getMethod(), this.expectation.getMethod());
                if (h.checkRequestPath(r.getPath(), (Option<String>)this.expectation.getPath())) {
                    result += 4;
                }
                if (h.checkRequestParameters((MultiMap<String, String>)r.getParameters(), (Option<MultiMap<String, String>>)this.expectation.getParameters())) {
                    result += 2;
                }
                if (h.checkRequestCookies((Seq<Cookie>)r.getCookies(), this.expectation.getCookies(), this.expectation.getCookiesAssertion())) {
                    result += 2;
                }
                if (h.checkRequestHeaders(r.getHeaders(), this.expectation.getHeaders(), this.expectation.getHeadersAssertion())) {
                    result += 2;
                }
                if (h.checkRequestContent(r, this.expectation)) {
                    result += 2;
                }
            }
            catch (AssertionError error) {
                if (fail) {
                    throw error;
                }
                result = 0;
            }
            return result;
        }

        private static ExpectationScore assertion(SgExpectationHandler h, Request r, @NotNull RequestExpectation expectation) {
            return new ExpectationScore(true, h, r, expectation);
        }

        private static ExpectationScore calculate(SgExpectationHandler h, Request r, @NotNull RequestExpectation expectation) {
            return new ExpectationScore(false, h, r, expectation);
        }
    }
}

