/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.common.tools.test.server;

import java.util.EnumSet;
import mulesoft.common.logging.Logger;
import mulesoft.common.service.Call;
import mulesoft.common.service.Method;
import mulesoft.common.tools.test.server.ExpectationsConfiguration;
import mulesoft.common.tools.test.server.RequestExpectation;
import mulesoft.common.tools.test.server.ServerControl;
import mulesoft.common.tools.test.server.SgHttpServer;
import mulesoft.common.tools.test.server.SgHttpServerRuleBuilder;
import org.jetbrains.annotations.NotNull;
import org.junit.rules.ExternalResource;

public class SgHttpServerRule
extends ExternalResource {
    private final EnumSet<ExpectationsConfiguration> configuration;
    private final int port;
    private SgHttpServer server;
    public static final Logger logger = Logger.getLogger(SgHttpServerRule.class);

    SgHttpServerRule(int port, EnumSet<ExpectationsConfiguration> configuration) {
        this.port = port;
        this.configuration = configuration;
        this.server = new SgHttpServer(port, configuration);
    }

    public void assertNoLeftExpectations() {
        this.server.assertNoLeftExpectations();
    }

    public RequestExpectation expectCall(@NotNull Call call) {
        return this.expectRequest(call.getMethod()).on(call.getUrl());
    }

    public RequestExpectation expectCall(@NotNull Call call, @NotNull Object content) {
        return this.expectCall(call).withContent(content);
    }

    public RequestExpectation expectDelete() {
        return this.expectRequest(Method.DELETE);
    }

    public RequestExpectation expectDelete(@NotNull String path) {
        return this.expectDelete().on(path);
    }

    public RequestExpectation expectGet() {
        return this.expectRequest(Method.GET);
    }

    public RequestExpectation expectGet(@NotNull String path) {
        return this.expectGet().on(path);
    }

    public RequestExpectation expectHead() {
        return this.expectRequest(Method.HEAD);
    }

    public RequestExpectation expectHead(@NotNull String path) {
        return this.expectHead().on(path);
    }

    public RequestExpectation expectPost() {
        return this.expectRequest(Method.POST);
    }

    public RequestExpectation expectPost(@NotNull Object content) {
        return this.expectPost().withContent(content);
    }

    public RequestExpectation expectPost(@NotNull String path) {
        return this.expectPost().on(path);
    }

    public RequestExpectation expectPost(@NotNull String path, @NotNull Object content) {
        return this.expectPost(content).on(path);
    }

    public RequestExpectation expectPut() {
        return this.expectRequest(Method.PUT);
    }

    public RequestExpectation expectPut(@NotNull Object content) {
        return this.expectPut().withContent(content);
    }

    public RequestExpectation expectPut(@NotNull String path) {
        return this.expectPut().on(path);
    }

    public RequestExpectation expectPut(@NotNull String path, @NotNull Object content) {
        return this.expectPut(content).on(path);
    }

    public String getServerAddress() {
        return "http://localhost:" + this.getServerPort();
    }

    public ServerControl getServerControl() {
        return new ServerControl(){

            @Override
            public void start() {
                SgHttpServerRule.this.server = new SgHttpServer(SgHttpServerRule.this.port, SgHttpServerRule.this.configuration);
                SgHttpServerRule.this.server.start();
            }

            @Override
            public void shutdown() {
                SgHttpServerRule.this.server.shutdown();
            }
        };
    }

    public int getServerPort() {
        return this.server.getPort();
    }

    protected void after() {
        this.server.shutdown();
        this.server.assertShutdownLeftExpectations();
    }

    protected void before() throws Throwable {
        this.server.start();
    }

    private RequestExpectation expectRequest(Method method) {
        return this.server.expectRequest(method);
    }

    public static SgHttpServerRuleBuilder httpServerRule() {
        return new SgHttpServerRuleBuilder();
    }
}

