/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.common.tools.test.server;

import java.util.EnumSet;
import java.util.function.Consumer;
import mulesoft.common.core.Builder;
import mulesoft.common.core.Option;
import mulesoft.common.tools.test.server.ExpectationsConfiguration;
import mulesoft.common.tools.test.server.SgHttpServerRule;
import org.jetbrains.annotations.NotNull;

public class SgHttpServerRuleBuilder
implements Builder<SgHttpServerRule> {
    private final EnumSet<ExpectationsConfiguration> configuration;
    private Option<Consumer<SgHttpServerRule>> onShutdown = Option.empty();
    private Option<Consumer<SgHttpServerRule>> onStart = Option.empty();
    private int port = 8224;
    private static final int DEFAULT_PORT = 8224;

    SgHttpServerRuleBuilder() {
        this.configuration = EnumSet.of(ExpectationsConfiguration.ORDERED, ExpectationsConfiguration.UNIQUE, ExpectationsConfiguration.FAIL_REMAINING, ExpectationsConfiguration.SILENT);
    }

    public SgHttpServerRule build() {
        return new SgHttpServerRule(this.port, this.configuration){

            @Override
            protected void before() throws Throwable {
                super.before();
                for (Consumer block : SgHttpServerRuleBuilder.this.onStart) {
                    block.accept(this);
                }
            }

            @Override
            protected void after() {
                super.after();
                for (Consumer block : SgHttpServerRuleBuilder.this.onShutdown) {
                    block.accept(this);
                }
            }
        };
    }

    public SgHttpServerRuleBuilder ignoreRemaining() {
        return this.configuration(ExpectationsConfiguration.IGNORE_REMAINING);
    }

    public SgHttpServerRuleBuilder onShutdown(@NotNull Consumer<SgHttpServerRule> shutdown) {
        this.onShutdown = Option.some(shutdown);
        return this;
    }

    public SgHttpServerRuleBuilder onStart(@NotNull Consumer<SgHttpServerRule> start) {
        this.onStart = Option.some(start);
        return this;
    }

    public SgHttpServerRuleBuilder repeatable() {
        return this.configuration(ExpectationsConfiguration.REPEATABLE);
    }

    public SgHttpServerRuleBuilder unordered() {
        return this.configuration(ExpectationsConfiguration.UNORDERED);
    }

    public SgHttpServerRuleBuilder verbose() {
        return this.configuration(ExpectationsConfiguration.VERBOSE);
    }

    public SgHttpServerRuleBuilder withPort(int p) {
        this.port = p;
        return this;
    }

    private SgHttpServerRuleBuilder configuration(ExpectationsConfiguration c) {
        c.into(this.configuration);
        return this;
    }
}

