/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.codegen.common;

import java.util.ArrayList;
import mulesoft.codegen.impl.java.ClassGenerator;
import mulesoft.codegen.impl.java.JavaElement;
import mulesoft.common.collections.ImmutableCollection;
import mulesoft.common.collections.ImmutableList;
import mulesoft.common.collections.MultiMap;
import mulesoft.common.core.Option;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractMethods {
    @NotNull
    private final ClassGenerator cg;
    @NotNull
    private final MultiMap<String, JavaElement.Method> map = MultiMap.createSortedMultiMap();
    private static final JavaElement.Argument[] EMPTY = new JavaElement.Argument[0];

    public AbstractMethods(@NotNull ClassGenerator cg) {
        this.cg = cg;
    }

    public void add(String name, JavaElement.Method method) {
        this.map.put((Object)name, (Object)method);
    }

    public Iterable<JavaElement.Method> findAllMethods(String methodName) {
        return this.map.get((Object)methodName);
    }

    public JavaElement.Method generateAbstractMethod(String methodName, String type) {
        return this.generateAbstractMethod(methodName, type, EMPTY);
    }

    public JavaElement.Method generateAbstractMethod(String methodName, String type, JavaElement.Argument ... args) {
        JavaElement.Method method = (JavaElement.Method)((JavaElement.Method)this.cg.method(methodName, type).asAbstract()).notNull();
        ImmutableList.fromArray((Object[])args).forEach(x$0 -> method.arg(x$0));
        this.map.put((Object)methodName, (Object)method);
        return method;
    }

    public Option<JavaElement.Method> generateAbstractMethod(String methodName, String comment, String type) {
        return this.generateAbstractMethod(methodName, comment, type, EMPTY);
    }

    public Option<JavaElement.Method> generateAbstractMethod(String methodName, String comment, String type, JavaElement.Argument ... args) {
        if (methodName.isEmpty()) {
            return Option.empty();
        }
        JavaElement.Method method = this.findAnyMethod(methodName);
        if (method == null) {
            method = this.generateAbstractMethod(methodName, type, args);
        }
        method.withComments(new String[]{comment});
        return Option.some((Object)method);
    }

    public boolean has(String name) {
        return this.map.containsKey((Object)name);
    }

    public Iterable<JavaElement.Method> methods() {
        ArrayList<JavaElement.Method> set = new ArrayList<JavaElement.Method>();
        this.map.values().forEach(set::addAll);
        return set;
    }

    @Nullable
    private JavaElement.Method findAnyMethod(String methodName) {
        ImmutableCollection methods = this.map.get((Object)methodName);
        return (JavaElement.Method)methods.getFirst().getOrNull();
    }
}

