/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.codegen.common;

import java.math.BigDecimal;
import java.util.EnumSet;
import java.util.List;
import mulesoft.codegen.impl.java.ClassGenerator;
import mulesoft.codegen.impl.java.JavaElement;
import mulesoft.codegen.impl.java.JavaItemGenerator;
import mulesoft.common.collections.Colls;
import mulesoft.common.collections.Seq;
import mulesoft.common.core.DateOnly;
import mulesoft.common.core.DateTime;
import mulesoft.common.core.Decimals;
import mulesoft.common.core.Integers;
import mulesoft.common.core.Reals;
import mulesoft.common.core.Strings;
import mulesoft.expr.Expression;
import mulesoft.field.ModelField;
import mulesoft.field.Signed;
import mulesoft.field.TypeField;
import mulesoft.type.ArrayType;
import mulesoft.type.DecimalType;
import mulesoft.type.EnumType;
import mulesoft.type.IntType;
import mulesoft.type.StringType;
import mulesoft.type.Type;

public class Generators {
    private static final String EPOCH = "EPOCH";
    private static final String ZERO = "ZERO";

    private Generators() {
    }

    public static String defaultFor(ClassGenerator cg, TypeField field, boolean required) {
        Expression expression = field.getDefaultValue();
        if (!expression.isNull() && expression.isConstant()) {
            return Generators.defaultFor(cg, field, expression);
        }
        if (required) {
            return Generators.defaultFor(cg, field);
        }
        return "null";
    }

    public static String enumsetNoneOf(JavaItemGenerator<?> cg, String enumType) {
        return cg.invokeStatic(EnumSet.class, "noneOf", new String[]{cg.classOf(enumType)});
    }

    public static Seq<JavaElement.Argument> makeArguments(List<JavaElement.Field> fields) {
        return Colls.seq(fields).map(f -> (JavaElement.Argument)new JavaElement.Argument(f.getName(), f.getType()).required(f.isNotNull()));
    }

    public static Seq<JavaElement.Argument> makeArguments(Seq<? extends TypeField> attributes, boolean required) {
        Seq r = attributes.map(f -> (JavaElement.Argument)new JavaElement.Argument(f.getName(), f.getImplementationClassName()).required(required || f.isRequired()));
        return r;
    }

    public static <M extends ModelField & Signed> String verifyField(ClassGenerator g, String name, M field) {
        Type t = field.getFinalType();
        Type type = t.isArray() ? ((ArrayType)t).getElementType() : t;
        return Generators.verifyField(g, name, field, type);
    }

    static Seq<String> fieldNames(Seq<? extends ModelField> fields) {
        return fields.map(ModelField::getName);
    }

    private static String defaultFor(JavaItemGenerator<?> cg, TypeField typeField) {
        Type type = typeField.getFinalType();
        switch (type.getKind()) {
            case BOOLEAN: {
                return String.valueOf(false);
            }
            case STRING: {
                return Strings.quoted((String)"");
            }
            case REAL: {
                return "0.0";
            }
            case INT: {
                return "0";
            }
            case DECIMAL: {
                return cg.refStatic(BigDecimal.class, ZERO);
            }
            case DATE_TIME: {
                return cg.refStatic(DateTime.class, EPOCH);
            }
            case DATE: {
                return cg.refStatic(DateOnly.class, EPOCH);
            }
            case ENUM: {
                EnumType et = (EnumType)type;
                String enumType = et.getImplementationClassName();
                if (typeField.isMultiple()) {
                    return Generators.enumsetNoneOf(cg, enumType);
                }
                return cg.refStatic(et.getImplementationClassName(), et.getDefaultValue());
            }
        }
        return "null";
    }

    private static String defaultFor(JavaItemGenerator<?> cg, TypeField field, Expression constant) {
        String defaultValue = constant.toString();
        switch (field.getFinalType().getKind()) {
            case ENUM: {
                String enumValue = cg.extractImport(field.getImplementationClassName()) + "." + defaultValue;
                return field.isMultiple() ? cg.invokeStatic(EnumSet.class, "of", new String[]{enumValue}) : enumValue;
            }
            case DECIMAL: {
                return "0".equals(defaultValue) || "0.0".equals(defaultValue) ? cg.refStatic(BigDecimal.class, ZERO) : cg.new_(BigDecimal.class, new String[]{Strings.quoted((String)defaultValue)});
            }
            case DATE_TIME: 
            case DATE: {
                return "null";
            }
        }
        return defaultValue;
    }

    private static String str(int n) {
        return String.valueOf(n);
    }

    private static <M extends ModelField & Signed> String verifyField(ClassGenerator g, String name, M field, Type type) {
        switch (type.getKind()) {
            case STRING: {
                StringType s = (StringType)type;
                return g.invokeStatic(Strings.class, "truncate", new String[]{name, Generators.str((Integer)s.getLength().get())});
            }
            case DECIMAL: {
                DecimalType decimal = (DecimalType)type;
                Boolean signedDecimal = ((Signed)field).isSigned();
                return g.invokeStatic(Decimals.class, "scaleAndCheck", new String[]{Strings.quoted((String)name), name, signedDecimal.toString(), Generators.str(decimal.getPrecision()), Generators.str(decimal.getDecimals())});
            }
            case INT: {
                IntType integer = (IntType)type;
                Boolean signedInt = ((Signed)field).isSigned();
                return g.invokeStatic(Integers.class, "checkSignedLength", new String[]{Strings.quoted((String)name), name, signedInt.toString(), ((Integer)integer.getLength().get()).toString()});
            }
            case REAL: {
                Boolean signedReal = ((Signed)field).isSigned();
                return g.invokeStatic(Reals.class, "checkSigned", new String[]{Strings.quoted((String)name), name, signedReal.toString()});
            }
        }
        return name;
    }
}

