/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.codegen.context;

import java.util.List;
import mulesoft.codegen.common.MMCodeGenConstants;
import mulesoft.codegen.common.MMCodeGenerator;
import mulesoft.codegen.impl.java.InterfaceGenerator;
import mulesoft.codegen.impl.java.JavaCodeGenerator;
import mulesoft.codegen.impl.java.JavaElement;
import mulesoft.common.collections.Seq;
import mulesoft.field.ModelField;
import mulesoft.field.TypeField;
import mulesoft.metadata.entity.StructType;
import mulesoft.type.ArrayType;
import mulesoft.type.InterfaceType;
import mulesoft.type.Kind;
import mulesoft.type.ModelType;
import org.jetbrains.annotations.NotNull;

public class InterfaceTypeCodeGenerator
extends InterfaceGenerator
implements MMCodeGenerator {
    protected final StructType type;

    public InterfaceTypeCodeGenerator(JavaCodeGenerator cg, @NotNull StructType type) {
        super(cg, type.getName());
        this.type = type;
    }

    @Override
    public String getSourceName() {
        return this.type.getSourceName();
    }

    protected void populate() {
        this.withComments(new String[]{"Generated interface for context: " + this.type.getName() + "."});
        this.withComments(new String[]{"Don't modify this as this is an auto generated class that's gets generated"});
        this.withComments(new String[]{"every time the meta model file is modified."});
        this.suppressWarnings(MMCodeGenConstants.COMMON_SUPPRESSED_WARNINGS);
        Seq superTypes = this.type.getSuperTypes().map(ModelType::getFullName);
        if (superTypes.isEmpty()) {
            this.withInterfaces(new String[]{InterfaceType.class.getName()});
        } else {
            for (String superType : superTypes) {
                this.withInterfaces(new String[]{superType});
            }
        }
        this.addMethods();
        super.populate();
    }

    private void addMethods() {
        for (ModelField field : this.type.getChildren()) {
            this.addMethods((TypeField)field);
        }
    }

    private void addMethods(@NotNull TypeField field) {
        String name = field.getName();
        String t = this.getImplementationClassName(field);
        boolean required = field.isRequired();
        JavaElement.Method setter = this.setter(name, this.type.getImplementationClassName());
        setter.boxedNotNull();
        setter.arg(name, t).required(field.isRequired());
        setter.withSetterComments(name);
        setter.asInterfaceMethod();
        ((JavaElement.Method)((JavaElement.Method)this.getter(name, t).asInterfaceMethod()).withGetterComments(name)).required(required);
    }

    private String getImplementationClassName(TypeField field) {
        if (field.getType().getKind() == Kind.ARRAY) {
            return this.generic(List.class, new String[]{((ArrayType)field.getType()).getElementType().getImplementationClassName()});
        }
        return field.getImplementationClassName();
    }
}

