/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.codegen.entity;

import java.util.EnumSet;
import mulesoft.codegen.CodeGeneratorConstants;
import mulesoft.codegen.common.Generators;
import mulesoft.codegen.common.MMCodeGenConstants;
import mulesoft.codegen.entity.DbTableCodeGenerator;
import mulesoft.codegen.entity.EntityBaseCodeGenerator;
import mulesoft.codegen.impl.java.ClassGenerator;
import mulesoft.codegen.impl.java.JavaElement;
import mulesoft.common.collections.Colls;
import mulesoft.common.collections.ImmutableIterator;
import mulesoft.common.collections.ImmutableList;
import mulesoft.common.collections.Seq;
import mulesoft.common.core.Constants;
import mulesoft.common.core.QName;
import mulesoft.common.core.Strings;
import mulesoft.common.core.Tuple;
import mulesoft.field.FieldOption;
import mulesoft.field.TypeField;
import mulesoft.md.MdConstants;
import mulesoft.metadata.entity.Attribute;
import mulesoft.metadata.entity.DbObject;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class AttributeGenerator {
    private final Attribute attr;
    private final String attrName;
    private String classForField;
    private final String className;
    private final DbObject dbObject;
    private boolean fieldAsProtected;
    private String markAsModified;
    private final EntityBaseCodeGenerator tg;
    @NonNls
    private static final String SOLVE = "solve";
    @NonNls
    private static final String SOLVE_OR_FAIL = "solveOrFail";

    AttributeGenerator(EntityBaseCodeGenerator tg, String className, Attribute attr) {
        this.attr = attr;
        this.dbObject = tg.dbObject;
        this.className = className;
        this.attrName = attr.getName();
        this.tg = tg;
        this.markAsModified = "";
        this.fieldAsProtected = false;
        this.classForField = "this";
    }

    void generate(ClassGenerator target) {
        if (this.isAbstract()) {
            this.createField(target);
        } else if (this.attr.isMultiple()) {
            this.addMultiple(target);
        } else if (this.attr.isEntity() || this.attr.isView()) {
            this.addReference(target);
        } else {
            this.createField(target);
        }
    }

    void generateMutableSetter(boolean hasDataField) {
        String[] stringArray;
        if (hasDataField) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "_data";
        } else {
            stringArray = Constants.EMPTY_STRING_ARRAY;
        }
        this.markAsModified = this.invoke("", "markAsModified", stringArray);
        this.generateSetter();
    }

    void generatePk(ImmutableList.Builder<JavaElement.Field> fieldList, ClassGenerator target) {
        for (TypeField field : this.attr.retrieveSimpleFields()) {
            String fieldName = field.getName();
            String fieldType = field.getImplementationClassName();
            fieldList.add((Object)this.attributeField(this.dataField(fieldName, fieldType, target), field, true));
        }
        this.addReferenceAttribute();
    }

    void generateSetter() {
        if (!this.dbObject.isUpdatable() || this.attr.isReadOnly() || this.dbObject.isPrimaryKey(this.attr)) {
            return;
        }
        if (this.isAbstract()) {
            this.addSetter();
        } else if (this.attr.isMultiple()) {
            this.attr.asEnum().ifPresent(e -> this.addSetter(this.tg.generic(EnumSet.class, new String[]{this.attr.getImplementationClassName()}), true));
        } else if (this.attr.isEntity() || this.attr.isView()) {
            this.addReferenceSetter();
        } else {
            this.addSetter();
        }
    }

    void setClassForField(String classForField) {
        this.classForField = classForField;
    }

    void setFieldAsProtected() {
        this.fieldAsProtected = true;
    }

    private void addMultiple(ClassGenerator target) {
        this.attr.asDatabaseObject().ifPresent(e -> {
            for (Attribute foreign : e.getAttribute(this.attr.getReverseReference())) {
                if (this.attr.isInner()) {
                    this.addSeqField(foreign, "mulesoft.persistence.InnerEntitySeq");
                    continue;
                }
                this.addSeqField(foreign, "mulesoft.persistence.EntitySeq");
            }
        });
        this.attr.asEnum().ifPresent(e -> {
            String enumType = this.attr.getImplementationClassName();
            String type = this.tg.generic(EnumSet.class, new String[]{enumType});
            String defaultValue = this.tg.defaultFor(this.tg, (TypeField)this.attr, true);
            if (!this.isAbstract()) {
                ((JavaElement.Field)this.dataField(this.attrName, type, target).required(true)).withValue(defaultValue);
            }
            this.createGetter(this.attrName, type, true, defaultValue);
        });
    }

    private void addReference(ClassGenerator target) {
        for (TypeField typeField : this.attr.retrieveSimpleFields()) {
            this.attributeField(this.dataField(typeField.getName(), typeField.getImplementationClassName(), target), typeField, typeField.isRequired());
        }
        this.addReferenceAttribute();
    }

    private void addReferenceAttribute() {
        this.attr.asDatabaseObject().ifPresent(ref -> {
            String type = ref.getImplementationClassName();
            String refType = this.tg.generic("mulesoft.persistence.EntityRef", new String[]{type, EntityBaseCodeGenerator.makePrimaryKeyType(this.tg, ref)});
            ImmutableList attrFields = this.attr.retrieveSimpleFields();
            String reverse = this.attr.getReverseReference();
            String value = this.tg.newGeneric("mulesoft.persistence.EntityRef", new String[]{this.tg.extractStaticImport(DbTableCodeGenerator.singletonName(ref)), reverse.isEmpty() ? null : this.tg.refMethod(type, Strings.getterName((String)reverse))});
            ((JavaElement.Field)this.tg.field(this.attrName, refType).required(true)).withValue(value).asPackagePrivate();
            this.tg.addReference(this.attrName, value);
            ((JavaElement.Method)((JavaElement.Method)((JavaElement.Method)this.tg.method(Strings.getterName((String)this.attrName, (String)type), type).required(this.attr.isRequired())).withGetterComments(this.attrName)).addModifier(this.isProtected() ? 4 : 1)).return_((CharSequence)this.invokeSolve(this.attrName, (Seq<TypeField>)attrFields));
        });
    }

    private void addReferenceSetter() {
        for (TypeField typeField : this.attr.retrieveSimpleFields()) {
            String fieldName = typeField.getName();
            JavaElement.Method method = (JavaElement.Method)((JavaElement.Method)((JavaElement.Method)this.tg.method(Strings.setterName((String)fieldName), this.className).withSetterComments(fieldName)).addModifier(this.isProtected() ? 4 : 1)).notNull();
            method.arg(fieldName, typeField.getImplementationClassName()).required(typeField.isRequired());
            ((JavaElement.Method)((JavaElement.Method)method.statement(this.invoke(this.attrName, "invalidate", new String[0]))).assign(this.dataRef(typeField), fieldName)).return_((CharSequence)this.tg.referenceThisType("this"));
        }
        this.attr.asDatabaseObject().ifPresent(this::addRefSetter);
    }

    private void addRefSetter(DbObject ref) {
        boolean nullable = !this.attr.isRequired();
        JavaElement.Method setter = (JavaElement.Method)((JavaElement.Method)((JavaElement.Method)this.tg.method(Strings.setterName((String)this.attrName), this.className).required(!nullable)).withSetterComments(this.attrName)).notNull();
        setter.arg(this.attrName, ref.getImplementationClassName()).required(!nullable);
        if (this.isProtected()) {
            setter.asProtected();
        }
        setter.statement(this.invoke(this.THIS(this.attrName), "set", this.attrName));
        ImmutableList attrFields = this.attr.retrieveSimpleFields();
        if (nullable) {
            setter.suppressWarnings(new String[]{MMCodeGenConstants.ASSIGNMENT_TO_NULL});
            setter.startIf(this.attrName + " == null");
            for (TypeField f : attrFields) {
                setter.assign(this.dataRef(f), "null");
            }
            setter.startElse();
        }
        ImmutableIterator refFields = ref.retrieveSimpleFields().iterator();
        for (TypeField f : attrFields) {
            TypeField refField = (TypeField)refFields.next();
            setter.assign(this.dataRef(f), this.invoke(this.attrName, Strings.getterName((String)refField.getName(), (String)refField.getImplementationClassName()), new String[0]));
        }
        if (nullable) {
            setter.endIf();
        }
        setter.return_((CharSequence)this.tg.referenceThisType("this"));
    }

    private void addSeqField(@NotNull Attribute foreign, String clazz) {
        String type = this.attr.getElementClassName();
        String seqType = this.tg.generic(clazz, new String[]{type});
        String singleton = this.tg.extractStaticImport(DbTableCodeGenerator.singletonName((DbObject)this.attr.asDatabaseObject().get()));
        boolean inner = clazz.equals("mulesoft.persistence.InnerEntitySeq");
        String thisType = this.tg.referenceThisType("this");
        ImmutableList args = Colls.listOf((Object)singleton, (Object)thisType, (Object)this.getRefFunction(foreign));
        String ref = inner ? this.tg.invokeStatic(QName.createQName((String)"mulesoft.persistence.EntitySeq").append("createInnerEntitySeq"), (Iterable)args) : this.tg.invokeStatic(QName.createQName((String)"mulesoft.persistence.EntitySeq").append("createEntitySeq"), (Iterable)args.append((Object)this.tg.invokeListOf(foreign.retrieveSimpleFields().map(tf -> singleton + "." + Strings.fromCamelCase((String)tf.getName())))));
        String name = this.attrName;
        JavaElement.Field f = ((JavaElement.Field)this.tg.field(name, seqType).notNull()).withValue(ref);
        this.tg.addReference(f.getName(), ref);
        ((JavaElement.Method)((JavaElement.Method)((JavaElement.Method)this.tg.method(Strings.getterName((String)name, (String)seqType), seqType).notNull()).addModifier(this.isProtected() ? 4 : 1)).withGetterComments(name)).return_((CharSequence)name);
    }

    private void addSetter() {
        this.addSetter(this.attr.getImplementationClassName(), this.attr.isRequired());
    }

    private void addSetter(String attrType, boolean required) {
        JavaElement.Method setter = (JavaElement.Method)((JavaElement.Method)((JavaElement.Method)this.tg.method(Strings.setterName((String)this.attrName), this.tg.className).withSetterComments(this.attrName)).addModifier(this.isProtected() ? 4 : 1)).notNull();
        setter.arg(this.attrName, attrType).required(required);
        if (this.isAbstract()) {
            setter.asAbstract();
        } else {
            if (!this.markAsModified.isEmpty()) {
                setter.statement(this.markAsModified);
            }
            setter.assign(this.dataRef((TypeField)this.attr), Generators.verifyField(this.tg, this.attrName, this.attr));
            setter.return_((CharSequence)this.tg.referenceThisType("this"));
        }
    }

    private JavaElement.Field attributeField(JavaElement.Field f, TypeField field, boolean required) {
        String defaultValue = this.tg.defaultFor(this.tg, field, required);
        ((JavaElement.Field)f.required(required)).withValue(defaultValue);
        this.createGetter(f.getName(), f.getType(), required, defaultValue);
        return f;
    }

    private void createField(ClassGenerator target) {
        String type = this.attr.getImplementationClassName();
        boolean required = this.attr.isRequired();
        if (this.isAbstract()) {
            this.createGetter(this.attrName, type, required, "");
        } else {
            String defaultValue = this.tg.defaultFor(this.tg, (TypeField)this.attr, required);
            ((JavaElement.Field)this.dataField(this.attrName, type, target).required(required)).withValue(defaultValue);
            this.createGetter(this.attrName, type, required, defaultValue);
        }
    }

    private void createGetter(String name, String type, boolean required, String defaultValue) {
        JavaElement.Method getter = (JavaElement.Method)((JavaElement.Method)((JavaElement.Method)((JavaElement.Method)((JavaElement.Method)this.tg.method(Strings.getterName((String)name, (String)type), type).required(required)).addModifier(this.isProtected() ? 4 : 1)).addModifier(this.isAbstract() ? 1024 : 0)).withGetterComments(name)).return_((CharSequence)this.dataRef(name));
        if (MdConstants.isVersionField((String)name)) {
            getter.override();
        }
        if (required && "null".equals(defaultValue)) {
            getter.suppressWarnings(new String[]{MMCodeGenConstants.NULLABLE_PROBLEMS});
        }
    }

    private JavaElement.Field dataField(String fieldName, String fieldType, ClassGenerator target) {
        JavaElement.Field field = target.field(fieldName, fieldType);
        if (this.fieldAsProtected) {
            field.asProtected();
        } else {
            field.asPackagePrivate();
        }
        return field;
    }

    @NotNull
    private String dataRef(TypeField tf) {
        return this.dataRef(tf.getName());
    }

    @NotNull
    private String dataRef(String name) {
        return this.classForField + "." + name;
    }

    private String invoke(String targetEntity, String method, String ... args) {
        return this.tg.invoke(targetEntity, method, args);
    }

    private String invokeSolve(String name, Seq<TypeField> attrFields) {
        if (attrFields.size() == 1) {
            return this.invoke(name, this.attr.isRequired() ? SOLVE_OR_FAIL : SOLVE, this.dataRef((TypeField)attrFields.getFirst().get()));
        }
        ImmutableList args = attrFields.map(this::dataRef).toList();
        String makeTuple = this.tg.invokeStatic(Tuple.class, CodeGeneratorConstants.tupleMethod((int)args.size()), (Iterable)args);
        if (this.attr.isRequired()) {
            return this.invoke(name, SOLVE_OR_FAIL, makeTuple);
        }
        String condition = attrFields.filter(TypeField::isOptional).map(tf -> this.dataRef((TypeField)tf) + " == null").mkString(" || ");
        return condition + " ? null : " + this.invoke(name, SOLVE, makeTuple);
    }

    private String THIS(String field) {
        return "this." + field;
    }

    private boolean isProtected() {
        return this.attr.hasOption(FieldOption.PROTECTED) || this.dbObject.isProtected() && !MdConstants.isVersionField((String)this.attrName);
    }

    private String getRefFunction(@NotNull Attribute foreign) {
        String ownerRef = foreign.getName();
        QName childType = QName.createQName((String)foreign.getDbObject().getImplementationClassName());
        QName parentType = QName.createQName((String)this.tg.getDbObject().getImplementationClassName());
        if (!parentType.getQualification().equals(childType.getQualification())) {
            return this.tg.invokeStatic(QName.createQName((String)"mulesoft.persistence.EntityRef").append("getRefFunction"), new String[]{this.tg.classOf(childType.getFullName()), Strings.quoted((String)ownerRef)});
        }
        return String.format("c -> ((%sBase)c).%s", childType.getName(), foreign.getName());
    }

    private boolean isAbstract() {
        return this.attr.hasOption(FieldOption.ABSTRACT);
    }
}

