/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.codegen.entity;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import mulesoft.cache.CacheType;
import mulesoft.codegen.CodeGeneratorConstants;
import mulesoft.codegen.common.MMCodeGenConstants;
import mulesoft.codegen.common.MMCodeGenerator;
import mulesoft.codegen.entity.EntityBaseCodeGenerator;
import mulesoft.codegen.impl.java.ClassGenerator;
import mulesoft.codegen.impl.java.JavaCodeGenerator;
import mulesoft.codegen.impl.java.JavaElement;
import mulesoft.codegen.impl.java.JavaItemGenerator;
import mulesoft.common.Predefined;
import mulesoft.common.collections.Colls;
import mulesoft.common.collections.Maps;
import mulesoft.common.collections.Seq;
import mulesoft.common.core.Option;
import mulesoft.common.core.QName;
import mulesoft.common.core.Strings;
import mulesoft.common.core.Tuple;
import mulesoft.field.FieldOption;
import mulesoft.field.TypeField;
import mulesoft.metadata.entity.Attribute;
import mulesoft.metadata.entity.DbObject;
import mulesoft.metadata.entity.View;
import mulesoft.type.DecimalType;
import mulesoft.type.EnumType;
import mulesoft.type.Kind;
import mulesoft.type.Modifier;
import mulesoft.type.StringType;
import mulesoft.type.Type;
import org.jetbrains.annotations.NotNull;

public class DbTableCodeGenerator
extends ClassGenerator
implements MMCodeGenerator {
    @NotNull
    protected final JavaElement.Constructor constructor;
    @NotNull
    protected final DbObject dbObject;
    @NotNull
    protected final String entityClass;
    @NotNull
    protected final String keyType;
    @NotNull
    private final String singleton;
    private static final String SEARCHER = "searcher";
    private static final EnumSet<Kind> supportsLength = EnumSet.of(Kind.INT, Kind.DECIMAL, Kind.STRING);
    private static final EnumSet<Kind> supportsSign = EnumSet.of(Kind.INT, Kind.REAL, Kind.DECIMAL);
    private static final EnumMap<Kind, String> fieldClass = Maps.enumMap((Tuple)Tuple.tuple((Object)Kind.INT, (Object)"mulesoft.persistence.TableField.Int"), (Tuple[])new Tuple[]{Tuple.tuple((Object)Kind.REAL, (Object)"mulesoft.persistence.TableField.Real"), Tuple.tuple((Object)Kind.DECIMAL, (Object)"mulesoft.persistence.TableField.Decimal"), Tuple.tuple((Object)Kind.STRING, (Object)"mulesoft.persistence.TableField.Str"), Tuple.tuple((Object)Kind.RESOURCE, (Object)"mulesoft.persistence.TableField.Res"), Tuple.tuple((Object)Kind.BOOLEAN, (Object)"mulesoft.persistence.TableField.Bool"), Tuple.tuple((Object)Kind.DATE, (Object)"mulesoft.persistence.TableField.Date"), Tuple.tuple((Object)Kind.DATE_TIME, (Object)"mulesoft.persistence.TableField.DTime"), Tuple.tuple((Object)Kind.ENUM, (Object)"mulesoft.persistence.TableField.Enum")});
    private static final Map<String, String> fieldMethod = Maps.hashMap((Tuple)Tuple.tuple((Object)"mulesoft.persistence.TableField.Int", (Object)"intField"), (Tuple[])new Tuple[]{Tuple.tuple((Object)"mulesoft.persistence.TableField.Real", (Object)"realField"), Tuple.tuple((Object)"mulesoft.persistence.TableField.Decimal", (Object)"decimalField"), Tuple.tuple((Object)"mulesoft.persistence.TableField.Str", (Object)"strField"), Tuple.tuple((Object)"mulesoft.persistence.TableField.Res", (Object)"resourceField"), Tuple.tuple((Object)"mulesoft.persistence.TableField.Bool", (Object)"boolField"), Tuple.tuple((Object)"mulesoft.persistence.TableField.Date", (Object)"dateField"), Tuple.tuple((Object)"mulesoft.persistence.TableField.DTime", (Object)"dTimeField"), Tuple.tuple((Object)"mulesoft.persistence.TableField.Clob", (Object)"clobField"), Tuple.tuple((Object)"mulesoft.persistence.TableField.LongFld", (Object)"longField")});
    private static final String DEFAULT = "DEFAULT";

    public DbTableCodeGenerator(JavaCodeGenerator cg, @NotNull DbObject dbObj) {
        super(cg, DbTableCodeGenerator.getDbTableName(dbObj));
        this.dbObject = dbObj;
        this.entityClass = dbObj.getImplementationClassName();
        this.keyType = EntityBaseCodeGenerator.makePrimaryKeyType(this, dbObj);
        this.constructor = (JavaElement.Constructor)this.constructor().invokeSuper(this.superConstructorArgs()).asPrivate();
        ((ClassGenerator)this.asPublic()).withSuperclass(this.generic("mulesoft.persistence.DbTable", new String[]{this.entityClass, this.keyType}));
        this.withComments(new String[]{"Metadata class for table associated to entity " + this.entityClass});
        this.suppressWarnings(new String[]{MMCodeGenConstants.DUPLICATED_STRING, MMCodeGenConstants.MAGIC_NUMBER});
        this.singleton = DbTableCodeGenerator.singletonName(this.dbObject).getName();
        String className = this.getName();
        ((JavaElement.Field)((JavaElement.Field)((JavaElement.Field)((JavaElement.Field)this.field(this.singleton, className).asPublic()).asFinal()).notNull()).asStatic()).withValue(this.new_(className, new String[0]));
        List<TypeField> typeFields = this.collectFields();
        for (TypeField field : typeFields) {
            this.addTableField(field);
        }
        this.addPrimaryKey();
        this.addSecondaryKeys();
        this.addKeyFromString();
        if (this.dbObject.isSearchable()) {
            this.createSearchable();
        }
        JavaElement.Method as = (JavaElement.Method)((JavaElement.Method)((JavaElement.Method)((JavaElement.Method)this.method("as", className).asPublic()).asFinal()).override()).notNull();
        as.arg("alias", String.class).notNull();
        as.return_((CharSequence)this.invoke("", "createAlias", new String[]{this.new_(className, new String[0]), "alias"}));
        JavaElement.Method cet = (JavaElement.Method)((JavaElement.Method)((JavaElement.Method)((JavaElement.Method)this.method("createEntityTable", this.generic("mulesoft.persistence.EntityTable", new String[]{this.entityClass, this.keyType})).asProtected()).asFinal()).override()).notNull();
        cet.return_((CharSequence)this.createEntityTableBody());
    }

    @Override
    public String getSourceName() {
        return this.dbObject.getSourceName();
    }

    protected void addTableField(TypeField typeField) {
        if (typeField.hasOption(FieldOption.ABSTRACT)) {
            return;
        }
        Type finalType = typeField.getFinalType();
        Kind kind = finalType.getKind();
        String fieldType = DbTableCodeGenerator.classFor(typeField, this);
        String createMethod = kind != Kind.ENUM ? fieldMethod.get(fieldType) : (typeField.isMultiple() ? "enumSetField" : "enumField");
        ArrayList<String> args = new ArrayList<String>();
        args.add(Strings.quoted((String)typeField.getName()));
        args.add(Strings.quoted((String)this.getColumnName(typeField)));
        if (supportsSign.contains(kind)) {
            args.add(String.valueOf(typeField.getOptions().hasOption(FieldOption.SIGNED)));
        }
        if (supportsLength.contains(kind)) {
            args.add(String.valueOf(finalType.getLength().get()));
        }
        if (finalType instanceof StringType && ((StringType)finalType).isIntern()) {
            createMethod = "strInternField";
        }
        if (finalType instanceof DecimalType) {
            args.add(String.valueOf(((DecimalType)finalType).getDecimals()));
        } else if (finalType instanceof EnumType) {
            args.add(this.classOf(typeField.getImplementationClassName()));
        }
        String fieldName = this.fieldName(typeField);
        this.constructor.assign(fieldName, this.invoke("", createMethod, args));
        ((JavaElement.Field)((JavaElement.Field)this.field(fieldName, fieldType).asPublic()).asFinal()).notNull();
    }

    protected List<TypeField> collectFields() {
        View view;
        Option baseEntity;
        ArrayList<TypeField> fields = new ArrayList<TypeField>();
        if (this.dbObject.isView() && (baseEntity = (view = this.dbObject.asView()).getBaseEntity()).isPresent() && Predefined.isEmpty((String)view.getAsQuery())) {
            for (Attribute attribute : ((DbObject)baseEntity.get()).getPrimaryKey()) {
                if (!view.getAttributeByBaseAttributeName(attribute.getName()).isEmpty()) continue;
                for (TypeField typeField : attribute.retrieveSimpleFields()) {
                    fields.add(typeField);
                }
            }
        }
        for (Attribute a : this.dbObject.attributes()) {
            if (a.hasOption(FieldOption.ABSTRACT)) continue;
            for (TypeField typeField : a.retrieveSimpleFields()) {
                fields.add(typeField);
            }
        }
        return fields;
    }

    protected String createEntityTableBody() {
        return this.new_((this.isInner() ? "mulesoft.persistence.InnerEntityTable" : "mulesoft.persistence.EntityTable") + "<>", new String[]{this.singleton});
    }

    protected String getColumnName(TypeField typeField) {
        return typeField.getColumnName();
    }

    private void addKeyFromString() {
        JavaElement.Method m = (JavaElement.Method)((JavaElement.Method)this.method("strToKey", this.keyType).asProtected()).boxedNotNull();
        m.arg("key", String.class).notNull();
        Seq<String> types = EntityBaseCodeGenerator.types(this, (Seq<TypeField>)this.dbObject.retrieveSimpleFields());
        int size = types.size();
        if (size == 0) {
            m.throwNew(UnsupportedOperationException.class, new String[0]);
        } else if (size == 1) {
            m.return_((CharSequence)this.invokeConvertFromString("key", (String)types.getFirst().get()));
        } else {
            ArrayList<String> args = new ArrayList<String>();
            int i = 0;
            for (String t : types) {
                args.add(this.invokeConvertFromString("parts[" + i++ + "]", t));
            }
            m.declare("String[]", "parts", this.invokeStatic(Strings.class, "splitToArray", new String[]{"key", String.valueOf(size)}));
            m.return_((CharSequence)this.invokeStatic(Tuple.class, CodeGeneratorConstants.tupleMethod((int)args.size()), args));
        }
    }

    private void addPrimaryKey() {
        this.constructor.statement(this.invoke("", "primaryKey", new String[]{this.invokeListOf(this.dbObject.retrieveSimpleFields().map(this::fieldName))}));
    }

    private void addSecondaryKeys() {
        Seq indexNames = this.dbObject.getUniqueIndexNames();
        if (!indexNames.isEmpty()) {
            Seq keys = indexNames.map(this::secondaryKey);
            this.constructor.statement(this.invoke("", "secondaryKeys", new String[]{this.invokeListOf(keys)}));
        }
    }

    private String cacheArg() {
        CacheType cacheType = this.dbObject.getCacheType();
        String field = cacheType == CacheType.DEFAULT ? DEFAULT : (cacheType == CacheType.FULL ? "FULL" : (cacheType == CacheType.NONE ? "NONE" : null));
        return field == null ? this.invoke(this.refStatic(CacheType.class, DEFAULT), "withSize", new String[]{String.valueOf(cacheType.getSize())}) : this.refStatic(CacheType.class, field);
    }

    private void createSearchable() {
        String searcherClass = this.dbObject.getFullName() + "Searcher";
        String searcherField = Strings.fromCamelCase((String)(this.dbObject.getName() + "Searcher"));
        ((JavaElement.Method)((JavaElement.Method)((JavaElement.Method)this.method(SEARCHER, this.generic(Option.class, new String[]{searcherClass})).asProtected()).notNull()).override()).return_((CharSequence)this.invokeStatic(Option.class, "of", new String[]{this.refStatic(searcherClass, searcherField)}));
    }

    @NotNull
    private String fieldName(TypeField typeField) {
        String f = Strings.fromCamelCase((String)typeField.getName());
        return f.equals(this.singleton) ? f + "_" : f;
    }

    private boolean hasGeneratedKey() {
        return !this.isInner() && this.dbObject.hasDefaultPrimaryKey();
    }

    private String modifiers() {
        EnumSet modifiers = this.dbObject.getModifiers();
        return modifiers.isEmpty() ? this.refStatic(Modifier.class, "NONE") : this.invokeStatic(EnumSet.class, "of", (Iterable)Colls.map((Iterable)modifiers, m -> this.refStaticImport(Modifier.class, m.name())));
    }

    private String secondaryKey(String indexName) {
        return this.invokeListOf(TypeField.retrieveSimpleFields((Iterable)this.dbObject.getUniqueIndexByName(indexName)).map(this::fieldName));
    }

    private List<String> superConstructorArgs() {
        ArrayList<String> superArgs = new ArrayList<String>();
        QName tableName = this.dbObject.getTableName();
        superArgs.add(this.classOf(this.entityClass));
        superArgs.add(Strings.quoted((String)tableName.getQualification()));
        superArgs.add(Strings.quoted((String)tableName.getName()));
        superArgs.add(Strings.quoted((String)(this.hasGeneratedKey() ? ((Attribute)this.dbObject.getPrimaryKey().getFirst().get()).getSequenceName() : "")));
        superArgs.add(this.modifiers());
        superArgs.add(this.cacheArg());
        return superArgs;
    }

    private boolean isInner() {
        return this.dbObject.getParent().isPresent();
    }

    public static String getDbTableName(DbObject dbObj) {
        return dbObj.getName() + "Table";
    }

    static String classFor(TypeField typeField, JavaItemGenerator<?> cg) {
        Type finalType = typeField.getFinalType();
        if (finalType.isString()) {
            if (((StringType)finalType).useClob()) {
                return "mulesoft.persistence.TableField.Clob";
            }
        } else {
            if (finalType instanceof EnumType) {
                String enumType = typeField.getImplementationClassName();
                String clazz = typeField.isMultiple() ? "mulesoft.persistence.TableField.EnumerationSet" : "mulesoft.persistence.TableField.Enum";
                return cg.generic(clazz, new String[]{enumType, ((EnumType)finalType).getPkType().getImplementationClassName()});
            }
            if (Long.class.equals((Object)finalType.getImplementationClass())) {
                return "mulesoft.persistence.TableField.LongFld";
            }
        }
        Kind kind = finalType.getKind();
        return fieldClass.get(kind);
    }

    static QName singletonName(DbObject ref) {
        String name = Strings.fromCamelCase((String)ref.getName());
        if (name.equals(ref.getName())) {
            name = name + "_";
        }
        return QName.createQName((String)QName.createQName((String)(ref.getDomain() + ".g"), (String)DbTableCodeGenerator.getDbTableName(ref)).getFullName(), (String)name);
    }
}

