/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.codegen.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import mulesoft.cache.CacheType;
import mulesoft.codegen.CodeGeneratorConstants;
import mulesoft.codegen.common.Generators;
import mulesoft.codegen.common.MMCodeGenConstants;
import mulesoft.codegen.common.MMCodeGenerator;
import mulesoft.codegen.entity.AttributeGenerator;
import mulesoft.codegen.entity.DbTableCodeGenerator;
import mulesoft.codegen.impl.java.ClassGenerator;
import mulesoft.codegen.impl.java.JavaCodeGenerator;
import mulesoft.codegen.impl.java.JavaElement;
import mulesoft.codegen.impl.java.JavaItemGenerator;
import mulesoft.common.collections.Colls;
import mulesoft.common.collections.ImmutableCollection;
import mulesoft.common.collections.ImmutableList;
import mulesoft.common.collections.Seq;
import mulesoft.common.core.Option;
import mulesoft.common.core.QName;
import mulesoft.common.core.StrBuilder;
import mulesoft.common.core.Strings;
import mulesoft.common.core.Tuple;
import mulesoft.common.util.Conversions;
import mulesoft.common.util.Primitives;
import mulesoft.field.FieldOption;
import mulesoft.field.ModelField;
import mulesoft.field.TypeField;
import mulesoft.metadata.entity.Attribute;
import mulesoft.metadata.entity.DbObject;
import mulesoft.type.MetaModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityBaseCodeGenerator
extends ClassGenerator
implements MMCodeGenerator {
    protected final DbObject dbObject;
    protected final String tableSingleton;
    final String className;
    final ImmutableList<JavaElement.Field> primaryKeyFields;
    @Nullable
    private final DataGenerator data;
    private final boolean immutable;
    private final String mainInterface;
    private final String primaryKeyType;
    private final Map<String, String> references = new HashMap<String, String>();
    private final ClassGenerator target;
    private static final String SEQ_ID = "seqId";
    public static final String PARENT = "parent";
    private static final String CHILDREN = "children";
    @NonNls
    private static final String CONSUMER = "consumer";
    static final String INVALIDATE = "invalidate";
    private static final QName CAST = QName.createQName((String)CodeGeneratorConstants.PREDEFINED_CLASS, (String)"cast");
    protected static final String MY_ENTITY_TABLE = "myEntityTable";
    private static final Predicate<Attribute> ATTR_IS_ENTITY_NOT_STRING = new Predicate<Attribute>(){

        @Override
        public boolean test(@Nullable Attribute a) {
            boolean result = false;
            if (a != null) {
                for (DbObject e : a.asDatabaseObject()) {
                    result = e.hasCompositePrimaryKey() || !this.checkSingleStringPK(a);
                }
            }
            return result;
        }

        private boolean checkSingleStringPK(Attribute a) {
            boolean result = a.getType().getFinalType().isString();
            for (DbObject e : a.asDatabaseObject()) {
                result = this.checkSingleStringPK((Attribute)e.getPrimaryKey().getFirst().get());
            }
            return result;
        }
    };
    private static final String EMPTY_KEY_FIELD = "DEFAULT_EMPTY_KEY";
    @NonNls
    private static final String IDENTIFIED_BY_KEY = "Identified by the primary key.";

    public EntityBaseCodeGenerator(JavaCodeGenerator cg, @NotNull DbObject dbObject, String className) {
        this(cg, dbObject, className, false, null);
    }

    EntityBaseCodeGenerator(JavaCodeGenerator cg, @NotNull DbObject dbObject, String className, boolean forUpdate, @Nullable ImmutableList<JavaElement.Field> primaryKey) {
        super(cg, className + "Base");
        this.dbObject = dbObject;
        this.className = className;
        this.primaryKeyType = EntityBaseCodeGenerator.makePrimaryKeyType(this, dbObject);
        this.data = this.addData();
        ClassGenerator classGenerator = this.target = this.data == null ? this : this.data;
        this.primaryKeyFields = primaryKey != null ? primaryKey : (this.hasSingleDefaultPrimaryKey() ? this.addDefaultPrimaryKeyAttr() : this.addPrimaryKeyAttributes());
        this.tableSingleton = this.extractStaticImport(DbTableCodeGenerator.singletonName(dbObject));
        boolean bl = this.immutable = !forUpdate && dbObject.splitMutator();
        this.mainInterface = this.immutable ? "mulesoft.persistence.EntityInstance" : (dbObject.isInner() ? "mulesoft.persistence.InnerInstance" : (dbObject.isView() ? (dbObject.asView().isUpdatable() ? "mulesoft.persistence.UpdatableInstance" : "mulesoft.persistence.EntityInstance") : "mulesoft.persistence.PersistableInstance"));
    }

    public String getPrimaryKeyType() {
        return this.primaryKeyType;
    }

    @Override
    public String getSourceName() {
        return this.dbObject.getSourceName();
    }

    protected void addCreateMethods() {
        ImmutableList pk;
        JavaElement.Method c = this.createMethod();
        if (this.dbObject.hasDefaultPrimaryKey()) {
            c.return_((CharSequence)this.new_(this.className, new String[0]));
        } else if (this.primaryKeyFields.isEmpty()) {
            c.throwNew(UnsupportedOperationException.class, new String[0]);
        } else {
            c.arguments(Generators.makeArguments(this.primaryKeyFields)).notNull();
            c.declare(this.className, "result", this.new_(this.className, new String[0]));
            int i = 0;
            ImmutableList typeFields = this.dbObject.primaryKeySimpleFields();
            for (JavaElement.Field field : this.primaryKeyFields) {
                String fld = Generators.verifyField(this, field.getName(), (ModelField)typeFields.get(i++));
                c.assign("(" + this.cast(this.getImmutableBase(), "result") + ")." + (this.data == null ? "" : "_data.") + field.getName(), fld);
            }
            c.return_((CharSequence)"result");
        }
        if (this.hasCompositeKey()) {
            String[] args = new String[this.primaryKeyFields.size()];
            for (int i = 0; i < args.length; ++i) {
                args[i] = this.invoke("key", "_" + (i + 1), new String[0]);
            }
            JavaElement.Method ck = (JavaElement.Method)this.createMethod().withComments(new String[]{"Based on the primary key object"});
            ck.arg("key", this.primaryKeyType).notNull();
            ck.return_((CharSequence)this.invoke("", this.createMethodName(), args));
        }
        if ((pk = this.dbObject.getPrimaryKey()).exists(ATTR_IS_ENTITY_NOT_STRING)) {
            this.addFindOrCreateFromEntities((ImmutableCollection<Attribute>)pk, this.createMethod());
        }
    }

    protected void addInnerMethods(Attribute parentAttribute, String parentType, String parentKey) {
        ((JavaElement.Method)((JavaElement.Method)((JavaElement.Method)this.method(PARENT, this.generic("mulesoft.persistence.EntityRef", new String[]{parentType, parentKey})).asPublic()).notNull()).override()).return_((CharSequence)parentAttribute.getName());
        String parentGetter = this.invoke("", Strings.getterName((String)parentAttribute.getName(), (String)""), new String[0]);
        ((JavaElement.Method)((JavaElement.Method)((JavaElement.Method)this.method("siblings", this.generic("mulesoft.persistence.InnerEntitySeq", new String[]{this.className})).asPublic()).notNull()).override()).return_((CharSequence)this.invoke(parentGetter, Strings.getterName((String)parentAttribute.getReverseReference(), (String)""), new String[0]));
        ((JavaElement.Method)((JavaElement.Method)this.method(SEQ_ID, Integer.TYPE).asPublic()).override()).return_((CharSequence)this.invoke("", Strings.getterName((String)((Attribute)this.dbObject.getPrimaryKey().get(1)).getName(), (String)""), new String[0]));
    }

    protected void addInterfaces(String type, String keyType) {
        this.withSuperclass(this.generic(this.superClass(), new String[]{this.className, this.primaryKeyType}));
        if (this.dbObject.isDeprecable()) {
            this.withInterfaces(new String[]{this.generic("mulesoft.persistence.DeprecableInstance", new String[]{this.className, this.primaryKeyType})});
        }
        if (this.dbObject.isAuditable()) {
            this.withInterfaces(new String[]{"mulesoft.persistence.AuditableInstance"});
        }
        if (this.dbObject.hasImage()) {
            this.withInterfaces(new String[]{"mulesoft.persistence.HasImage"});
        }
    }

    protected void addMyEntityTable() {
        this.doAddMyEntityTable("mulesoft.persistence.EntityTable");
    }

    protected String column(@NotNull String column) {
        String s = Strings.fromCamelCase((String)column);
        return this.tableSingleton + "." + (s.equals(QName.extractName((String)this.tableSingleton)) ? s + "_" : s);
    }

    protected String defaultFor(ClassGenerator cg, TypeField field, boolean required) {
        return Generators.defaultFor(cg, field, required);
    }

    protected void doAddMyEntityTable(String tableImpl) {
        String forTable = this.invokeStatic("mulesoft.persistence.EntityTable", "forTable", new String[]{this.tableSingleton});
        ((JavaElement.Method)((JavaElement.Method)((JavaElement.Method)this.method(MY_ENTITY_TABLE, this.generic(tableImpl, new String[]{this.dbObject.getImplementationClassName(), this.primaryKeyType})).asPrivate()).notNull()).asStatic()).return_((CharSequence)(tableImpl.equals("mulesoft.persistence.EntityTable") ? forTable : this.invokeStatic(CAST, new String[]{forTable})));
        ((JavaElement.Method)((JavaElement.Method)this.method("et", this.generic("mulesoft.persistence.EntityTable", new String[]{this.className, this.primaryKeyType})).asPublic()).notNull()).return_((CharSequence)this.invoke("", MY_ENTITY_TABLE, new String[0]));
        ((JavaElement.Method)((JavaElement.Method)((JavaElement.Method)this.method("table", this.generic("mulesoft.persistence.DbTable", new String[]{this.className, this.primaryKeyType})).asPublic()).notNull()).override()).return_((CharSequence)this.tableSingleton);
    }

    protected boolean includeAttribute(Attribute attribute) {
        return !this.dbObject.isPrimaryKey(attribute);
    }

    protected void makeFinal(String method) {
        ((JavaElement.Method)((JavaElement.Method)((JavaElement.Method)((JavaElement.Method)this.method(method, this.className).asPublic()).withAnnotation("Override")).asFinal()).notNull()).return_((CharSequence)this.invoke(this.refStatic(this.mainInterface, "super"), method, new String[0]));
    }

    protected void populate() {
        this.asAbstract();
        if (this.dbObject.isInner()) {
            Attribute parent = (Attribute)this.dbObject.getPrimaryKey().getFirst().get();
            String parentKey = EntityBaseCodeGenerator.makePrimaryKeyType(this, (DbObject)parent.asDatabaseObject().get());
            String parentType = parent.getImplementationClassName();
            this.withInterfaces(new String[]{this.generic(this.mainInterface, new String[]{this.className, this.primaryKeyType, parentType, parentKey})});
            this.addInnerMethods(parent, parentType, parentKey);
        } else {
            this.withInterfaces(new String[]{this.generic(this.mainInterface, new String[]{this.className, this.primaryKeyType})});
        }
        String documentation = this.dbObject.getDocumentation();
        if (!documentation.isEmpty()) {
            for (String d : documentation.split("\n")) {
                this.withComments(new String[]{d.trim()});
            }
            this.withComments(new String[]{""});
        }
        this.withComments(new String[]{"Generated base class for entity: " + this.dbObject.getName() + "."});
        this.withComments(new String[]{"Don't modify this as this is an auto generated class that's gets generated"});
        this.withComments(new String[]{"every time the meta model file is modified. Use subclass instead."});
        this.suppressWarnings(MMCodeGenConstants.COMMON_SUPPRESSED_WARNINGS);
        this.addInterfaces(this.className, this.primaryKeyType);
        if (this.isDeprecatedCached()) {
            this.generateConstructor();
        }
        this.addAttributes();
        if (!this.dbObject.isInner() && !this.immutable) {
            this.addCreateMethods();
            if (!this.dbObject.hasDefaultPrimaryKey() && !this.dbObject.isView()) {
                this.addFindOrCreateMethods();
            }
        }
        this.addMyEntityTable();
        if (!this.dbObject.isProtected()) {
            if (!this.dbObject.getPrimaryKey().isEmpty()) {
                this.addFindMethods();
            }
            this.addListMethods();
            if (!this.immutable && !this.dbObject.isView()) {
                this.addPersistenceMethods();
            }
            this.addIndexMethods();
        }
        this.addKeyAsString();
        this.addKeyObject();
        if (this.dbObject.hasImage()) {
            this.addImage();
        }
        this.addToStringAndDescribe();
        this.addHasChildren();
        this.addRowMapper();
        this.addInvalidateMethod();
        super.populate();
    }

    @NotNull
    protected String refData(String field) {
        return (this.data == null ? "this" : "_data") + "." + field;
    }

    protected String referenceThisType(String var) {
        return QName.extractName((String)this.className).equals(this.getName()) ? var : this.cast(this.className, var);
    }

    protected DbObject getDbObject() {
        return this.dbObject;
    }

    String abstractDataClass() {
        return this.generic(this.extractImport(this.superClass()) + ".AbstractData", new String[]{this.className, this.primaryKeyType});
    }

    String addReference(String name, String value) {
        return this.references.put(name, value);
    }

    void createCopyTo() {
        JavaElement.Method m = ((JavaElement.Method)((JavaElement.Method)this.method("copyTo", "T").asPackagePrivate()).notNull()).withGenerics(new String[]{String.format("T extends %s", this.getName())});
        m.arg("to", "T").notNull();
        this.dbObject.attributes().flatMap(Attribute::retrieveSimpleFields).forEach(tf -> {
            JavaElement.Method cfr_ignored_0 = (JavaElement.Method)m.assign("to." + tf.getName(), tf.getName());
        });
        m.return_((CharSequence)"to");
    }

    @NotNull
    String createMethodName() {
        return "create";
    }

    String dataClassName() {
        return this.extractImport(this.className) + "." + "Data";
    }

    @NotNull
    String getImmutableBase() {
        return this.getName();
    }

    private void addAttributes() {
        for (Attribute attribute : this.dbObject.attributes()) {
            if (!this.includeAttribute(attribute)) continue;
            AttributeGenerator ag = this.createAttributeGenerator(attribute);
            ag.generate(this.target);
            if (this.immutable) continue;
            ag.generateMutableSetter(this.data != null);
        }
    }

    @Nullable
    private DataGenerator addData() {
        if (!this.isDeprecatedCached()) {
            return null;
        }
        DataGenerator dg = new DataGenerator(this);
        this.addInner((JavaItemGenerator)dg);
        String dataType = this.dataClassName();
        ((JavaElement.Field)this.field("_data", dataType).notNull()).withValue(this.new_(dataType, new String[0]));
        this.addDataMethod("_data", dataType).return_((CharSequence)"_data");
        this.addDataMethod("data", dataType).return_((CharSequence)this.cast(dataType, this.invoke("super", "data", new String[0])));
        return dg;
    }

    private JavaElement.Method addDataMethod(String methodName, String dataType) {
        return (JavaElement.Method)((JavaElement.Method)((JavaElement.Method)this.method(methodName, dataType).notNull()).asProtected()).asFinal();
    }

    private ImmutableList<JavaElement.Field> addDefaultPrimaryKeyAttr() {
        ImmutableList primaryKey = this.dbObject.getPrimaryKey();
        if (primaryKey.isEmpty()) {
            return ImmutableList.empty();
        }
        Attribute a = (Attribute)primaryKey.getFirst().get();
        String type = a.getImplementationClassName();
        String name = a.getName();
        JavaElement.Field f = (JavaElement.Field)this.target.field(name, type).required(true);
        String defaultValue = this.extractImport("mulesoft.persistence.EntityTable") + "." + EMPTY_KEY_FIELD;
        if (this.data != null && this.data.isOpen()) {
            f.asProtected();
        }
        f.withValue(defaultValue);
        ((JavaElement.Method)((JavaElement.Method)this.method(Strings.getterName((String)f.getName(), (String)type), type).required(true)).withGetterComments(name)).return_((CharSequence)this.refData(name));
        ((JavaElement.Method)((JavaElement.Method)this.target.method("hasEmptyKey", Boolean.TYPE).notNull()).override()).return_((CharSequence)(name + " == " + defaultValue));
        return Colls.listOf((Object)f);
    }

    private void addFindMethods() {
        String argName = this.hasCompositeKey() ? "key" : ((JavaElement.Field)this.primaryKeyFields.get(0)).getName();
        ((JavaElement.Method)this.findMethod("find").return_((CharSequence)this.invokeOnTable("find", argName))).arg(argName, this.primaryKeyType).notNull();
        ((JavaElement.Method)((JavaElement.Method)this.findMethod("findOrFail").notNull()).return_((CharSequence)this.invokeOnTable("findOrFail", argName))).arg(argName, this.primaryKeyType).notNull();
        ((JavaElement.Method)this.findMethod("findPersisted").return_((CharSequence)this.invokeOnTable("findPersisted", argName))).arg(argName, this.primaryKeyType).notNull();
        ((JavaElement.Method)((JavaElement.Method)this.findMethod("findPersistedOrFail").notNull()).return_((CharSequence)this.invokeOnTable("findPersistedOrFail", argName))).arg(argName, this.primaryKeyType).notNull();
        if (!this.hasStringKey()) {
            ((JavaElement.Method)this.findMethod("find").return_((CharSequence)this.invokeOnTable("findByString", "key"))).arg("key", String.class).notNull();
        }
        if (this.hasCompositeKey()) {
            JavaElement.Method find = this.findMethod("find");
            for (JavaElement.Field f : this.primaryKeyFields) {
                find.arg(f.getName(), f.getType()).notNull();
            }
            find.return_((CharSequence)this.invoke("", "find", new String[]{this.primaryKeyObject()}));
            ImmutableList pk = this.dbObject.getPrimaryKey();
            if (pk.size() > 1 && pk.exists(ATTR_IS_ENTITY_NOT_STRING)) {
                this.addFindOrCreateFromEntities((ImmutableCollection<Attribute>)pk, this.findMethod("find"));
            }
        }
        ((JavaElement.Method)this.findMethod("findWhere").return_((CharSequence)this.invoke(this.invoke(this.invokeStatic(MMCodeGenConstants.SELECT_FROM_METHOD, new String[]{this.tableSingleton}), "where", new String[]{"condition"}), "get", new String[0]))).arg("condition", "mulesoft.persistence.Criteria...").notNull();
    }

    private void addFindOrCreateFromEntities(ImmutableCollection<Attribute> pk, JavaElement.Method method) {
        method.withComments(new String[]{"Based on String key for Entities"});
        ArrayList<String> args = new ArrayList<String>();
        for (Attribute a : pk) {
            this.addFromEntitiesArg(args, method, a, (Option<DbObject>)a.asDatabaseObject(), a.getName());
        }
        method.return_((CharSequence)this.invoke("", method.getName(), args));
    }

    private void addFindOrCreateMethods() {
        String argName = this.hasCompositeKey() ? "key" : ((JavaElement.Field)this.primaryKeyFields.get(0)).getName();
        ((JavaElement.Method)this.findOrCreateMethod().return_((CharSequence)this.invokeOnTable("findOrCreate", argName))).arg(argName, this.primaryKeyType).notNull();
        if (!this.hasStringKey()) {
            ((JavaElement.Method)this.findOrCreateMethod().return_((CharSequence)this.invokeOnTable("findOrCreateByString", "key"))).arg("key", String.class).notNull();
        }
        if (this.hasCompositeKey()) {
            JavaElement.Method find = this.findOrCreateMethod();
            for (JavaElement.Field f : this.primaryKeyFields) {
                find.arg(f.getName(), f.getType()).notNull();
            }
            find.return_((CharSequence)this.invoke("", "findOrCreate", new String[]{this.primaryKeyObject()}));
        }
    }

    private void addFromEntitiesArg(List<String> args, JavaElement.Method ce, Attribute a, Option<DbObject> e, String name) {
        if (e.isEmpty()) {
            ce.arg(name, a.getImplementationClassName()).notNull();
            args.add(name);
        } else {
            ce.arg(name, String.class).notNull();
            Seq<String> types = EntityBaseCodeGenerator.types(this, (Seq<TypeField>)((DbObject)e.get()).retrieveSimpleFields());
            int size = types.size();
            if (size == 1) {
                args.add(this.invokeConvertFromString(name, (String)types.getFirst().get()));
            } else {
                String parts = name + "Parts";
                ce.declare("String[]", parts, this.invokeStatic(Strings.class, "splitToArray", new String[]{name, this.str(size)}));
                int i = 0;
                for (String t : types) {
                    args.add(this.invokeConvertFromString(parts + "[" + i++ + "]", t));
                }
            }
        }
    }

    private void addHasChildren() {
        this.dbObject.attributes().getFirst(a -> a != null && a.isMultiple() && this.dbObject.equals((Object)a.getType())).ifPresent(selfReference -> {
            this.withInterfaces(new String[]{this.generic("tekgenesis.persistence.HasChildren", new String[]{selfReference.getElementClassName()})});
            JavaElement.Method m = (JavaElement.Method)this.method(CHILDREN, this.generic(Seq.class, new String[]{selfReference.getElementClassName()})).notNull();
            m.return_((CharSequence)this.invokeGetter((Attribute)selfReference));
        });
    }

    private void addImage() {
        JavaElement.Method image = this.method("imagePath", String.class);
        image.notNull();
        image.withComments(new String[]{"Returns the image path build using the image resource field."});
        image.return_((CharSequence)this.invoke(this.extractImport("tekgenesis.common.util.Resources"), "imagePath", new String[]{this.dbObject.getAttribute(this.dbObject.image()).filter(a -> a.hasOption(FieldOption.ABSTRACT)).isPresent() ? Strings.getterName((String)this.dbObject.image()) + "()" : this.refData(this.dbObject.image())}));
    }

    private void addIndexMethod(boolean list, String indexName, int indexId, Seq<Attribute> index, String returnType) {
        ImmutableList keyFields = TypeField.retrieveSimpleFields(index);
        JavaElement.MethodBase method = ((JavaElement.Method)((JavaElement.Method)((JavaElement.Method)this.method((list ? "listBy" : "findBy") + Strings.capitalizeFirst((String)indexName), returnType).withComments(new String[]{String.format(list ? "List the instances of '%s' that matches the given parameters." : "Finds the instance", this.dbObject.getName())})).asStatic()).required(list)).arguments(Generators.makeArguments((Seq<? extends TypeField>)keyFields, true));
        if (list) {
            Seq conditions = keyFields.map(a -> this.invoke(this.column(a.getName()), "eq", new String[]{a.getName()}));
            method.return_((CharSequence)this.invoke(this.invoke(this.invokeStatic(MMCodeGenConstants.SELECT_FROM_METHOD, new String[]{this.tableSingleton}), "where", (Iterable)conditions), "list", new String[0]));
        } else {
            String key = keyFields.size() == 1 ? ((TypeField)keyFields.get(0)).getName() : this.invokeStatic(Tuple.class, CodeGeneratorConstants.tupleMethod((int)keyFields.size()), (Iterable)keyFields.map(TypeField::getName));
            method.return_((CharSequence)this.invokeOnTable("findByKey", String.valueOf(indexId), key));
        }
    }

    private void addIndexMethods() {
        int uniqueId = 0;
        for (String name : this.dbObject.getUniqueIndexNames()) {
            this.addIndexMethod(false, name, uniqueId++, (Seq<Attribute>)this.dbObject.getUniqueIndexByName(name), this.className);
        }
        int indexId = 0;
        for (String name : this.dbObject.getIndexNames()) {
            this.addIndexMethod(true, name, indexId++, (Seq<Attribute>)this.dbObject.getIndexByName(name), this.generic(ImmutableList.class, new String[]{this.className}));
        }
    }

    private void addInvalidateMethod() {
        if (!this.references.isEmpty()) {
            JavaElement.Method invalidateMethod = (JavaElement.Method)this.method(INVALIDATE).override();
            for (String attr : this.references.keySet()) {
                invalidateMethod.statement(this.invoke(attr, INVALIDATE, new String[0]));
            }
        }
    }

    private void addKeyAsString() {
        String ret;
        if (this.hasCompositeKey()) {
            StrBuilder b = new StrBuilder().startCollection(" + \":\" + ");
            for (JavaElement.Field k : this.primaryKeyFields) {
                String name = k.getName();
                b.appendElement((Object)(k.isString() ? this.invokeStatic(Strings.class, "escapeCharOn", new String[]{name, "':'"}) : name));
            }
            ret = b.toString();
        } else {
            if (this.primaryKeyFields.isEmpty()) {
                ((JavaElement.Method)this.target.method("keyAsString", String.class).notNull()).throwNew(UnsupportedOperationException.class, new String[0]);
                return;
            }
            String keyName = ((JavaElement.Field)this.primaryKeyFields.get(0)).getName();
            ret = this.hasStringKey() ? keyName : this.invokeStatic(String.class, "valueOf", new String[]{keyName});
        }
        ((JavaElement.Method)this.target.method("keyAsString", String.class).notNull()).return_((CharSequence)ret);
    }

    private void addKeyObject() {
        ((JavaElement.Method)this.target.method("keyObject", this.primaryKeyType).boxedNotNull()).return_((CharSequence)this.primaryKeyObject());
    }

    private void addListenerMethod(String listenerMethod, String comment) {
        JavaElement.Method m = (JavaElement.Method)((JavaElement.Method)((JavaElement.Method)((JavaElement.Method)this.method(listenerMethod, "void").asStatic()).asPublic()).withComments(new String[]{comment})).statement(this.invokeOnTable(listenerMethod, "listenerType", "listener"));
        m.arg("listenerType", "mulesoft.persistence.EntityListenerType").notNull();
        m.arg("listener", this.generic("mulesoft.persistence.EntityListener", new String[]{this.className})).notNull();
    }

    private void addListMethods() {
        String name = this.dbObject.getName();
        String listComment = String.format("Create a selectFrom(%s).", this.tableSingleton);
        String selectFrom = this.invokeStatic(MMCodeGenConstants.SELECT_FROM_METHOD, new String[]{this.tableSingleton});
        ((JavaElement.Method)((JavaElement.Method)((JavaElement.Method)((JavaElement.Method)this.method("list", this.generic("mulesoft.persistence.Select", new String[]{this.className})).asStatic()).asPublic()).notNull()).return_((CharSequence)selectFrom)).withComments(new String[]{listComment});
        ((JavaElement.Method)((JavaElement.Method)((JavaElement.Method)((JavaElement.Method)this.method("forEach", "void").asStatic()).asPublic()).withComments(new String[]{String.format("Performs the given action for each %s", name)})).statement(this.invoke(selectFrom, "forEach", new String[]{CONSUMER}))).arg(CONSUMER, this.generic(Consumer.class, new String[]{this.className}));
        String keys = "keys";
        String comment = String.format("List instances of '%s' with the specified keys.", name);
        if (!this.hasStringKey()) {
            ((JavaElement.Method)((JavaElement.Method)((JavaElement.Method)this.listMethod().return_((CharSequence)this.invokeOnTable("list", "keys"))).notNull()).withComments(new String[]{comment})).arg("keys", this.generic(Set.class, new String[]{this.primaryKeyType}));
        }
        ((JavaElement.Method)((JavaElement.Method)((JavaElement.Method)this.listMethod().return_((CharSequence)this.invokeOnTable("listFromStringKeys", "keys"))).notNull()).withComments(new String[]{comment})).arg("keys", this.generic(Iterable.class, new Class[]{String.class}));
        ((JavaElement.Method)((JavaElement.Method)((JavaElement.Method)((JavaElement.Method)((JavaElement.Method)this.method("listWhere", this.generic("mulesoft.persistence.Select", new String[]{this.className})).asStatic()).asPublic()).return_((CharSequence)this.invoke(selectFrom, "where", new String[]{"condition"}))).notNull()).withComments(new String[]{String.format("List the instances of '%s' that verify the specified condition.", name)})).arg("condition", "mulesoft.persistence.Criteria").notNull();
    }

    private void addPersistenceMethods() {
        if (this.hasSingleDefaultPrimaryKey()) {
            String id = ((JavaElement.Field)this.primaryKeyFields.get(0)).getName();
            JavaElement.Method m = (JavaElement.Method)((JavaElement.Method)this.method("insert").asPublic()).withComments(new String[]{"Insert specifying the primary key"});
            m.arg("key", Integer.TYPE);
            m.assign(this.refData(id), "key");
            m.statement(this.invokeOnTable("insertDoNotGenerate", this.referenceThisType("this")));
            if ("TRUE".equals(System.getenv("MAKE_FINAL"))) {
                this.makeFinal("update");
                this.makeFinal("insert");
            }
        } else {
            this.makeFinal("update");
            this.makeFinal("insert");
        }
        this.addListenerMethod("addListener", "Register a Listener");
        this.addListenerMethod("removeListener", "Remove a Listener");
    }

    private ImmutableList<JavaElement.Field> addPrimaryKeyAttributes() {
        return ImmutableList.build(b -> this.dbObject.getPrimaryKey().forEach(a -> this.createAttributeGenerator((Attribute)a).generatePk((ImmutableList.Builder<JavaElement.Field>)b, this.target)));
    }

    private void addRowMapper() {
        ((JavaElement.Method)((JavaElement.Method)((JavaElement.Method)((JavaElement.Method)this.method("rowMapper", this.generic("mulesoft.database.RowMapper", new String[]{this.className})).asStatic()).asPublic()).notNull()).withComments(new String[]{"Gets mapper for SQL statements"})).return_((CharSequence)this.invoke(this.invoke(this.tableSingleton, "metadata", new String[0]), "getRowMapper", new String[0]));
    }

    private void addSearchBy() {
        if (!this.dbObject.isSearchable()) {
            return;
        }
        JavaElement.Method forceIndex = (JavaElement.Method)this.method("index").asPublic();
        forceIndex.statement(this.invokeOnTable("index", this.referenceThisType("this")));
    }

    private void addToStringAndDescribe() {
        Seq describes = this.dbObject.describes();
        if (!describes.isEmpty()) {
            StringBuilder describeFields = new StringBuilder();
            StringBuilder toStringFields = new StringBuilder();
            for (ModelField a : describes) {
                String g;
                boolean first;
                if (describeFields.length() != 0) {
                    describeFields.append(", ");
                }
                describeFields.append(this.invoke(Strings.getterName((String)a.getName(), (String)a.getType().getImplementationClassName())));
                boolean bl = first = toStringFields.length() == 0;
                if (first) {
                    toStringFields.append("\"\"");
                }
                toStringFields.append(" + ");
                String getterName = Strings.getterName((String)a.getName(), (String)a.getType().getImplementationClassName()) + "()";
                String getter = a.getType().isEnum() ? this.invoke(getterName, "label", new String[0]) : getterName;
                String string = g = first ? getter : "\" \" + " + getter;
                if (this.isAttrRequired(a)) {
                    toStringFields.append(g);
                    continue;
                }
                toStringFields.append("(").append(getterName).append("==null ? ").append("\"\"").append(" : ").append(g).append(")");
            }
            ((JavaElement.Method)((JavaElement.Method)((JavaElement.Method)((JavaElement.Method)this.method("describe", this.generic(Seq.class, new Class[]{String.class})).asPublic()).notNull()).asFinal()).override()).return_((CharSequence)this.invoke("", this.extractStaticImport(Conversions.class, "formatList"), new String[]{describeFields.toString()}));
            ((JavaElement.Method)((JavaElement.Method)((JavaElement.Method)this.method("toString", String.class).asPublic()).notNull()).override()).return_((CharSequence)toStringFields.toString());
        }
    }

    @NotNull
    private AttributeGenerator createAttributeGenerator(Attribute attribute) {
        AttributeGenerator ag = new AttributeGenerator(this, this.className, attribute);
        if (this.data != null) {
            ag.setClassForField("_data");
            ag.setFieldAsProtected();
        }
        return ag;
    }

    private JavaElement.Method createMethod() {
        String comment = String.format("Creates a new %s instance.", this.link(this.className));
        JavaElement.Method method = (JavaElement.Method)((JavaElement.Method)((JavaElement.Method)this.method(this.createMethodName(), this.className).asStatic()).notNull()).withComments(new String[]{comment});
        if (this.dbObject.isView()) {
            method.asProtected();
        } else {
            method.asPublic();
        }
        return method;
    }

    private JavaElement.Method findMethod(String methodName) {
        JavaElement.Method method = (JavaElement.Method)((JavaElement.Method)this.method(methodName, this.className).asStatic()).asPublic();
        ((JavaElement.Method)method.withComments(new String[]{String.format("Try to finds an Object of type '%s' in the database.", this.dbObject.getName())})).withComments(new String[]{methodName.equals("findWhere") ? "That verifies the specified condition." : IDENTIFIED_BY_KEY});
        if (methodName.equals("findPersisted") || methodName.equals("findPersistedOrFail")) {
            method.withComments(new String[]{"Ignoring caches and accessing the database"});
        }
        if (methodName.equals("findOrFail") || methodName.equals("findPersistedOrFail")) {
            method.withComments(new String[]{"Throws EntityNotFoundException if is not present"});
        } else {
            method.withComments(new String[]{"Returns <code>null</code> if is not present"});
        }
        return method;
    }

    private JavaElement.Method findOrCreateMethod() {
        return (JavaElement.Method)((JavaElement.Method)((JavaElement.Method)((JavaElement.Method)this.method("findOrCreate", this.className).asStatic()).asPublic()).notNull()).withComments(new String[]{String.format("Find (or create if not present) a '%s' in the database.", this.dbObject.getName()), IDENTIFIED_BY_KEY});
    }

    private void generateConstructor() {
        String getData = String.format("i -> ((%s) i)._data", this.getName());
        String setData = String.format("(i,d) -> ((%s) i)._data = (%s) d", this.getName(), this.dataClassName());
        ((JavaElement.Constructor)this.constructor().asProtected()).invokeSuper(new String[]{getData, setData});
    }

    private boolean hasCompositeKey() {
        return this.primaryKeyFields.size() > 1;
    }

    private boolean hasSingleDefaultPrimaryKey() {
        return this.dbObject.hasDefaultPrimaryKey() && !this.dbObject.hasCompositePrimaryKey();
    }

    private boolean hasStringKey() {
        return !this.hasCompositeKey() && !this.primaryKeyFields.isEmpty() && ((JavaElement.Field)this.primaryKeyFields.get(0)).getType().equals(String.class.getSimpleName());
    }

    private String invokeGetter(Attribute attribute) {
        return this.invoke("", Strings.getterName((String)attribute.getName(), (String)attribute.getElementClassName()), new String[0]);
    }

    private String invokeOnTable(String method, String ... args) {
        return this.invoke(this.invoke("", MY_ENTITY_TABLE, new String[0]), method, args);
    }

    private JavaElement.Method listMethod() {
        return (JavaElement.Method)((JavaElement.Method)((JavaElement.Method)this.method("list", this.generic(ImmutableList.class, new String[]{this.className})).asStatic()).asPublic()).notNull();
    }

    private String primaryKeyObject() {
        if (this.primaryKeyFields.isEmpty()) {
            return "new Object()";
        }
        ImmutableList fields = this.dbObject.retrieveSimpleFields();
        return fields.size() == 1 ? ((TypeField)fields.get(0)).getName() : this.invokeStatic(Tuple.class, CodeGeneratorConstants.tupleMethod((int)fields.size()), (Iterable)fields.map(TypeField::getName));
    }

    private String str(int n) {
        return String.valueOf(n);
    }

    @NotNull
    private String superClass() {
        return "mulesoft.persistence." + (this.isDeprecatedCached() ? "CachedEntityInstanceImpl" : (this.immutable ? "EntityInstanceBaseImpl" : "EntityInstanceImpl"));
    }

    private boolean isAttrRequired(ModelField f) {
        if (!(f instanceof Attribute)) {
            return true;
        }
        Attribute a = (Attribute)f;
        return a.isRequired() || this.dbObject.isPrimaryKey(a);
    }

    private boolean isDeprecatedCached() {
        CacheType cacheType = this.dbObject.getCacheType();
        return cacheType.isDefined() && !cacheType.isFull();
    }

    public static String makePrimaryKeyType(ClassGenerator cg, DbObject object) {
        ImmutableList pkFields = object.retrieveSimpleFields();
        Seq<String> pkTypes = EntityBaseCodeGenerator.types(cg, (Seq<TypeField>)pkFields);
        int size = pkFields.size();
        if (size == 0) {
            return "Object";
        }
        if (size == 1) {
            return (String)pkTypes.getFirst().get();
        }
        String tuple = Tuple.class.getName();
        if (size > 2) {
            tuple = tuple + size;
        }
        return cg.generic(tuple, pkTypes);
    }

    public static String getBaseTableClassName(@NotNull MetaModel model) {
        return model.getFullName() + "Base" + "." + "Table" + "Base";
    }

    static Seq<String> types(ClassGenerator cg, Seq<TypeField> pkFields) {
        return pkFields.map(value -> cg.extractImport(Primitives.wrapIfNeeded((String)value.getImplementationClassName())));
    }

    static class DataGenerator
    extends ClassGenerator {
        DataGenerator(EntityBaseCodeGenerator parent) {
            super((JavaItemGenerator)parent, "OpenData");
            ((ClassGenerator)((ClassGenerator)this.withSuperclass(parent.abstractDataClass()).asStatic()).asProtected()).suppressWarnings(new String[]{MMCodeGenConstants.FIELD_MAY_BE_FINAL});
        }

        public boolean isOpen() {
            return true;
        }
    }
}

