/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.codegen.entity;

import mulesoft.codegen.entity.AttributeGenerator;
import mulesoft.codegen.entity.EntityBaseCodeGenerator;
import mulesoft.codegen.impl.java.JavaCodeGenerator;
import mulesoft.codegen.impl.java.JavaElement;
import mulesoft.common.core.Strings;
import mulesoft.metadata.entity.Attribute;
import mulesoft.metadata.entity.DbObject;
import org.jetbrains.annotations.NotNull;

public class EntityBaseForUpdateCodeGenerator
extends EntityBaseCodeGenerator {
    private final String entityName;
    private final String immutableBase;

    public EntityBaseForUpdateCodeGenerator(EntityBaseCodeGenerator e, JavaCodeGenerator cg, @NotNull DbObject dbObject, String className) {
        super(cg, dbObject, className, true, e.primaryKeyFields);
        this.immutableBase = e.getName();
        this.entityName = dbObject.getName();
        this.extractImport(dbObject.getForUpdatePackage() + "." + className);
        e.createCopyTo();
    }

    @Override
    protected void populate() {
        this.withSuperclass(this.dbObject.getFullName());
        this.withInterfaces(new String[]{this.generic("mulesoft.persistence.PersistableInstance", new String[]{this.entityName, this.getPrimaryKeyType()})});
        this.withComments(new String[]{"Generated base ForUpdate class for entity: " + this.entityName + "."});
        this.dbObject.attributes().filter(a -> !this.dbObject.isPrimaryKey(a)).forEach(this::generateSetter);
        ((JavaElement.Method)((JavaElement.Method)this.method("modified", Boolean.TYPE).override()).asPublic()).return_((CharSequence)"true");
        this.addCreateMethods();
        this.createMutator();
    }

    @Override
    @NotNull
    String createMethodName() {
        return Strings.deCapitalizeFirst((String)this.className);
    }

    @Override
    @NotNull
    String getImmutableBase() {
        return this.immutableBase;
    }

    private void createMutator() {
        String argName = Strings.deCapitalizeFirst((String)this.entityName);
        ((JavaElement.Method)((JavaElement.Method)((JavaElement.Method)((JavaElement.Method)this.method(this.createMethodName(), this.className).asPublic()).asStatic()).withComments(new String[]{"Make a " + this.entityName + " mutable"})).return_((CharSequence)this.invoke(argName, "copyTo", new String[]{this.new_(this.className, new String[0])}))).arg(argName, this.immutableBase);
    }

    private void generateSetter(Attribute attribute) {
        AttributeGenerator ag = new AttributeGenerator(this, this.entityName, attribute);
        ag.setClassForField(String.format("((%s)this)", this.immutableBase));
        ag.generateSetter();
    }
}

