/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.codegen.entity;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import mulesoft.codegen.common.MMCodeGenerator;
import mulesoft.codegen.impl.java.ClassGenerator;
import mulesoft.codegen.impl.java.JavaCodeGenerator;
import mulesoft.codegen.impl.java.JavaElement;
import mulesoft.common.Predefined;
import mulesoft.common.collections.Maps;
import mulesoft.common.core.Strings;
import mulesoft.common.core.Tuple;
import mulesoft.common.util.Sha;
import mulesoft.field.FieldOption;
import mulesoft.metadata.entity.DbObject;
import mulesoft.metadata.entity.SearchField;
import mulesoft.type.ArrayType;
import mulesoft.type.EnumType;
import mulesoft.type.Kind;
import mulesoft.type.Type;
import org.jetbrains.annotations.NotNull;

public class EntitySearcherBaseCodeGenerator
extends ClassGenerator
implements MMCodeGenerator {
    private final DbObject dbObject;
    private static final int MAX_SHA_LENGTH = 30;
    private static final EnumMap<Kind, String> fieldClass = Maps.enumMap((Tuple)Tuple.tuple((Object)Kind.INT, (Object)"mulesoft.index.SearchableField.Int"), (Tuple[])new Tuple[]{Tuple.tuple((Object)Kind.REAL, (Object)"mulesoft.index.SearchableField.Real"), Tuple.tuple((Object)Kind.DECIMAL, (Object)"mulesoft.index.SearchableField.Decimal"), Tuple.tuple((Object)Kind.STRING, (Object)"mulesoft.index.SearchableField.Str"), Tuple.tuple((Object)Kind.BOOLEAN, (Object)"mulesoft.index.SearchableField.Bool"), Tuple.tuple((Object)Kind.DATE, (Object)"mulesoft.index.SearchableField.Date"), Tuple.tuple((Object)Kind.ENUM, (Object)"mulesoft.index.SearchableField.Enum"), Tuple.tuple((Object)Kind.DATE_TIME, (Object)"mulesoft.index.SearchableField.DTime")});
    private static final Map<String, String> fieldMethod = Maps.hashMap((Tuple)Tuple.tuple((Object)"mulesoft.index.SearchableField.Int", (Object)"intField"), (Tuple[])new Tuple[]{Tuple.tuple((Object)"mulesoft.index.SearchableField.Real", (Object)"realField"), Tuple.tuple((Object)"mulesoft.index.SearchableField.Decimal", (Object)"decimalField"), Tuple.tuple((Object)"mulesoft.index.SearchableField.Str", (Object)"strField"), Tuple.tuple((Object)"mulesoft.index.SearchableField.Bool", (Object)"boolField"), Tuple.tuple((Object)"mulesoft.index.SearchableField.Date", (Object)"dateField"), Tuple.tuple((Object)"mulesoft.index.SearchableField.DTime", (Object)"dateTimeField"), Tuple.tuple((Object)"mulesoft.index.SearchableField.LongFld", (Object)"longField"), Tuple.tuple((Object)"mulesoft.index.SearchableField.Ent", (Object)"entityField")});

    public EntitySearcherBaseCodeGenerator(JavaCodeGenerator cg, @NotNull DbObject dbObject) {
        super(cg, dbObject.getName() + "SearcherBase");
        this.dbObject = dbObject;
    }

    @Override
    public String getSourceName() {
        return this.getName();
    }

    protected void populate() {
        String name = this.dbObject.getFullName();
        this.withSuperclass(this.dbObject.isDatabaseSearchable() ? "tekgenesis.index.DatabaseSearcher" : "tekgenesis.index.IndexSearcher").withComments(new String[]{"Base class for index and searching " + name});
        JavaElement.Constructor defaultConstructor = (JavaElement.Constructor)((JavaElement.Constructor)this.constructor().withComments(new String[]{"Default constructor."})).asProtected();
        this.populateConstructor(defaultConstructor);
        if (!this.dbObject.isDatabaseSearchable()) {
            this.fieldWithGetter("INDEX_ID", this.shaFromFields(), "getIndexId");
        }
        String searcherFqn = name + "Searcher";
        ((JavaElement.Field)((JavaElement.Field)((JavaElement.Field)this.field(Strings.fromCamelCase((String)(this.dbObject.getName() + "Searcher")), searcherFqn, this.new_(searcherFqn, new String[0])).asStatic()).asFinal()).asPublic()).notNull();
        super.populate();
    }

    private void addSearchField(JavaElement.Constructor c, SearchField field, String constantName) {
        String fieldType;
        String implementationClassName = field.getField().getFinalType().getImplementationClassName();
        String className = this.classNameFromType(field.getField().getFinalType());
        String methodName = this.fieldMethodFromClass(className, implementationClassName);
        String fieldName = Strings.quoted((String)field.getFieldName());
        String fieldId = Strings.quoted((String)field.getId());
        boolean isEntity = methodName.equals("entityField");
        String fieldBuilder = this.invoke("fields") + "." + (isEntity || methodName.contains("enumField") ? this.invoke("", methodName, new String[]{fieldId, fieldName, this.classOf(implementationClassName)}) : this.invoke("", methodName, new String[]{fieldId, fieldName}));
        block4: for (FieldOption option : field.getOptions()) {
            switch (option) {
                case BOOST: {
                    fieldBuilder = this.invoke(fieldBuilder, "withBoost", new String[]{String.valueOf(field.getBoost())});
                    continue block4;
                }
                case FILTER_ONLY: {
                    fieldBuilder = this.invoke(fieldBuilder, "filterOnly", new String[0]);
                    continue block4;
                }
            }
            throw Predefined.unreachable((String)"Unsupported search field option.");
        }
        String string = field.isMultiple() ? this.generic(isEntity ? "mulesoft.index.SearchableField.ManyEnt" : "mulesoft.index.SearchableField.Many", new String[]{this.innerImplementationClass(field.getField().getFinalType())}) : (fieldType = className + (isEntity ? "<" + implementationClassName + ">" : ""));
        if (this.dbObject.isDatabaseSearchable()) {
            c.statement(fieldBuilder);
        } else {
            JavaElement.Field f = (JavaElement.Field)((JavaElement.Field)((JavaElement.Field)this.field(constantName, fieldType).asFinal()).asPublic()).notNull();
            if (field.isMultiple()) {
                fieldBuilder = this.invoke(this.invoke("fields"), isEntity ? "manyEntField" : "manyField", new String[]{fieldBuilder});
            }
            c.assign(f.getName(), fieldBuilder);
        }
    }

    @NotNull
    private String classNameFromType(Type type) {
        if (type.isDatabaseObject()) {
            return "mulesoft.index.SearchableField.Ent";
        }
        if (type instanceof EnumType) {
            return this.generic("mulesoft.index.SearchableField.Enum", new String[]{type.getImplementationClassName()});
        }
        if (Long.class.equals((Object)type.getImplementationClass())) {
            return "mulesoft.index.SearchableField.LongFld";
        }
        if (type instanceof ArrayType) {
            return this.classNameFromType(((ArrayType)type).getElementType());
        }
        String s = fieldClass.get(type.getKind());
        if (s == null) {
            throw Predefined.unreachable((String)("Kind is not supported by searchable: " + type.getKind() + ". In dbObject: " + this.dbObject.getFullName()));
        }
        return s;
    }

    @NotNull
    private String fieldMethodFromClass(String className, String implementationClass) {
        if (className.startsWith("Enum") || className.startsWith("mulesoft.index.SearchableField.Enum")) {
            return "<" + this.extractImport(implementationClass) + ">" + "enumField";
        }
        String s = fieldMethod.get(className);
        if (s == null) {
            throw Predefined.unreachable();
        }
        return s;
    }

    private void fieldWithGetter(String fieldName, String fieldValue, String getter) {
        ((JavaElement.Field)((JavaElement.Field)this.field(fieldName, String.class, Strings.quoted((String)fieldValue)).asStatic()).asFinal()).notNull();
        ((JavaElement.Method)((JavaElement.Method)((JavaElement.Method)this.method(getter, String.class).override()).return_((CharSequence)fieldName)).notNull()).asFinal();
    }

    private String innerImplementationClass(Type t) {
        if (t.isArray()) {
            return ((ArrayType)t).getElementType().getImplementationClassName();
        }
        return t.getImplementationClassName();
    }

    private void populateConstructor(JavaElement.Constructor c) {
        ArrayList<String> r = new ArrayList<String>();
        r.add(this.classOf(this.dbObject.getImplementationClassName()));
        for (SearchField field : this.dbObject.searchByFields()) {
            String fieldId = field.getId();
            String constantName = Strings.fromCamelCase((String)fieldId);
            this.addSearchField(c, field, constantName);
        }
        c.invokeSuper(r);
    }

    @NotNull
    private String shaFromFields() {
        String uniqueMapping = this.dbObject.getFullName() + "[" + this.dbObject.searchByFields().map(searchField -> searchField.getId() + ":" + this.classNameFromType(searchField.getField().getFinalType()) + ":" + searchField.optionsString()).mkString(",") + "]";
        Sha shaGenerator = new Sha();
        shaGenerator.process(uniqueMapping.getBytes());
        String sha = shaGenerator.getDigestAsString();
        return sha.length() > 30 ? sha.substring(0, 30) : sha;
    }
}

