/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.codegen.entity;

import java.math.BigDecimal;
import java.util.EnumSet;
import java.util.Map;
import mulesoft.codegen.common.MMCodeGenConstants;
import mulesoft.codegen.common.MMCodeGenerator;
import mulesoft.codegen.impl.java.EnumGenerator;
import mulesoft.codegen.impl.java.JavaCodeGenerator;
import mulesoft.codegen.impl.java.JavaElement;
import mulesoft.codegen.impl.java.JavaItemGenerator;
import mulesoft.common.collections.ImmutableList;
import mulesoft.common.collections.Seq;
import mulesoft.common.core.EnumException;
import mulesoft.common.core.Enumeration;
import mulesoft.common.core.Option;
import mulesoft.common.core.Strings;
import mulesoft.common.core.enumeration.Enumerations;
import mulesoft.common.env.i18n.I18nBundle;
import mulesoft.field.TypeField;
import mulesoft.type.EnumType;
import mulesoft.type.EnumValue;
import mulesoft.type.Type;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class EnumCodeGenerator
extends EnumGenerator
implements MMCodeGenerator {
    private final EnumType enumType;
    private final String keyClass;
    @NonNls
    private static final String BUNDLE_FIELD = "BUNDLE";
    @NonNls
    private static final String KEY_METHOD = "key";
    @NonNls
    static final String LABEL_FIELD = "label";
    private static final String NAME_METHOD = "name()";

    public EnumCodeGenerator(JavaCodeGenerator cg, EnumType enumType, boolean forExport) {
        super(cg, enumType.getName());
        this.enumType = enumType;
        this.addConstants(this.makeConstants());
        this.keyClass = enumType.getPkType().getImplementationClassName();
        String enumeration = this.generic(Enumeration.class, new String[]{this.getName(), this.keyClass});
        if (enumType.isException()) {
            this.withInterfaces(new String[]{enumeration, this.generic(EnumException.class, new String[]{EnumCodeGenerator.innerExceptionName(this.getName())})});
        } else {
            this.withInterfaces(new String[]{enumeration});
        }
        if (!forExport) {
            this.withInterfaces(enumType.getInterfaces());
        }
    }

    @Override
    public String getSourceName() {
        return this.enumType.getSourceName();
    }

    protected void populate() {
        String documentation = this.enumType.getDocumentation();
        if (!documentation.isEmpty()) {
            for (String d : documentation.split("\n")) {
                this.withComments(new String[]{d.trim()});
            }
            this.withComments(new String[]{""});
        }
        this.withComments(new String[]{"Generated base class for enum: " + this.getName() + "."});
        this.withComments(new String[]{"Don't modify this as this is an auto generated class that's gets generated"});
        this.withComments(new String[]{"every time the meta model file is modified. Use subclass instead."});
        this.suppressWarnings(MMCodeGenConstants.COMMON_SUPPRESSED_WARNINGS);
        String mapName = Strings.fromCamelCase((String)(this.getName() + "Map"));
        ((JavaElement.Field)((JavaElement.Field)((JavaElement.Field)this.field(mapName, this.generic(Map.class, new String[]{this.keyClass, this.getName()}), this.invokeStatic(Enumerations.class, "buildMap", new String[]{this.invoke("", "values", new String[0])})).asFinal()).asStatic()).notNull()).withGetter("map");
        JavaElement.Constructor cons = (JavaElement.Constructor)this.constructor().asPackage();
        cons.arg((JavaElement.Field)((JavaElement.Field)this.field(LABEL_FIELD, String.class).asFinal()).notNull());
        EnumCodeGenerator.addPropertiesForFields(this, this.enumType, cons);
        ((JavaElement.Field)((JavaElement.Field)this.field(BUNDLE_FIELD, I18nBundle.class.getName(), this.invokeStatic(I18nBundle.class, "getBundle", new String[]{this.classOf(this.getName())})).asFinal()).asStatic()).notNull();
        ((JavaElement.Method)((JavaElement.Method)((JavaElement.Method)this.method(LABEL_FIELD, String.class).notNull()).asFinal()).withComments(new String[]{"Returns the field label in the current locale"})).return_((CharSequence)this.invoke(BUNDLE_FIELD, "getString", new String[]{NAME_METHOD, LABEL_FIELD}));
        String indexField = this.enumType.getIndexFieldName();
        String indexMethod = !indexField.isEmpty() ? "get" + Strings.capitalizeFirst((String)indexField) : (EnumCodeGenerator.keyClassIsInteger(this.keyClass) ? KEY_METHOD : "ordinal");
        this.method("index", Integer.TYPE).return_((CharSequence)this.invoke(indexMethod));
        JavaElement.Method inMethod = (JavaElement.Method)((JavaElement.Method)((JavaElement.Method)((JavaElement.Method)this.method("in", Boolean.class).notNull()).asFinal()).withComments(new String[]{"Check that the enum is one of the specified values"})).return_((CharSequence)this.invoke(this.invokeStatic(EnumSet.class, "of", new String[]{"first", "rest"}), "contains", new String[]{"this"}));
        inMethod.arg("first", this.getName()).notNull();
        inMethod.arg("rest", this.getName() + "...").notNull();
        ((JavaElement.Method)((JavaElement.Method)((JavaElement.Method)this.method("imagePath", String.class).notNull()).asFinal()).withComments(new String[]{"Returns the field image path "})).return_((CharSequence)this.invoke(BUNDLE_FIELD, "getString", new String[]{String.format("%s + \".%s\"", NAME_METHOD, "image"), "\"\""}));
        String pkFieldName = this.enumType.getPkFieldName();
        ((JavaElement.Method)((JavaElement.Method)((JavaElement.Method)this.method(KEY_METHOD, this.keyClass).boxedNotNull()).asFinal()).withComments(new String[]{"Returns the enum primary key"})).return_((CharSequence)(pkFieldName.isEmpty() ? NAME_METHOD : pkFieldName));
        this.generateFactory(pkFieldName.isEmpty() ? "name" : pkFieldName, mapName);
        if (this.enumType.isException()) {
            this.generateExceptionMethods();
        }
        super.populate();
    }

    private void generateExceptionMethods() {
        String exceptionName = EnumCodeGenerator.innerExceptionName(this.getName());
        JavaElement.Method withoutArgs = (JavaElement.Method)((JavaElement.Method)((JavaElement.Method)this.method("Exception".toLowerCase(), exceptionName).override()).notNull()).asFinal();
        withoutArgs.return_((CharSequence)this.new_(exceptionName, new String[]{"this"}));
        JavaElement.Method withArgs = (JavaElement.Method)((JavaElement.Method)((JavaElement.Method)this.method("Exception".toLowerCase(), exceptionName).override()).notNull()).asFinal();
        withArgs.arg("args", "Object...").notNull();
        withArgs.return_((CharSequence)this.new_(exceptionName, new String[]{"this", "args"}));
    }

    private void generateFactory(String pkFieldName, String mapName) {
        String methodName = String.format("from%s", Strings.capitalizeFirst((String)pkFieldName));
        ((JavaElement.Method)((JavaElement.Method)((JavaElement.Method)((JavaElement.Method)this.method(methodName, this.generic(Option.class, new String[]{this.getName()})).withComments(new String[]{String.format("Get a %s from the %s", this.getName(), pkFieldName)})).asStatic()).asFinal()).return_((CharSequence)this.invokeStatic(Option.class, "ofNullable", new String[]{this.invoke(mapName, "get", new String[]{pkFieldName})}))).arg(pkFieldName, this.keyClass).notNull();
    }

    private Seq<String> makeConstants() {
        int fieldsNo = this.enumType.getChildren().size();
        TypeField[] enumFields = new TypeField[fieldsNo];
        int i = 0;
        for (TypeField t : this.enumType.getChildren()) {
            enumFields[i++] = t;
        }
        return this.enumType.getValues().map(value -> this.valueAsConstant((EnumValue)value, fieldsNo, enumFields));
    }

    private String quoteObject(Type type, Object o) {
        if (o == null) {
            return "null";
        }
        String value = o.toString();
        if (o instanceof BigDecimal) {
            return this.new_(BigDecimal.class, new String[]{Strings.quoted((String)value)});
        }
        if (o instanceof Number || o instanceof Boolean) {
            return value;
        }
        if (type.isEnum()) {
            return this.extractImport(type.getImplementationClassName()) + "." + value;
        }
        return Strings.quoted((String)value);
    }

    @NotNull
    private String valueAsConstant(EnumValue value, int fieldsNo, TypeField[] enumFields) {
        Object[] args = new String[fieldsNo + 1];
        args[0] = Strings.quoted((String)value.getLabel());
        for (int j = 0; j < fieldsNo; ++j) {
            args[j + 1] = this.quoteObject(enumFields[j].getFinalType(), value.getValues()[j]);
        }
        String doc = value.getFieldDocumentation();
        String javaDoc = "/** " + (doc.isEmpty() ? value.getLabel() : doc) + " */\n\t";
        return javaDoc + value.getName() + ImmutableList.fromArray((Object[])args).mkString("(", ", ", ")");
    }

    @NotNull
    static String innerExceptionName(@NotNull String name) {
        return name.replace("Exception", "") + "ApplicationException";
    }

    private static void addPropertiesForFields(JavaItemGenerator<?> cg, EnumType enumType, JavaElement.Constructor cons) {
        for (TypeField f : enumType.getChildren()) {
            JavaElement.Field fld = (JavaElement.Field)((JavaElement.Field)cg.readOnlyProperty(f.getName(), f.getType().getImplementationClassName()).asFinal()).required(f.isRequired());
            cons.arg(fld);
        }
    }

    private static boolean keyClassIsInteger(String keyClass) {
        return keyClass.endsWith("Integer");
    }
}

