/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.codegen.project;

import java.io.File;
import java.io.IOException;
import java.util.List;
import mulesoft.codegen.project.ProjectBuilder;
import mulesoft.common.collections.Colls;
import mulesoft.common.collections.ImmutableList;
import mulesoft.common.collections.Seq;
import mulesoft.mmcompiler.builder.BuilderErrorListener;

public class MmBuild {
    protected File outputDir = null;
    private final String[] args;
    private boolean entitiesOnly = false;
    private final BuilderErrorListener.Default errorListener = new BuilderErrorListener.Default();
    private String generatedDir = "";
    private String mmDir = "";
    private ImmutableList<String> models = Colls.emptyList();
    private boolean printGen = false;
    private String projectName = "";
    private boolean servicesOnly = false;
    private String sourcesDir = "";

    MmBuild(String[] args) {
        this.args = args;
    }

    final boolean build() throws IOException {
        List<File> generated = this.doBuild((Seq<String>)this.models, new File(this.sourcesDir), new File(this.generatedDir));
        if (this.printGen) {
            generated.forEach(System.out::println);
        }
        return this.errorListener.hasErrors();
    }

    List<File> doBuild(Seq<String> mms, File sources, File generated) throws IOException {
        if (mms.isEmpty()) {
            return Colls.emptyList();
        }
        ProjectBuilder pb = new ProjectBuilder(new File(this.mmDir), this.outputDir, generated, (BuilderErrorListener)this.errorListener, this.servicesOnly, this.entitiesOnly, (Iterable<File>)Colls.emptyIterable()).withProjectName(this.projectName);
        if (this.errorListener.hasErrors()) {
            return Colls.emptyList();
        }
        return pb.withGeneratedSourceDir(generated).withSourcesDir(sources).withModels((Iterable<String>)mms).buildProject();
    }

    final MmBuild parseArguments() {
        int i;
        String outDir = "";
        for (i = 0; i < this.args.length; ++i) {
            String arg = this.args[i];
            if ("-o".equals(arg)) {
                outDir = this.args[++i];
                continue;
            }
            if ("-g".equals(arg)) {
                this.generatedDir = this.args[++i];
                continue;
            }
            if ("-m".equals(arg)) {
                this.mmDir = this.args[++i];
                continue;
            }
            if ("-s".equals(arg)) {
                this.sourcesDir = this.args[++i];
                continue;
            }
            if ("-p".equals(arg)) {
                this.printGen = true;
                continue;
            }
            if ("-r".equals(arg)) {
                this.servicesOnly = true;
                continue;
            }
            if ("-e".equals(arg)) {
                this.entitiesOnly = true;
                continue;
            }
            if (!"-n".equals(arg)) break;
            this.projectName = this.args[++i];
        }
        if (outDir.isEmpty() || this.mmDir.isEmpty()) {
            MmBuild.usage();
            System.exit(0);
        }
        if (i < this.args.length) {
            this.models = ImmutableList.fromArray((Object[])this.args).subList(i, this.args.length);
        }
        this.outputDir = new File(outDir);
        return this;
    }

    public static void main(String[] args) throws IOException {
        if (new MmBuild(args).parseArguments().build()) {
            System.exit(1);
        }
    }

    private static void usage() {
        System.out.println("usage : -n <project name> -o <output dir> -g <generated sources dir> -s <sources dir> -m <meta models dir> -p <print generated> -r <generate remote services only> -e <generate metamodels only> files...");
    }
}

