/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.codegen.project;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import mulesoft.codegen.project.ProjectCodeGenerator;
import mulesoft.common.collections.Colls;
import mulesoft.common.collections.Seq;
import mulesoft.common.util.FileFilters;
import mulesoft.common.util.Files;
import mulesoft.mmcompiler.ModelRepositoryLoader;
import mulesoft.mmcompiler.builder.BuilderErrorListener;
import mulesoft.repository.ModelRepository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectBuilder {
    private final boolean entitiesOnly;
    private boolean forceBase;
    private File generatedSourcesDir;
    private File javaSourcesDir;
    private final File mmDir;
    private final List<String> mmFiles;
    private final ModelRepository modelRepository;
    private final File outputDir;
    private String project;
    private boolean remoteServices;
    private final Iterable<File> resourcesDirs;

    public ProjectBuilder(File mmDir, File outputDir, File generatedSourcesDir) {
        this(mmDir, outputDir, generatedSourcesDir, (BuilderErrorListener)new BuilderErrorListener.Default(), false, false, Collections.emptyList());
    }

    public ProjectBuilder(ModelRepository repository, File mmDir, @Nullable File outputDir, File generatedSourcesDir, Iterable<File> resourcesDirs) {
        this(repository, mmDir, outputDir, generatedSourcesDir, false, false, resourcesDirs);
    }

    public ProjectBuilder(File mmDir, File outputDir, File generatedSourcesDir, BuilderErrorListener errorListener, boolean remoteServices, boolean entitiesOnly, Iterable<File> resourcesDirs) {
        this(ProjectBuilder.loadFromClassPath(ProjectBuilder.class.getClassLoader(), mmDir, errorListener), mmDir, outputDir, generatedSourcesDir, remoteServices, entitiesOnly, resourcesDirs);
    }

    ProjectBuilder(ModelRepository repository, File mmDir, @Nullable File outputDir, File generatedSourcesDir, boolean remoteServices, boolean entitiesOnly, Iterable<File> resourcesDirs) {
        this.outputDir = outputDir;
        this.mmDir = mmDir;
        this.remoteServices = remoteServices;
        this.entitiesOnly = entitiesOnly;
        this.resourcesDirs = resourcesDirs;
        this.mmFiles = new ArrayList<String>();
        File sourceBase = mmDir.getParentFile();
        this.javaSourcesDir = new File(sourceBase, "java");
        this.generatedSourcesDir = generatedSourcesDir;
        this.forceBase = false;
        this.project = "";
        this.modelRepository = repository;
    }

    public List<File> buildProject() throws IOException {
        ProjectCodeGenerator generator = new ProjectCodeGenerator(this.project, this.modelRepository, this.javaSourcesDir, this.generatedSourcesDir, this.outputDir, this.mmDir, this.resourcesDirs);
        generator.withModels((Iterable<String>)this.listMetaModels());
        if (this.forceBase || this.remoteServices) {
            generator.withForceBaseGeneration();
        }
        if (this.entitiesOnly) {
            generator.withMetaModelsOnly();
        } else if (this.remoteServices) {
            generator.withRemoteServicesOnlyGeneration();
        }
        return generator.generate();
    }

    public ProjectBuilder withForceBaseGeneration() {
        this.forceBase = true;
        return this;
    }

    public ProjectBuilder withGeneratedSourceDir(File dir) {
        this.generatedSourcesDir = dir;
        return this;
    }

    public ProjectBuilder withModels(Iterable<String> models) {
        for (String model : models) {
            if (!model.endsWith("mm")) continue;
            this.mmFiles.add(model);
        }
        return this;
    }

    public ProjectBuilder withProjectName(@NotNull String projectName) {
        this.project = projectName;
        return this;
    }

    public ProjectBuilder withRemoteServices() {
        this.remoteServices = true;
        return this;
    }

    public ProjectBuilder withSourcesDir(File dir) {
        this.javaSourcesDir = dir;
        return this;
    }

    public ProjectBuilder withSourcesDir(String javaSourceDir) {
        return this.withSourcesDir(new File(javaSourceDir));
    }

    public File getGeneratedSourcesDir() {
        return this.generatedSourcesDir;
    }

    private Seq<String> listMetaModels() {
        if (this.mmFiles.isEmpty()) {
            this.mmFiles.addAll((Collection<String>)Files.list((File)this.mmDir, (FileFilter)FileFilters.withExtension((String)"mm")));
        }
        return Colls.immutable(this.mmFiles);
    }

    public static ModelRepository loadFromClassPath(ClassLoader classLoader, File mmDir, BuilderErrorListener errorListener) {
        ModelRepositoryLoader loader = new ModelRepositoryLoader(classLoader);
        loader.withErrorListener(errorListener);
        ModelRepository repository = loader.build();
        loader.addModels(mmDir);
        return repository;
    }
}

