/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.codegen.project;

import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import mulesoft.codegen.common.MMCodeGenerator;
import mulesoft.codegen.context.InterfaceTypeCodeGenerator;
import mulesoft.codegen.entity.DbTableCodeGenerator;
import mulesoft.codegen.entity.EntityBaseCodeGenerator;
import mulesoft.codegen.entity.EntityBaseForUpdateCodeGenerator;
import mulesoft.codegen.entity.EntitySearcherBaseCodeGenerator;
import mulesoft.codegen.entity.EntitySearcherCodeGenerator;
import mulesoft.codegen.entity.EnumCodeGenerator;
import mulesoft.codegen.entity.ExceptionEnumCodeGenerator;
import mulesoft.codegen.entity.UserClassGenerator;
import mulesoft.codegen.impl.java.ClassGenerator;
import mulesoft.codegen.impl.java.JavaCodeGenerator;
import mulesoft.codegen.impl.js.JsCodeGenerator;
import mulesoft.codegen.sql.SqlCodeGenerator;
import mulesoft.codegen.type.StructTypeCodeGenerator;
import mulesoft.codegen.type.UserStructTypeClassGenerator;
import mulesoft.common.collections.Colls;
import mulesoft.common.collections.ImmutableCollection;
import mulesoft.common.collections.ImmutableList;
import mulesoft.common.collections.MultiMap;
import mulesoft.common.collections.Seq;
import mulesoft.common.util.Files;
import mulesoft.metadata.entity.Attribute;
import mulesoft.metadata.entity.DbObject;
import mulesoft.metadata.entity.Entity;
import mulesoft.metadata.entity.SimpleType;
import mulesoft.metadata.entity.StructType;
import mulesoft.metadata.entity.TypeDef;
import mulesoft.repository.ModelRepository;
import mulesoft.type.EnumType;
import mulesoft.type.MetaModel;
import mulesoft.type.MetaModelKind;
import mulesoft.type.ModelType;
import mulesoft.type.Modifier;
import mulesoft.type.Type;
import mulesoft.util.MMDumper;
import org.jetbrains.annotations.NotNull;

public class ProjectCodeGenerator {
    private final List<MMCodeGenerator> baseGenerators;
    private final HashSet<DbObject> caseObjects;
    private boolean forceBase;
    private final List<File> generated;
    private final File generatedSourcesDir;
    private final List<String> importerTasks;
    private boolean metaModelsOnly;
    private final File mmDir;
    private final Predicate<MetaModel> MM_IN_DIRECTORY = new Predicate<MetaModel>(){

        @Override
        public boolean test(MetaModel mm) {
            return mm.getSourceName().startsWith(ProjectCodeGenerator.this.mmDir.getAbsolutePath());
        }
    };
    private final List<MetaModel> models;
    private final File outputDir;
    private final String project;
    private boolean remoteServices;
    private final ModelRepository repository;
    private final Iterable<File> resourcesDirs;
    private final File sourcesDir;
    private final Set<ClassGenerator> userGenerators;
    private final List<String> workItemTables;

    public ProjectCodeGenerator(String project, ModelRepository repository, File sourcesDir, File generatedSourcesDir, File outputDir, File mmDir, Iterable<File> resourcesDirs) {
        this.project = project;
        this.repository = repository;
        this.sourcesDir = sourcesDir;
        this.outputDir = outputDir;
        this.generatedSourcesDir = generatedSourcesDir;
        this.models = new ArrayList<MetaModel>();
        this.generated = new ArrayList<File>();
        this.caseObjects = new HashSet();
        this.workItemTables = new ArrayList<String>();
        this.importerTasks = new ArrayList<String>();
        this.forceBase = false;
        this.remoteServices = false;
        this.mmDir = mmDir;
        this.resourcesDirs = resourcesDirs;
        this.baseGenerators = new ArrayList<MMCodeGenerator>();
        this.userGenerators = new HashSet<ClassGenerator>();
    }

    List<File> generate() throws IOException {
        if (this.models.isEmpty()) {
            this.models.addAll((Collection<MetaModel>)this.repository.getModels());
        } else if (this.metaModelsOnly) {
            this.generateMetaModelsOnly();
        } else {
            this.models.forEach(this::createGenerator);
            this.generateBaseClasses();
            File htmlDir = new File(ProjectCodeGenerator.resourcesDir(this.sourcesDir), "html");
            this.generateUserClasses();
            SqlCodeGenerator.generateSchema(ProjectCodeGenerator.resourcesDir(this.sourcesDir), this.models, this.repository, (Seq<File>)Colls.immutable(this.resourcesDirs));
            this.createSchemaList();
            this.createEntityTableList();
            this.createMMList(o -> true);
        }
        return this.generated;
    }

    ProjectCodeGenerator withForceBaseGeneration() {
        this.forceBase = true;
        return this;
    }

    ProjectCodeGenerator withMetaModelsOnly() {
        this.metaModelsOnly = true;
        return this;
    }

    void withModels(Iterable<String> sources) {
        for (String source : sources) {
            this.models.addAll((Collection<MetaModel>)this.repository.getModelsByFile(source));
        }
    }

    ProjectCodeGenerator withRemoteServicesOnlyGeneration() {
        this.remoteServices = true;
        return this;
    }

    private boolean addWorkItem(Entity entity) {
        return this.workItemTables.add(entity.getFullName());
    }

    private void collectReferences(@NotNull Set<MetaModel> references, @NotNull MetaModel model) {
        for (MetaModel reference : model.getReferences()) {
            if (reference.getMetaModelKind() != MetaModelKind.TYPE && reference.getMetaModelKind() != MetaModelKind.ENUM || !references.add(reference)) continue;
            this.collectReferences(references, reference);
        }
    }

    private void copyMetamodelLocalization(File resourcesDir, MetaModel metaModel) throws IOException {
        String domainDir = metaModel.getDomain().replace(".", "/");
        ImmutableList properties = Files.list((File)new File(resourcesDir, domainDir), (String)(".*" + metaModel.getName() + ".*properties"));
        if (!properties.isEmpty()) {
            new File(this.outputDir, domainDir).mkdirs();
        }
        for (String propertyFile : properties) {
            Files.copy((File)new File(propertyFile), (File)new File(this.outputDir, new File(domainDir, new File(propertyFile).getName()).getPath()), (boolean)true);
        }
    }

    private void createDatabaseObjectGenerators(DbObject model, JavaCodeGenerator user, String domain) {
        JavaCodeGenerator generatedBase = this.getBaseGenerator(domain);
        this.userGenerators.add(new UserClassGenerator(user, (ModelType)model, this.getBasePackage(domain), model.getName()));
        EntityBaseCodeGenerator e = new EntityBaseCodeGenerator(generatedBase, model, model.getName());
        this.baseGenerators.add(e);
        if (model.splitMutator()) {
            String className = model.getName() + "ForUpdate";
            UserClassGenerator e1 = new UserClassGenerator(user, (ModelType)model, this.getBasePackage(domain), className);
            this.userGenerators.add(e1);
            this.baseGenerators.add(new EntityBaseForUpdateCodeGenerator(e, generatedBase, model, className));
        }
        this.baseGenerators.add(new DbTableCodeGenerator(generatedBase, model));
        if (model.isSearchableByFields()) {
            EntitySearcherBaseCodeGenerator generatedSearcher = new EntitySearcherBaseCodeGenerator(generatedBase, model);
            this.baseGenerators.add(generatedSearcher);
            this.userGenerators.add(new EntitySearcherCodeGenerator(user, model, generatedSearcher.getFullName()));
        }
    }

    private void createEntityTableList() throws IOException {
        File f = new File(this.outputDir, "META-INF/entity-list");
        Files.ensureDirExists((File)f.getParentFile());
        FileWriter writer = new FileWriter(f);
        for (DbObject e : Colls.filter((Iterable)this.repository.getModels(), DbObject.class).filter(this::isInMmDir).topologicalSort(this::dependenciesFor)) {
            writer.write(e.getFullName() + ' ' + e.getTableName() + "\n");
        }
        Files.close((Closeable)writer);
    }

    private void createEnumGenerators(EnumType model, String domain) {
        JavaCodeGenerator codeGenerator = this.createJavaCodeGenerator(domain);
        if (model.isException()) {
            this.baseGenerators.add(new ExceptionEnumCodeGenerator(codeGenerator, model));
        }
        this.baseGenerators.add(new EnumCodeGenerator(codeGenerator, model, this.metaModelsOnly || this.remoteServices));
    }

    private void createGenerator(MetaModel model) {
        String domain = model.getDomain();
        JavaCodeGenerator user = new JavaCodeGenerator(this.sourcesDir, domain);
        switch (model.getMetaModelKind()) {
            case ENTITY: 
            case VIEW: {
                this.createDatabaseObjectGenerators((DbObject)model, user, domain);
                break;
            }
            case ENUM: {
                this.createEnumGenerators((EnumType)model, domain);
                break;
            }
            case TYPE: {
                this.createTypeGenerator((TypeDef)model, user, domain);
                break;
            }
        }
    }

    private JavaCodeGenerator createJavaCodeGenerator(String domain) {
        return new JavaCodeGenerator(this.generatedSourcesDir, domain);
    }

    private JsCodeGenerator createJsCodeGenerator(String domain) {
        this.outputDir.mkdirs();
        File jsServices = new File(this.outputDir, "../../js/" + this.outputDir.getName());
        return new JsCodeGenerator(jsServices, domain);
    }

    private void createMetaModelList(Collection<String> mmFiles) {
        File f = new File(this.outputDir, "META-INF/meta-model-files");
        Files.writeLines((File)f, mmFiles);
    }

    private void createMMList(@NotNull Predicate<MetaModel> filter) throws IOException {
        Seq metaModels = this.repository.getModels().filter(this.MM_IN_DIRECTORY).filter(filter);
        MultiMap mms = MultiMap.createSortedMultiMap();
        for (MetaModel model : metaModels) {
            String d = new File(model.getSourceName()).getParent();
            int pos = d.length() - model.getDomain().length();
            mms.put((Object)new File(d.substring(0, pos)), (Object)model.getSourceName().substring(pos));
        }
        ArrayList<String> list = new ArrayList<String>();
        mms.values().forEach(list::addAll);
        this.createMetaModelList(list);
        for (File dir : mms.keys()) {
            if (this.metaModelsOnly) {
                this.dumpMetaModels(dir, (ImmutableCollection<String>)mms.get((Object)dir));
                continue;
            }
            Files.copyFiles((File)dir, (Iterable)mms.get((Object)dir), (File)this.outputDir, (boolean)false);
        }
    }

    private void createSchemaList() {
        MultiMap schemas = MultiMap.createSortedMultiMap();
        for (MetaModel model : this.repository.getModels().filter(this.MM_IN_DIRECTORY)) {
            String schema = model.getSchema();
            if (schema.isEmpty()) continue;
            schemas.put((Object)schema);
            for (MetaModel metaModel : model.getReferences()) {
                String s = ProjectCodeGenerator.schemaFor(metaModel);
                if (s.isEmpty() || s.equals(schema)) continue;
                schemas.put((Object)schema, (Object)s);
            }
        }
        ArrayList<String> lines = new ArrayList<String>();
        for (String schema : schemas.keys()) {
            lines.add(schema + " " + schemas.get((Object)schema).mkString(","));
        }
        Files.writeLines((File)new File(this.outputDir, "META-INF/schema-list"), lines);
    }

    private void createServices() {
        File servicesDir = new File(this.outputDir, "META-INF/services/");
        Files.writeLines((File)new File(servicesDir, "mulesoft.persistence.WorkItemTable"), this.workItemTables);
        Files.writeLines((File)new File(servicesDir, "mulesoft.persistence.etl.Importer"), this.importerTasks);
    }

    private void createTypeGenerator(TypeDef model, JavaCodeGenerator user, String domain) {
        if (model instanceof StructType) {
            StructType type = (StructType)model;
            JavaCodeGenerator cg = this.createJavaCodeGenerator(domain);
            if (type.hasModifier(Modifier.INTERFACE)) {
                this.baseGenerators.add(new InterfaceTypeCodeGenerator(cg, type));
            } else if (type.hasModifier(Modifier.FINAL) || this.remoteServices) {
                this.baseGenerators.add(new StructTypeCodeGenerator(cg, type, true));
            } else {
                this.baseGenerators.add(new StructTypeCodeGenerator(this.getBaseGenerator(domain), type));
                this.userGenerators.add(new UserStructTypeClassGenerator(user, type, this.getBasePackage(domain)).asSerializable());
            }
        }
    }

    @NotNull
    private Iterable<DbObject> dependenciesFor(DbObject dbObject) {
        ArrayList<DbObject> result = new ArrayList<DbObject>();
        for (Attribute attribute : dbObject.allAttributes()) {
            for (DbObject dbo : attribute.asDatabaseObject()) {
                if (attribute.isMultiple()) continue;
                result.add(dbo);
            }
        }
        return result;
    }

    private void dumpMetaModels(File sourceDir, ImmutableCollection<String> mmFiles) throws IOException {
        for (String mmFile : mmFiles) {
            String sourceName = new File(sourceDir, mmFile).getAbsolutePath();
            Set metaModels = this.repository.getModelsByFile(sourceName).filter(ProjectCodeGenerator::validModel).topologicalSort(mm -> mm.getReferences().filter(metaModel -> metaModel != null && metaModel.getSourceName().equals(sourceName)));
            if (metaModels.isEmpty()) continue;
            MMDumper dumper = MMDumper.createDumper((String)this.project, (ModelRepository)this.repository).withPackage().printRemoteAsExternal();
            File file = new File(this.outputDir, mmFile);
            file.getParentFile().mkdirs();
            File resourcesDir = new File(sourceDir, "../resources");
            for (MetaModel metaModel : metaModels) {
                dumper.model(metaModel);
                if (metaModel.getMetaModelKind() != MetaModelKind.FORM && metaModel.getMetaModelKind() != MetaModelKind.ENUM) continue;
                this.copyMetamodelLocalization(resourcesDir, metaModel);
            }
            FileWriter output = new FileWriter(file);
            dumper.toWriter((Writer)output);
            output.close();
        }
    }

    private void generateBaseClasses() {
        for (MMCodeGenerator generator : this.baseGenerators) {
            File source = new File(generator.getSourceName());
            if (this.forceBase) {
                generator.generate();
            }
            if (!this.forceBase && !generator.generateIfOlder(source)) continue;
            this.generated.add(generator.getTargetFile());
        }
    }

    private void generateMetaModelsOnly() throws IOException {
        for (MetaModel model : this.repository.getModels().filter(this::isInMmDir)) {
            if (model.getMetaModelKind() != MetaModelKind.ENUM) continue;
            this.createGenerator(model);
        }
        this.generateBaseClasses();
        this.createMMList(ProjectCodeGenerator::validModel);
    }

    private void generateUserClasses() {
        for (ClassGenerator generator : this.userGenerators) {
            if (!generator.generateIfAbsent()) continue;
            this.generated.add(generator.getTargetFile());
        }
    }

    private JavaCodeGenerator getBaseGenerator(String domain) {
        return new JavaCodeGenerator(this.generatedSourcesDir, this.getBasePackage(domain));
    }

    private String getBasePackage(String domain) {
        return domain + ".g";
    }

    private boolean isInMmDir(MetaModel mm) {
        assert (mm != null);
        return mm.getSourceName().startsWith(this.mmDir.getAbsolutePath());
    }

    public static String schemaFor(MetaModel m) {
        Type t;
        String schema = m.getSchema();
        if (schema.isEmpty() && m instanceof SimpleType && (t = ((SimpleType)m).getFinalType()) instanceof MetaModel) {
            schema = ((MetaModel)t).getSchema();
        }
        return schema;
    }

    private static File resourcesDir(File sourcesDir) {
        return new File(sourcesDir.getParent(), "resources");
    }

    private static boolean validModel(MetaModel metaModel) {
        if (metaModel == null) {
            return false;
        }
        MetaModelKind mm = metaModel.getMetaModelKind();
        return mm == MetaModelKind.ENUM || mm == MetaModelKind.ENTITY || mm == MetaModelKind.TYPE || metaModel instanceof SimpleType || mm == MetaModelKind.VIEW && !metaModel.hasModifier(Modifier.REMOTE);
    }
}

