/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.codegen.sql;

import mulesoft.common.core.Strings;
import mulesoft.database.introspect.SchemaInfo;
import mulesoft.database.introspect.SqlType;
import mulesoft.database.introspect.TableInfo;
import mulesoft.md.MdConstants;
import mulesoft.metadata.entity.AttributeBuilder;
import mulesoft.metadata.entity.Entity;
import mulesoft.metadata.entity.EntityBuilder;
import mulesoft.metadata.exception.BuilderException;
import mulesoft.metadata.exception.DuplicateFieldException;
import mulesoft.metadata.exception.InvalidFieldNameException;
import mulesoft.metadata.exception.InvalidTypeException;
import mulesoft.repository.ModelRepository;
import mulesoft.type.IntType;
import mulesoft.type.MetaModel;
import mulesoft.type.Type;
import mulesoft.type.Types;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaModelFromSql {
    @NotNull
    private final String enclosingPackage;
    public static final int CLOB_DEFAULT_LENGTH = 1000000;

    public MetaModelFromSql(@NotNull String enclosingPackage) {
        this.enclosingPackage = enclosingPackage;
    }

    public Entity buildEntity(TableInfo t) {
        EntityBuilder b = EntityBuilder.entityFromDatabase((String)this.enclosingPackage, (String)t.getSchema().getPlainName(), (String)t.getName());
        TableInfo.PrimaryKey pk = t.getPrimaryKey();
        if (!pk.isDefault()) {
            b.primaryKeyFromColumnNames(pk.getColumnNames());
        }
        for (TableInfo.Column c : t.getColumns()) {
            String name = Strings.deCapitalizeFirst((String)Strings.toCamelCase((String)c.getName()));
            Type type = MetaModelFromSql.typeFor(c.getType());
            if (type == null || MdConstants.isVersionField((String)name) || pk.isDefault() && "id".equals(name)) continue;
            AttributeBuilder a = new AttributeBuilder(name, type);
            try {
                b.addField(a);
            }
            catch (DuplicateFieldException | InvalidFieldNameException | InvalidTypeException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return b.build();
        }
        catch (BuilderException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public ModelRepository createRepository(SchemaInfo schema) {
        ModelRepository mr = new ModelRepository();
        for (TableInfo ti : schema.getTables()) {
            if (ti.getName().equals("_METADATA")) continue;
            mr.add((MetaModel)this.buildEntity(ti));
        }
        return mr;
    }

    @NotNull
    public ModelRepository createRepository(SchemaInfo schema, Iterable<String> tables) {
        ModelRepository mr = new ModelRepository();
        for (String t : tables) {
            TableInfo ti = (TableInfo)schema.getTable(t).get();
            if (ti == null) continue;
            mr.add((MetaModel)this.buildEntity(ti));
        }
        return mr;
    }

    @Nullable
    private static Type typeFor(SqlType type) {
        int size = type.getSize();
        int precision = type.getPrecision();
        switch (type.getSqlKind()) {
            case VARCHAR: 
            case NVARCHAR: {
                return Types.stringType((int)size);
            }
            case DECIMAL: {
                return Types.decimalType((int)size, (int)precision);
            }
            case DATE: {
                return Types.dateType();
            }
            case DATETIME: {
                return precision == -1 ? Types.dateTimeType() : Types.dateTimeType((int)precision);
            }
            case CLOB: {
                return Types.stringType((int)1000000);
            }
            case BOOLEAN: {
                return Types.booleanType();
            }
            case INT: {
                return size == 0 ? Types.intType() : Types.intType((int)size);
            }
            case BIGINT: {
                return Types.intType((int)(size == 0 ? IntType.MAX_LONG_LENGTH - 1 : size));
            }
            case DOUBLE: {
                return Types.realType();
            }
        }
        return null;
    }
}

