/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.codegen.sql;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mulesoft.codegen.sql.SqlExpressionGenerator;
import mulesoft.common.collections.Colls;
import mulesoft.common.collections.ImmutableList;
import mulesoft.common.collections.MultiMap;
import mulesoft.common.collections.Seq;
import mulesoft.common.core.Option;
import mulesoft.common.core.QName;
import mulesoft.common.core.StrBuilder;
import mulesoft.common.core.Strings;
import mulesoft.common.util.Files;
import mulesoft.database.DbMacro;
import mulesoft.database.introspect.ViewInfo;
import mulesoft.field.TypeField;
import mulesoft.metadata.entity.Attribute;
import mulesoft.metadata.entity.DbObject;
import mulesoft.metadata.entity.Entity;
import mulesoft.metadata.entity.SimpleType;
import mulesoft.metadata.entity.View;
import mulesoft.metadata.entity.ViewAttribute;
import mulesoft.type.MetaModel;
import mulesoft.type.Type;
import mulesoft.type.Types;
import mulesoft.type.UnresolvedTypeReference;
import mulesoft.type.exception.UnresolvedTypeReferenceException;
import org.jetbrains.annotations.NotNull;

public class SchemaCreationGenerator
implements AutoCloseable {
    private final Set<String> grantedReferences;
    private final File outputFile;
    private final String schema;
    private final PrintWriter writer;
    private static final String PRIMARY_KEY = "primary key";

    SchemaCreationGenerator(File dir, String schema) throws IOException {
        String fileName = schema.toLowerCase() + ".sql";
        File dbDir = new File(dir, "db/current/");
        Files.ensureDirExists((File)dbDir);
        this.outputFile = new File(dbDir, fileName);
        this.writer = new PrintWriter(this.outputFile);
        this.grantedReferences = new HashSet<String>();
        this.schema = schema;
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    void createSchema(@NotNull Iterable<MetaModel> models) {
        this.printf("-- SQL for Schema %s --\n\n", this.schema);
        ImmutableList entities = Colls.filter(models, Entity.class).toList();
        List<Attribute> serials = this.collectSerials((List<Entity>)entities);
        this.printSequences(serials);
        entities.forEach(this::createTable);
        this.printMetadataTable();
        for (View view : Colls.filter(models, View.class)) {
            if (!view.getAsQuery().isEmpty()) {
                this.printSqlView(view);
                continue;
            }
            if (view.isRemote()) {
                this.createTable(view);
                continue;
            }
            this.printView(view);
        }
        this.printIndexes((Seq<DbObject>)Colls.filter(models, DbObject.class));
        entities.forEach(this::createForeignKeys);
        this.printSerialComments(serials);
        this.writer.flush();
    }

    File getOutputFile() {
        return this.outputFile;
    }

    private MultiMap<DbObject, String> collectSelectReferences(View view) {
        MultiMap result = MultiMap.createSortedMultiMap();
        for (MetaModel entity : view.entities()) {
            if (entity instanceof UnresolvedTypeReference) {
                throw new UnresolvedTypeReferenceException(entity.getFullName());
            }
            if (entity instanceof SimpleType) {
                Type finalType = ((SimpleType)entity).getFinalType();
                DbObject dbObject = entity = finalType instanceof DbObject ? (DbObject)finalType : null;
            }
            if (!(entity instanceof DbObject) || entity.getSchema().equals(this.schema)) continue;
            result.put((Object)((DbObject)entity), (Object)this.schema);
        }
        return result;
    }

    private List<Attribute> collectSerials(List<Entity> entities) {
        ArrayList<Attribute> sequences = new ArrayList<Attribute>();
        for (Entity e : entities) {
            for (Attribute a : e.attributes()) {
                if (!a.isSerial()) continue;
                sequences.add(a);
            }
        }
        return sequences;
    }

    private String columns(Iterable<Attribute> attributes) {
        StrBuilder columns = new StrBuilder();
        for (Attribute attribute : attributes) {
            for (TypeField field : attribute.retrieveSimpleFields()) {
                columns.appendElement((Object)field.getColumnName());
            }
        }
        return columns.toString();
    }

    private void createForeignKeys(Entity entity) {
        for (Attribute attribute : entity.attributes()) {
            if (!attribute.hasColumn() || !attribute.isEntity() || ((Entity)attribute.asEntity().get()).getFullName().equals(entity.getFullName())) continue;
            this.foreignKeyConstraint(attribute);
        }
    }

    private void createTable(@NotNull Entity entity) {
        this.createTable(entity.getTableName());
        this.printColumnDefinitions(entity.getTableName(), (Seq<Attribute>)entity.attributes(), false);
        this.println();
        this.printConstraint("PK_" + entity.getTableName().getName().toUpperCase(), PRIMARY_KEY, (Seq<Attribute>)entity.getPrimaryKey());
        for (String index : entity.getUniqueIndexNames()) {
            this.println(",");
            this.printConstraint(this.indexName((DbObject)entity, index, true), "unique", (Seq<Attribute>)entity.getUniqueIndexByName(index));
        }
        this.printf("\n);;\n\n", new Object[0]);
    }

    private void createTable(@NotNull View view) {
        this.createTable(view.getTableName());
        this.printColumnDefinitions(view.getTableName(), (Seq<Attribute>)view.allAttributes(), view.isRemote());
        this.println();
        this.printConstraint("PK_" + view.getTableName().getName().toUpperCase(), PRIMARY_KEY, (Seq<Attribute>)view.getPrimaryKey());
        this.printf("\n);;\n\n", new Object[0]);
    }

    private void createTable(QName tableName) {
        this.printf("create table QName(%s, %s) (\n", tableName.getQualification(), tableName.getName());
    }

    private void foreignKeyConstraint(Attribute attribute) {
        DbObject base = attribute.getDbObject();
        Entity target = (Entity)attribute.asEntity().get();
        String name = Types.getConstrainedName((String)(attribute.getColumnName() + "_" + base.getTableName().getName()), (String)"fk");
        StrBuilder baseColumns = new StrBuilder().startCollection(", ");
        StrBuilder targetColumns = new StrBuilder().startCollection(", ");
        for (TypeField column : attribute.retrieveSimpleFields()) {
            baseColumns.appendElement((Object)column.getColumnName());
            targetColumns.appendElement((Object)column.getTargetColumnName());
        }
        this.foreignKeyConstraintPrint(base.getTableName().getName(), target, name, baseColumns.toString(), targetColumns.toString());
    }

    private void foreignKeyConstraintPrint(String baseTableName, Entity target, String name, String baseColumns, String targetColumns) {
        this.grantReferences(target);
        this.printf("alter table QName(%s, %s) add constraint %s\n", this.schema, baseTableName, name);
        this.printf("\tforeign key (%s)\n", baseColumns);
        this.printf("\treferences QName(%s, %s) (%s);;\n\n", target.getSchema(), target.getTableName().getName(), targetColumns);
    }

    private void grantReferences(Entity target) {
        if (target.getSchema().equals(this.schema)) {
            return;
        }
        String e = this.schema + ":" + target.getFullName();
        if (this.grantedReferences.contains(e)) {
            return;
        }
        this.printf("-- if %s%n", DbMacro.NeedsGrantReference);
        this.printf("grant references on QName(%s,%s) to SchemaOrUser(%s);;%n", target.getSchema(), target.getTableName().getName(), this.schema);
        this.println("-- end");
        this.grantedReferences.add(e);
    }

    private String indexName(DbObject entity, String name, boolean unique) {
        String suffix = unique ? "unqt" : "idxt";
        return Types.getConstrainedName((String)(entity.getTableName().getName() + "_" + Strings.fromCamelCase((String)name)), (String)suffix);
    }

    private void printColumnDefinition(String name, String sqlType, boolean required, String defaultValue, String checkExpr) {
        this.printf("\t%s,%n", String.format("%-33s %-16s %-24s %s", name, sqlType, (defaultValue.isEmpty() ? "" : "default " + defaultValue) + " " + checkExpr, required ? "not null" : "").trim());
    }

    private void printColumnDefinition(QName tableName, String columnName, Type type, boolean required, boolean multiple, String defaultValue) {
        String constraintName = Types.getConstrainedName((String)(tableName.getName() + "_" + columnName), (String)"B");
        this.printColumnDefinition(columnName, type.getSqlImplementationType(multiple).toLowerCase(), required, defaultValue, type.isBoolean() ? DbMacro.CheckBoolConstraint.name() + "(" + constraintName + ", " + columnName + ")" : "");
    }

    private void printColumnDefinitions(QName tableName, @NotNull Seq<Attribute> attributes, boolean remote) {
        for (Attribute a : attributes) {
            if (a.isSerial() && !remote) {
                this.printIdentityColumn(a);
                continue;
            }
            if (!a.hasColumn()) continue;
            for (TypeField f : a.retrieveSimpleFields()) {
                this.printColumnDefinition(tableName, f.getColumnName(), f.getType(), f.isRequired(), f.isMultiple(), a.isEntity() ? "" : SqlExpressionGenerator.defaultFor(f, f.isMultiple()));
            }
        }
    }

    private void printConstraint(String name, String type, Seq<Attribute> columns) {
        this.printf("\tconstraint %-22.30s %-11s (%s)", name, type, this.columns((Iterable<Attribute>)columns));
    }

    private void printf(String str, Object ... args) {
        this.writer.printf(str, args);
    }

    private void printGrantSelectReferences(MultiMap<DbObject, String> grants) {
        this.printf("-- if %s\n\n", DbMacro.NeedsGrantReference);
        for (Map.Entry entry : grants.asMap().entrySet()) {
            for (String u : (Collection)entry.getValue()) {
                DbObject e = (DbObject)entry.getKey();
                this.printf("grant select on QName(%s,%s) to SchemaOrUser(%s) with grant option;;\n", e.getSchema(), e.getTableName().getName(), u);
            }
        }
        this.printf("\n-- end\n\n", new Object[0]);
    }

    private void printIdentityColumn(Attribute a) {
        this.printf("\t%-33s %-41s not null,%n", a.getColumnName(), SchemaCreationGenerator.serialType(a));
    }

    private void printIndexes(Seq<DbObject> entities) {
        for (DbObject entity : entities) {
            for (String indexName : entity.getIndexNames()) {
                String index = this.indexName(entity, indexName, false);
                String indexColumns = this.columns((Iterable<Attribute>)entity.getIndexByName(indexName));
                this.printf("create index IndexName(%s, %s)\n", this.schema, index);
                this.printf("\ton QName(%s, %s) (%s) %s;;\n\n", this.schema, entity.getTableName().getName(), indexColumns, "IndexTableSpace");
            }
        }
    }

    private void println() {
        this.writer.println();
    }

    private void println(String s) {
        this.writer.println(s);
    }

    private void printMetadataTable() {
        QName tableName = QName.createQName((String)this.schema, (String)"_METADATA");
        this.createTable(tableName);
        this.printColumnDefinition(tableName, "VERSION", (Type)Types.stringType((int)24), true, false, "");
        this.printColumnDefinition(tableName, "SHA", (Type)Types.stringType((int)128), true, false, "");
        this.printColumnDefinition(tableName, "SHA_OVL", (Type)Types.stringType((int)128), false, false, "");
        this.printColumnDefinition(tableName, "UPDATE_TIME", (Type)Types.dateTimeType(), false, false, "");
        this.printColumnDefinition(tableName, "SCHEMA", (Type)Types.textType(), false, false, "");
        this.printColumnDefinition(tableName, "OVERLAY", (Type)Types.textType(), false, false, "");
        this.printf("\n\tconstraint %-22s primary key (%s)\n", "PK_METADATA", "VERSION");
        this.printf(");;\n\n", new Object[0]);
    }

    private void printSequences(List<Attribute> serials) {
        if (serials.isEmpty()) {
            return;
        }
        this.printf("-- if %s\n\n", DbMacro.NeedsCreateSequence);
        for (Attribute a : serials) {
            this.printf("create sequence QName(%s, %s)\n", this.schema, a.getSequenceName());
            this.printf("\tstart with %s(%d) increment by 1 %s;;\n\n", DbMacro.SequenceStartValue, a.getSequenceStart(), DbMacro.SequenceCache);
        }
        this.printf("-- end\n\n", new Object[0]);
    }

    private void printSerialComments(List<Attribute> serials) {
        if (serials.isEmpty()) {
            return;
        }
        this.printf("-- if %s%n", DbMacro.NeedsSerialComment);
        for (Attribute a : serials) {
            String col = String.format("QName(%s,%s).%s", this.schema, a.getDbObject().getTableName().getName(), a.getColumnName());
            this.printf("comment on column %-40s is '%s';;%n", col, SchemaCreationGenerator.serialType(a));
        }
        this.printf("-- end%n%n", new Object[0]);
    }

    private void printSqlView(View view) {
        MultiMap<DbObject, String> map = this.collectSelectReferences(view);
        if (!map.isEmpty()) {
            this.printGrantSelectReferences(map);
        }
        this.printf("create view QName(%s, %s) as\n", this.schema, view.getTableName().getName());
        this.printf("\t%s;;\n\n", view.getAsQuery());
        this.printf("%s  QName(%s, %s) is '%s';;\n\n", DbMacro.CommentOnView, this.schema, view.getTableName().getName(), ViewInfo.quoteViewSql((String)view.getAsQuery()));
    }

    private void printView(View view) {
        Option baseEntity = view.getBaseEntity();
        Seq attributes = view.allAttributes();
        ArrayList<String> columns = new ArrayList<String>();
        for (Attribute a : attributes) {
            Attribute attr = a instanceof ViewAttribute ? ((ViewAttribute)a).getBaseAttribute() : a;
            for (TypeField t : attr.retrieveSimpleFields()) {
                columns.add(t instanceof ViewAttribute ? ((ViewAttribute)t).getBaseAttribute().getColumnName() : t.getColumnName());
            }
        }
        MultiMap<DbObject, String> map = this.collectSelectReferences(view);
        if (!map.isEmpty()) {
            this.printGrantSelectReferences(map);
        }
        QName tableName = ((DbObject)baseEntity.get()).getTableName();
        this.printf("create view QName(%s, %s) (%s) as\n", this.schema, view.getTableName().getName(), this.columns((Iterable<Attribute>)attributes));
        this.printf("\tselect %s\n", Colls.mkString(columns, (String)", "));
        this.printf("\tfrom QName(%s, %s);;\n\n", tableName.getQualification(), tableName.getName());
        this.printf("%s  QName(%s, %s) is 'select %s from  QName(%s, %s)';;\n\n", DbMacro.CommentOnView, this.schema, view.getTableName().getName(), Colls.mkString(columns, (String)", "), tableName.getQualification(), tableName.getName());
    }

    private static String serialType(Attribute a) {
        return String.format("%s(%d,%s)", (a.getFinalType().getSqlType() == -5 ? DbMacro.BigSerial : DbMacro.Serial).name(), a.getSequenceStart(), a.getSequenceName());
    }
}

