/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.codegen.sql;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import mulesoft.codegen.sql.SchemaCreationGenerator;
import mulesoft.common.collections.Colls;
import mulesoft.common.collections.ImmutableList;
import mulesoft.common.collections.MultiMap;
import mulesoft.common.collections.Seq;
import mulesoft.common.util.Diff;
import mulesoft.common.util.Files;
import mulesoft.common.util.VersionString;
import mulesoft.database.DbIntrospector;
import mulesoft.database.SchemaDefinition;
import mulesoft.database.SqlConstants;
import mulesoft.database.introspect.delta.DeltaGenerator;
import mulesoft.repository.ModelRepository;
import mulesoft.type.MetaModel;
import org.jetbrains.annotations.NotNull;

public class SqlCodeGenerator {
    private SqlCodeGenerator() {
    }

    public static void generateSchema(@NotNull File dir, @NotNull Iterable<MetaModel> models, @NotNull ModelRepository repository, Seq<File> resourcesDir) throws IOException {
        MultiMap<String, MetaModel> schemaMms = SqlCodeGenerator.collectSchemas(models, repository);
        for (String schemaName : schemaMms.keys()) {
            SchemaCreationGenerator g = new SchemaCreationGenerator(dir, schemaName);
            Throwable throwable = null;
            try {
                g.createSchema((Iterable<MetaModel>)schemaMms.get((Object)schemaName));
                SqlCodeGenerator.checkLastVersion(schemaName, g.getOutputFile(), resourcesDir);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (g == null) continue;
                if (throwable != null) {
                    try {
                        g.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                g.close();
            }
        }
    }

    private static void checkLastVersion(String schemaName, File sqlFile, Seq<File> resourcesDir) throws IOException {
        TreeMap versions = SchemaDefinition.findVersions((File)sqlFile);
        ImmutableList currentLines = Files.readLines((File)sqlFile);
        if (versions.isEmpty()) {
            SqlCodeGenerator.copySql(sqlFile, (ImmutableList<String>)currentLines, VersionString.VERSION_ONE);
            return;
        }
        Map.Entry le = versions.lastEntry();
        VersionString lastVersion = (VersionString)le.getKey();
        File lastVersionFile = (File)le.getValue();
        ImmutableList versionLines = Files.readLines((File)lastVersionFile);
        if (SqlConstants.hasGeneratedMark((ImmutableList)versionLines)) {
            SqlCodeGenerator.dropGenerated(lastVersionFile);
            SqlCodeGenerator.checkLastVersion(schemaName, sqlFile, resourcesDir);
            return;
        }
        if (Diff.ignoreAllSpace().diff((List)versionLines, (List)currentLines).isEmpty()) {
            return;
        }
        DeltaGenerator dg = new DeltaGenerator(DbIntrospector.introspectSchema((String)schemaName, resourcesDir, (File[])new File[]{lastVersionFile}), DbIntrospector.introspectSchema((String)schemaName, resourcesDir, (boolean)true, (File[])new File[]{sqlFile}));
        VersionString newVersion = lastVersion.increment(dg.isMinor());
        File deltaFile = new File(SchemaDefinition.versionDirDelta((File)sqlFile.getParentFile().getParentFile(), (VersionString)newVersion), sqlFile.getName());
        Files.ensureDirExists((File)deltaFile.getParentFile());
        try (FileWriter writer = new FileWriter(deltaFile);){
            dg.generate((Writer)writer);
        }
        SqlCodeGenerator.copySql(sqlFile, (ImmutableList<String>)currentLines, newVersion);
    }

    private static MultiMap<String, MetaModel> collectSchemas(Iterable<MetaModel> models, ModelRepository repository) {
        HashSet<String> schemas = new HashSet<String>();
        for (MetaModel model : models) {
            String schema = model.getSchema();
            if (schema.isEmpty()) continue;
            schemas.add(schema);
        }
        MultiMap schemaMms = MultiMap.createSortedMultiMap();
        for (String schema : schemas) {
            for (MetaModel metaModel : repository.getModelsBySchema(schema)) {
                schemaMms.put((Object)schema, (Object)metaModel);
            }
        }
        return schemaMms;
    }

    private static void copySql(File sqlFile, ImmutableList<String> currentLines, VersionString version) throws IOException {
        File dbDir = sqlFile.getParentFile().getParentFile();
        File dir = SchemaDefinition.versionDir((File)dbDir, (VersionString)version);
        Files.writeLines((File)new File(dir, sqlFile.getName()), (Iterable)SqlCodeGenerator.generatedHeader().append(currentLines));
        File ovlFile = SqlCodeGenerator.ovlFile(sqlFile);
        File targetOvl = new File(dir, ovlFile.getName());
        if (ovlFile.exists()) {
            Files.copy((File)ovlFile, (File)targetOvl, (boolean)true);
        } else {
            Files.remove((File)targetOvl);
        }
    }

    private static void dropGenerated(File versionFile) {
        versionFile.delete();
        File versionDir = versionFile.getParentFile();
        File versionBaseDir = versionDir.getParentFile();
        File deltaDir = new File(versionBaseDir, "delta/");
        new File(deltaDir, versionFile.getName()).delete();
        if (Files.deleteDirIfEmpty((File)versionDir) && Files.deleteDirIfEmpty((File)deltaDir)) {
            Files.deleteDirIfEmpty((File)versionBaseDir);
        }
    }

    private static ImmutableList<String> generatedHeader() {
        return Colls.listOf((Object)String.format("-- %s at %tF %<tT", "@Generated", Calendar.getInstance()), (Object)"");
    }

    private static File ovlFile(File sqlFile) {
        return new File(sqlFile.getParentFile(), Files.removeExtension((File)sqlFile) + "_ovl.sql");
    }
}

