/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.codegen.sql;

import mulesoft.common.core.Option;
import mulesoft.database.DbMacro;
import mulesoft.database.SqlConstants;
import mulesoft.expr.Expression;
import mulesoft.field.TypeField;
import mulesoft.type.EnumType;
import mulesoft.type.Type;
import org.jetbrains.annotations.NotNull;

class SqlExpressionGenerator {
    private SqlExpressionGenerator() {
    }

    public static String defaultFor(TypeField field, boolean multiple) {
        String sql = SqlExpressionGenerator.sqlFor(field.getDefaultValue(), multiple);
        return !sql.isEmpty() || !field.isRequired() ? sql : SqlExpressionGenerator.defaultForType(field.getType(), multiple);
    }

    private static String defaultForType(Type type, boolean multiple) {
        switch (type.getKind()) {
            case BOOLEAN: {
                return DbMacro.False.name();
            }
            case STRING: {
                return DbMacro.EmptyString.name();
            }
            case DATE_TIME: {
                return DbMacro.CurrentTime.name();
            }
            case DATE: {
                return DbMacro.CurrentDate.name();
            }
            case REAL: 
            case INT: 
            case DECIMAL: {
                return "0";
            }
            case ENUM: {
                if (multiple) {
                    return "0";
                }
                EnumType e = (EnumType)type;
                return e.sqlIdFor(e.getDefaultValue(), false);
            }
        }
        return "";
    }

    @NotNull
    private static String sqlFor(Expression e, boolean multiple) {
        if (e.isNull()) {
            return "";
        }
        Option constantValue = e.getConstantValue();
        if (constantValue.isEmpty()) {
            return "";
        }
        Object value = constantValue.get();
        if (e.getType().isEnum() && value instanceof String) {
            return ((EnumType)e.getType()).sqlIdFor((String)value, multiple);
        }
        return SqlConstants.sqlValue((Object)value);
    }
}

