/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.codegen.type;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mulesoft.codegen.common.Generators;
import mulesoft.codegen.common.MMCodeGenConstants;
import mulesoft.codegen.common.MMCodeGenerator;
import mulesoft.codegen.impl.java.ClassGenerator;
import mulesoft.codegen.impl.java.JavaCodeGenerator;
import mulesoft.codegen.impl.java.JavaElement;
import mulesoft.common.collections.Colls;
import mulesoft.common.collections.ImmutableList;
import mulesoft.common.collections.ImmutableSet;
import mulesoft.common.collections.Seq;
import mulesoft.common.core.QName;
import mulesoft.common.core.Strings;
import mulesoft.field.FieldOption;
import mulesoft.field.TypeField;
import mulesoft.metadata.entity.StructType;
import mulesoft.type.ArrayType;
import mulesoft.type.Kind;
import mulesoft.type.Modifier;
import mulesoft.type.Type;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class StructTypeCodeGenerator
extends ClassGenerator
implements MMCodeGenerator {
    protected final StructType type;
    private final ImmutableSet<String> args;
    private final Map<String, JavaElement.Field> fields;
    private static final ImmutableList<String> V = Colls.listOf((Object)"getterVisibility", (Object)"isGetterVisibility", (Object)"setterVisibility", (Object)"creatorVisibility", (Object)"fieldVisibility");
    @NonNls
    public static final String TO_JSON = "toJson";
    @NonNls
    public static final String STREAM = "stream";
    @NonNls
    public static final String FROM_JSON = "fromJson";

    public StructTypeCodeGenerator(JavaCodeGenerator cg, @NotNull StructType type) {
        this(cg, type, type.hasModifier(Modifier.FINAL));
    }

    public StructTypeCodeGenerator(JavaCodeGenerator cg, @NotNull StructType type, boolean isFinal) {
        super(cg, type.getName() + (isFinal ? "" : "Base"));
        this.type = type;
        this.args = type.getArgs();
        this.fields = new LinkedHashMap<String, JavaElement.Field>();
    }

    @Override
    public String getSourceName() {
        return this.type.getSourceName();
    }

    protected void populate() {
        this.withComments(new String[]{"Generated base class for type: " + this.type.getName() + "."});
        this.withComments(new String[]{"Don't modify this as this is an auto generated class that's gets generated"});
        this.withComments(new String[]{"every time the meta model file is modified. Use subclass instead."});
        this.suppressWarnings(MMCodeGenConstants.COMMON_SUPPRESSED_WARNINGS);
        if (this.type.hasModifier(Modifier.FINAL)) {
            this.asFinal();
        }
        this.asSerializable();
        this.addExtendsAndImplements();
        this.addFields();
        this.withAnnotation(this.extractImport("com.fasterxml.jackson.annotation.JsonPropertyOrder"), Colls.seq(this.fields.keySet()).map(Strings::quoted));
        String none = this.extractStaticImport(QName.createQName((String)"com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility", (String)"NONE"));
        this.withAnnotation(this.extractImport("com.fasterxml.jackson.annotation.JsonAutoDetect"), V.map(s -> s + "=" + none).mkString(","));
        this.addConstructor();
        this.addEqualsAndHashCode();
        this.addToStringMethod();
        super.populate();
    }

    private void addArgumentFromSuperTypes(List<JavaElement.Field> superArgs, JavaElement.Constructor c) {
        this.type.getSuperTypes().forEach(parent -> c.invokeSuper((Iterable)parent.getArgs()));
        superArgs.forEach(field -> {
            String fieldName = field.getName();
            JavaElement.Argument arg = (JavaElement.Argument)c.arg(fieldName, field.getType()).withAnnotation(this.extractImport("com.fasterxml.jackson.annotation.JsonProperty"), Strings.quoted((String)fieldName));
            if (field.isNotNull()) {
                arg.notNull();
            }
        });
    }

    private void addArgumentsFromComposition(List<String> compositeArgs, JavaElement.Constructor c) {
        compositeArgs.forEach(arg -> {
            JavaElement.Field field = this.fields.get(arg);
            if (field.isNotNull()) {
                StructType structType = (StructType)((TypeField)this.type.getField(arg).get()).getType();
                structType.getArgs().forEach(childArg -> {
                    TypeField typeField = (TypeField)structType.getField(childArg).get();
                    JavaElement.Argument argument = (JavaElement.Argument)c.arg(childArg, this.getImplementationClassName(typeField)).withAnnotation(this.extractImport("com.fasterxml.jackson.annotation.JsonProperty"), Strings.quoted((String)childArg));
                    if (typeField.isRequired()) {
                        argument.notNull();
                    }
                });
                c.assign(field.getName(), this.new_(structType.getImplementationClassName(), (Iterable)structType.getArgs()));
            }
        });
    }

    private void addConstructor() {
        List<JavaElement.Field> superArgs = this.getSuperTypeArguments();
        ImmutableList<String> compositeArgs = this.getCompositeArguments();
        if (this.args.isEmpty() && superArgs.isEmpty() && compositeArgs.isEmpty()) {
            return;
        }
        JavaElement.Constructor c = (JavaElement.Constructor)((JavaElement.Constructor)this.constructor().withAnnotation(this.extractImport("com.fasterxml.jackson.annotation.JsonCreator"))).withComments(new String[]{StructTypeCodeGenerator.typeConstructorComment(this.type)});
        this.addArgumentFromSuperTypes(superArgs, c);
        this.addArgumentsFromComposition((List<String>)compositeArgs, c);
        this.args.forEach(a -> {
            JavaElement.Argument cfr_ignored_0 = (JavaElement.Argument)c.arg(this.fields.get(a)).withAnnotation(this.extractImport("com.fasterxml.jackson.annotation.JsonProperty"), Strings.quoted((String)a));
        });
    }

    private void addEqualsAndHashCode() {
        Seq fieldNames = this.args.isEmpty() ? this.getFields().map(field -> field.getName()) : this.args;
        ImmutableList fs = fieldNames.toList();
        this.withEquals((List)fs).withHashCode((Iterable)fieldNames);
    }

    private void addExtendsAndImplements() {
        boolean noExtension = true;
        for (StructType parent : this.type.getSuperTypes()) {
            if (parent.isInterface()) {
                this.withInterfaces(new String[]{parent.getFullName()});
                continue;
            }
            noExtension = false;
            this.withSuperclass(parent.getFullName());
        }
    }

    private void addField(@NotNull TypeField field) {
        String t = this.getImplementationClassName(field);
        JavaElement.Field f = this.field(field.getName(), t);
        f.withAnnotation(this.extractImport("com.fasterxml.jackson.annotation.JsonProperty"));
        this.fields.put(f.getName(), f);
        this.classField(f, field);
    }

    private void addFields() {
        LinkedHashMap<String, TypeField> fieldMap = new LinkedHashMap<String, TypeField>();
        for (StructType parent : this.type.getSuperTypes()) {
            if (!parent.isInterface()) continue;
            for (TypeField field : parent.getChildren()) {
                fieldMap.put(field.getName(), field);
            }
        }
        for (TypeField field : this.type.getChildren()) {
            fieldMap.put(field.getName(), field);
        }
        for (StructType parent : this.type.getSuperTypes()) {
            if (parent.isInterface()) continue;
            for (TypeField field : parent.getChildren()) {
                fieldMap.remove(field.getName());
            }
        }
        fieldMap.values().forEach(this::addField);
    }

    private void addFieldSetter(TypeField field, String name, String t) {
        JavaElement.Method setter = this.setter(name, this.type.getImplementationClassName());
        setter.boxedNotNull();
        setter.arg(name, t).required(field.isRequired());
        setter.withSetterComments(name);
        setter.assign(this.THIS(name), Generators.verifyField(this, name, field));
        setter.return_((CharSequence)this.referenceThisType("this"));
    }

    private void addToStringMethod() {
        ((JavaElement.Method)((JavaElement.Method)this.method("toString", String.class).override()).notNull()).return_((CharSequence)this.invoke("", TO_JSON, new String[0]));
    }

    private JavaElement.Field classField(JavaElement.Field f, TypeField field) {
        boolean isMutable = !this.args.contains((Object)f.getName());
        boolean required = field.isRequired();
        f.withGetter(field.hasOption(FieldOption.PROTECTED) ? 4 : 1).required(required);
        if (isMutable) {
            String defaultValue = this.getDefaultFieldValue(field, required);
            f.withValue(defaultValue);
            this.addFieldSetter(field, field.getName(), this.getImplementationClassName(field));
        }
        return f;
    }

    private String referenceThisType(String var) {
        return QName.extractName((String)this.type.getImplementationClassName()).equals(this.getName()) ? var : this.cast(this.type.getImplementationClassName(), var);
    }

    @NotNull
    private ImmutableList<String> getCompositeArguments() {
        return this.type.getChildren().filter(typeField -> typeField.getType() instanceof StructType && !((StructType)typeField.getType()).getArgs().isEmpty()).map(TypeField::getName).filter(fieldName -> !this.type.getArgs().exists(arg -> arg.equals(fieldName))).toList();
    }

    private String getDefaultFieldValue(TypeField field, boolean required) {
        Type fieldType = field.getType();
        if (fieldType.getKind() == Kind.ARRAY && required) {
            this.extractImport(ArrayList.class);
            return "new ArrayList<>()";
        }
        if (fieldType.isComposite() && required) {
            if (fieldType instanceof StructType && !((StructType)fieldType).getArgs().isEmpty()) {
                return "";
            }
            return this.new_(fieldType.getImplementationClassName(), new String[0]);
        }
        return Generators.defaultFor(this, field, required);
    }

    private String getImplementationClassName(TypeField field) {
        if (field.getType().getKind() == Kind.ARRAY) {
            return this.generic(List.class, new String[]{((ArrayType)field.getType()).getElementType().getImplementationClassName()});
        }
        return field.getImplementationClassName();
    }

    @NotNull
    private List<JavaElement.Field> getSuperTypeArguments() {
        ArrayList<JavaElement.Field> superArgs = new ArrayList<JavaElement.Field>();
        this.type.getSuperTypes().forEach(parent -> parent.getArgs().forEach(arg -> parent.getField(arg).ifPresent(t -> {
            JavaElement.Field field = new JavaElement.Field(t.getName(), this.getImplementationClassName((TypeField)t), "");
            field.required(t.isRequired());
            superArgs.add(field);
        })));
        return superArgs;
    }

    @NotNull
    static String typeConstructorComment(@NotNull StructType type) {
        return "Constructor for " + type.getName();
    }
}

