/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.codegen.type;

import java.util.ArrayList;
import java.util.List;
import mulesoft.codegen.entity.UserClassGenerator;
import mulesoft.codegen.impl.java.JavaCodeGenerator;
import mulesoft.codegen.impl.java.JavaElement;
import mulesoft.codegen.type.StructTypeCodeGenerator;
import mulesoft.common.collections.ImmutableSet;
import mulesoft.common.core.Strings;
import mulesoft.common.core.Tuple;
import mulesoft.field.TypeField;
import mulesoft.metadata.entity.StructType;
import mulesoft.type.ArrayType;
import mulesoft.type.Kind;
import mulesoft.type.ModelType;
import org.jetbrains.annotations.NotNull;

public class UserStructTypeClassGenerator
extends UserClassGenerator {
    private final StructType type;

    public UserStructTypeClassGenerator(JavaCodeGenerator cg, @NotNull StructType model, @NotNull String codeBasePackageName) {
        super(cg, (ModelType)model, codeBasePackageName, model.getName());
        this.type = model;
    }

    @Override
    protected void populate() {
        super.populate();
        this.generateConstructorMatchingSuper();
    }

    private JavaElement.Argument argument(JavaElement.Constructor c, TypeField f) {
        return (JavaElement.Argument)((JavaElement.Argument)c.arg(f.getName(), this.getImplementationClassName(f)).withAnnotation(this.extractImport("com.fasterxml.jackson.annotation.JsonProperty"), Strings.quoted((String)f.getName()))).required(f.isRequired());
    }

    private void generateConstructorMatchingSuper() {
        List<TypeField> superArgs = this.getSuperTypeArguments();
        List<TypeField> compositeArgs = this.getCompositeArguments();
        ImmutableSet args = this.type.getArgs();
        if (args.isEmpty() && superArgs.isEmpty() && compositeArgs.isEmpty()) {
            return;
        }
        JavaElement.Constructor c = (JavaElement.Constructor)((JavaElement.Constructor)this.constructor().withAnnotation(this.extractImport("com.fasterxml.jackson.annotation.JsonCreator"))).withComments(new String[]{StructTypeCodeGenerator.typeConstructorComment(this.type)});
        ArrayList allArgs = new ArrayList();
        superArgs.forEach(field -> {
            allArgs.add(field.getName());
            this.argument(c, (TypeField)field);
        });
        compositeArgs.forEach(field -> {
            allArgs.add(field.getName());
            this.argument(c, (TypeField)field);
        });
        allArgs.addAll(args);
        allArgs.forEach(a -> this.type.getField(a).map(f -> this.argument(c, (TypeField)f)));
        c.invokeSuper(allArgs);
    }

    @NotNull
    private List<TypeField> getCompositeArguments() {
        ArrayList<TypeField> arguments = new ArrayList<TypeField>();
        this.type.getChildren().filter(a -> a.getType() instanceof StructType && !this.type.getArgs().exists(args -> args.equals(a.getName())) && a.getType().isType()).map(typeField -> Tuple.tuple((Object)typeField, (Object)((StructType)typeField.getType()))).filter(arg -> ((TypeField)arg.first()).isRequired() && !((StructType)arg.second()).getArgs().isEmpty()).forEach(t -> ((StructType)t.second()).getArgs().map(a -> (TypeField)((StructType)t.second()).getField(a).get()).forEach(arguments::add));
        return arguments;
    }

    private String getImplementationClassName(TypeField field) {
        if (field.getType().getKind() == Kind.ARRAY) {
            return this.generic(List.class, new String[]{((ArrayType)field.getType()).getElementType().getImplementationClassName()});
        }
        return field.getImplementationClassName();
    }

    @NotNull
    private List<TypeField> getSuperTypeArguments() {
        ArrayList<TypeField> superArgs = new ArrayList<TypeField>();
        this.type.getSuperTypes().forEach(parent -> parent.getArgs().forEach(arg -> parent.getField(arg).ifPresent(superArgs::add)));
        return superArgs;
    }
}

