/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.metadata.common;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import mulesoft.type.EnumType;
import mulesoft.type.EnumValue;
import mulesoft.type.MetaModel;
import org.jetbrains.annotations.NotNull;

public class Localizer {
    private Localizer() {
    }

    @NotNull
    public static Map<String, String> stringsToLocalize(@NotNull MetaModel model) {
        switch (model.getMetaModelKind()) {
            case ENUM: {
                return Localizer.stringsForEnum((EnumType)model);
            }
        }
        return Collections.emptyMap();
    }

    private static Map<String, String> stringsForEnum(EnumType enumType) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (EnumValue enumValue : enumType.getValues()) {
            result.put(enumValue.getName(), enumValue.getLabel());
        }
        return result;
    }
}

