/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.metadata.common;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import mulesoft.common.Predefined;
import mulesoft.metadata.exception.BuilderError;
import mulesoft.metadata.exception.BuilderException;
import mulesoft.type.MetaModel;
import mulesoft.type.Modifier;
import org.jetbrains.annotations.NotNull;

public interface ModelBuilder<T extends MetaModel, This extends ModelBuilder<T, This>> {
    public T build() throws BuilderException;

    @NotNull
    public List<BuilderError> check();

    public This withDocumentation(@NotNull String var1);

    public This withModifier(Modifier var1);

    public This withModifiers(EnumSet<Modifier> var1);

    default public This withModifiers(Modifier ... ms) {
        return this.withModifiers(EnumSet.copyOf(Arrays.asList(ms)));
    }

    @NotNull
    public String getFullName();

    @NotNull
    public String getId();

    public static abstract class Default<T extends MetaModel, This extends ModelBuilder<T, This>>
    implements ModelBuilder<T, This> {
        @NotNull
        protected String documentation;
        @NotNull
        protected final String domain;
        @NotNull
        protected final String id;
        @NotNull
        protected String label;
        @NotNull
        protected EnumSet<Modifier> modifiers;
        @NotNull
        protected final String sourceName;

        protected Default(@NotNull String src, @NotNull String pkg, @NotNull String name) {
            this.id = name;
            this.label = "";
            this.documentation = "";
            this.domain = pkg;
            this.sourceName = src;
            this.modifiers = Modifier.emptySet();
        }

        public boolean hasModifier(Modifier mod) {
            return this.modifiers.contains(mod);
        }

        public final This label(@NotNull String str) {
            this.label = str;
            return (This)((ModelBuilder)Predefined.cast((Object)this));
        }

        @Override
        public This withDocumentation(@NotNull String doc) {
            this.documentation = doc;
            return (This)((ModelBuilder)Predefined.cast((Object)this));
        }

        @Override
        public This withModifier(Modifier mod) {
            this.modifiers.add(mod);
            return (This)((ModelBuilder)Predefined.cast((Object)this));
        }

        @Override
        public This withModifiers(EnumSet<Modifier> mod) {
            this.modifiers.addAll(mod);
            return (This)((ModelBuilder)Predefined.cast((Object)this));
        }

        @NotNull
        public final String getDomain() {
            return this.domain;
        }

        @Override
        @NotNull
        public final String getFullName() {
            return this.domain + "." + this.id;
        }

        @Override
        @NotNull
        public final String getId() {
            return this.id;
        }
    }
}

