/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.metadata.common;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import mulesoft.code.Binder;
import mulesoft.code.Evaluator;
import mulesoft.code.SymbolNotFoundException;
import mulesoft.common.Predefined;
import mulesoft.common.collections.Colls;
import mulesoft.common.core.Mutable;
import mulesoft.common.core.Option;
import mulesoft.common.core.QName;
import mulesoft.expr.Expression;
import mulesoft.expr.RefTypeSolver;
import mulesoft.expr.SimpleReferenceSolver;
import mulesoft.field.FieldOption;
import mulesoft.field.FieldOptionType;
import mulesoft.field.FieldOptions;
import mulesoft.field.MetaModelReference;
import mulesoft.field.ModelField;
import mulesoft.metadata.entity.Attribute;
import mulesoft.metadata.entity.DbObject;
import mulesoft.metadata.entity.Entity;
import mulesoft.metadata.entity.ModelTypeRefSolver;
import mulesoft.metadata.entity.SimpleType;
import mulesoft.metadata.entity.StructType;
import mulesoft.metadata.entity.View;
import mulesoft.metadata.entity.ViewAttribute;
import mulesoft.metadata.exception.IllegalDatabaseSearchableFieldType;
import mulesoft.metadata.exception.InvalidTypeForStructFieldException;
import mulesoft.metadata.exception.RemoteViewOfNonRemotableException;
import mulesoft.repository.ModelRepository;
import mulesoft.type.ArrayType;
import mulesoft.type.EnumType;
import mulesoft.type.EnumValue;
import mulesoft.type.FieldReference;
import mulesoft.type.MetaModel;
import mulesoft.type.ModelLinker;
import mulesoft.type.ModelType;
import mulesoft.type.Modifier;
import mulesoft.type.Type;
import mulesoft.type.Typed;
import mulesoft.type.Types;
import mulesoft.type.UnresolvedTypeReference;
import mulesoft.type.exception.UnresolvedRemoteViewException;
import mulesoft.type.exception.UnresolvedTypeReferenceException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModelLinkerImpl
implements ModelLinker {
    private boolean lastStage;
    private final ModelRepository repository;
    private static final SolverAndBinder EMPTY = new SolverAndBinder.Empty();

    public ModelLinkerImpl(ModelRepository repository) {
        this.repository = repository;
        this.lastStage = false;
    }

    public boolean link(MetaModel model) {
        if (model instanceof ModelType) {
            return this.linkComposite((ModelType)model);
        }
        return true;
    }

    public ModelLinker setLastStage(boolean b) {
        this.lastStage = b;
        return this;
    }

    protected void unresolved(String fqn) {
        throw new UnresolvedTypeReferenceException(fqn);
    }

    private boolean compileAndBind(Type fieldType, Expression expression) {
        SolverAndBinder solver = this.resolveSolverAndBinderForEnums(fieldType);
        try {
            expression.compile((RefTypeSolver)solver).bind((Binder)solver);
        }
        catch (SymbolNotFoundException ignored) {
            return false;
        }
        return expression.isConstant() || fieldType.isEnum();
    }

    private void fillViewAttribute(ViewAttribute viewAttribute, @NotNull Attribute attribute) {
        viewAttribute.getOptions().put(FieldOption.OPTIONAL, (Object)attribute.getOptions().getExpression(FieldOption.OPTIONAL));
        if (attribute.isSigned()) {
            viewAttribute.getOptions().put(FieldOption.SIGNED, (Object)true);
        }
        if (attribute.isMultiple()) {
            viewAttribute.multiple();
        }
        if (viewAttribute.getType() instanceof View && Predefined.isNotEmpty((String)attribute.getReverseReference()) && ((View)viewAttribute.getType()).getAttributeByBaseAttributeName(attribute.getReverseReference()).isPresent()) {
            viewAttribute.setReverseReference(((Attribute)((View)viewAttribute.getType()).getAttributeByBaseAttributeName(attribute.getReverseReference()).get()).getName());
        }
        if (attribute.isInner()) {
            viewAttribute.inner();
        }
    }

    @NotNull
    private ModelField findSuperAttribute(@Nullable DbObject dbObject, @NotNull FieldReference ref) {
        if (dbObject == null) {
            return ref;
        }
        Attribute attribute = (Attribute)dbObject.getAttribute(ref.getName()).getOrNull();
        return attribute == null ? ref : attribute;
    }

    private boolean linkComposite(ModelType model) {
        ModelTypeRefSolver solver = new ModelTypeRefSolver(model);
        Mutable.Boolean result = new Mutable.Boolean(true);
        if (model instanceof Entity) {
            result.setValue(this.solveEntityReferences((Entity)model));
        }
        if (model instanceof View) {
            return this.linkView((View)model);
        }
        if (model instanceof DbObject) {
            ((DbObject)model).compileSearchByOptions((RefTypeSolver)solver);
        }
        for (ModelField field2 : model.getChildren()) {
            if (!this.solveReference((MetaModel)model, (Typed)field2)) {
                result.setValue(false);
                continue;
            }
            field2.getOptions().compile((RefTypeSolver)solver, true);
        }
        if (model instanceof StructType && !model.hasModifier(Modifier.LOCAL)) {
            model.getChildren().filter(f -> !this.lastStage && f.getType().isEntity()).forEach(field -> {
                throw InvalidTypeForStructFieldException.invalidTypeForStructFieldException(field.getName(), field.getType(), model.getName());
            });
        }
        if (model instanceof EnumType) {
            this.resolveValues((EnumType)model);
        }
        if (model instanceof DbObject) {
            ((DbObject)model).validateSearchableDatabaseTypes(searchField -> {
                if (!searchField.isValidTypeForDb()) {
                    if (this.lastStage) {
                        throw IllegalDatabaseSearchableFieldType.illegalEntity(searchField.getFieldName(), searchField.getKind().getText(), model.getName());
                    }
                    result.setValue(false);
                }
            });
        }
        return result.value();
    }

    private boolean linkModel(MetaModel model) {
        boolean result = true;
        for (ModelField field : model.getChildren()) {
            if (this.solveReference(model, (Typed)field)) continue;
            result = false;
        }
        return result;
    }

    private boolean linkView(View view) {
        boolean result;
        ModelTypeRefSolver solver = new ModelTypeRefSolver((ModelType)view);
        boolean bl = result = this.solveViewReferences(view) && this.lastStage;
        if (result) {
            for (ModelField field : view.getChildren()) {
                result = this.solveViewReference((MetaModel)view, field);
                if (!result) continue;
                field.getOptions().compile((RefTypeSolver)solver);
            }
        }
        return result;
    }

    @NotNull
    private Function<ModelField, ModelField> objectFieldReferencesSolver(@NotNull DbObject dbObject, List<ModelField> unresolved) {
        return value -> {
            if (value instanceof FieldReference) {
                FieldReference ref = (FieldReference)value;
                ModelField attribute = this.findSuperAttribute(dbObject, ref);
                if (ref == attribute && dbObject instanceof View) {
                    attribute = this.findSuperAttribute((DbObject)((View)dbObject).getBaseEntity().getOrNull(), ref);
                }
                if (this.lastStage || attribute != value) {
                    ref.solve(attribute);
                }
                if (!(attribute instanceof Attribute)) {
                    unresolved.add(attribute);
                }
                return attribute;
            }
            return value;
        };
    }

    private boolean replaceViewEntityReferences(View view, ViewAttribute viewAttribute, FieldReference reference, @Nullable Attribute attribute) {
        if (attribute == null) {
            return false;
        }
        Type finalType = attribute.getFinalType();
        if ((finalType instanceof UnresolvedTypeReference || finalType.isEntity()) && view.isRemote()) {
            Type type = this.solveType(attribute);
            Option baseEntity = view.getBaseEntity();
            View viewType = type.getImplementationClassName().equals(((DbObject)baseEntity.get()).getImplementationClassName()) ? view : (View)this.repository.getModels().filter(View.class).getFirst(v -> v != null && v.isRemote() && v.getBaseEntityModelType() != null && v.getBaseEntityModelType().getFullName().equals(type.getImplementationClassName())).getOrNull();
            if (viewType != null) {
                viewAttribute.setType((Type)viewType);
                this.fillViewAttribute(viewAttribute, attribute);
                return true;
            }
            Type model = (Type)this.repository.getModel(QName.createQName((String)type.getImplementationClassName())).castTo(Type.class).getOrNull();
            if (model == null || model.isDatabaseObject()) {
                throw new UnresolvedRemoteViewException(type.getImplementationClassName(), reference.getName());
            }
            viewAttribute.setType(model.getFinalType());
        }
        this.fillViewAttribute(viewAttribute, attribute);
        return false;
    }

    private SolverAndBinder resolveSolverAndBinderForEnums(Type type) {
        if (type.isEnum()) {
            EnumType enumType = (EnumType)this.repository.getModel(type.getImplementationClassName(), EnumType.class).get();
            return new EnumSolverAndBinder(enumType);
        }
        return EMPTY;
    }

    private void resolveValues(EnumType type) {
        Evaluator ev = new Evaluator();
        for (EnumValue enumValue : type.getValues()) {
            Object[] values = enumValue.getValues();
            for (int i = 0; i < values.length; ++i) {
                Object value = values[i];
                if (!(value instanceof Expression)) continue;
                values[i] = ((Expression)value).compile((RefTypeSolver)EMPTY).evaluate(ev, null);
            }
        }
    }

    private boolean solveEntityReference(Attribute attr, Type type, UnresolvedTypeReference reference) {
        if (type instanceof Entity && !attr.hasOption(FieldOption.ABSTRACT)) {
            int ret;
            Entity entity = (Entity)type;
            if (attr.isInner()) {
                entity.setParent(Option.some((Object)((Entity)attr.getDbObject())));
            }
            if ((ret = this.solveReverseReference(entity, attr)) != 0) {
                if (this.lastStage) {
                    reference.reverseError(attr.getFullName(), ret);
                }
                return false;
            }
        }
        return true;
    }

    private boolean solveEntityReferences(@NotNull Entity entity) {
        ArrayList<ModelField> unresolved = new ArrayList<ModelField>();
        entity.solveReferences(this.objectFieldReferencesSolver((DbObject)entity, unresolved));
        return unresolved.isEmpty();
    }

    private boolean solveMetaModelReference(MetaModelReference reference) {
        return (Boolean)this.repository.getModel(QName.createQName((String)reference.getFullName())).map(m -> reference.solve(m) != null).orElseGet(() -> {
            if (this.lastStage) {
                reference.error();
            }
            return false;
        });
    }

    private boolean solveOptionsReferences(FieldOptions options) {
        return Colls.filter((Iterable)options, o -> o.getType() == FieldOptionType.METAMODEL_REFERENCE_T).map(arg_0 -> ((FieldOptions)options).getMetaModelReference(arg_0)).forAll(this::solveMetaModelReference);
    }

    private boolean solveReference(MetaModel model, Typed typed) {
        if (!(typed instanceof ViewAttribute) || !(model instanceof View)) {
            Type t = typed.getType();
            return !(t instanceof UnresolvedTypeReference) || this.solveReference(model, typed, (UnresolvedTypeReference)t);
        }
        return true;
    }

    private boolean solveReference(MetaModel model, Typed typed, UnresolvedTypeReference reference) {
        ModelType modelType = (ModelType)this.repository.getModel(reference.getKey(), ModelType.class).orElse((Object)reference);
        if (this.lastStage || modelType != reference) {
            reference.solve((Type)modelType);
        }
        if (modelType instanceof UnresolvedTypeReference) {
            return false;
        }
        if (modelType instanceof SimpleType && !this.linkModel((MetaModel)modelType)) {
            return false;
        }
        if (typed instanceof Attribute && !this.solveEntityReference((Attribute)typed, modelType.getFinalType(), reference)) {
            return false;
        }
        modelType.addUsage(model);
        typed.setType(reference.get());
        return true;
    }

    private int solveReverseReference(Entity entity, Attribute attribute) {
        if (!attribute.getReverseReference().isEmpty() || entity.equals((Object)attribute.getDbObject()) && !attribute.isMultiple()) {
            return 0;
        }
        String reverse = "";
        for (Attribute a : entity.attributes()) {
            if (a == attribute || !a.getFinalType().equals(attribute.getDbObject()) || !a.isMultiple() && !attribute.isMultiple() || a.hasOption(FieldOption.ABSTRACT)) continue;
            if (!reverse.isEmpty()) {
                return 1;
            }
            reverse = a.getName();
            if (!attribute.isInner()) continue;
            break;
        }
        if (reverse.isEmpty() && attribute.isMultiple()) {
            return 2;
        }
        attribute.setReverseReference(reverse);
        return 0;
    }

    private Type solveType(@NotNull Attribute attribute) {
        Type type = attribute.getType();
        if (attribute.getFinalType() instanceof UnresolvedTypeReference) {
            UnresolvedTypeReference unresolvedType = (UnresolvedTypeReference)attribute.getFinalType();
            try {
                type = unresolvedType.get().getFinalType();
            }
            catch (IllegalStateException | UnresolvedTypeReferenceException throwable) {
                // empty catch block
            }
        }
        return type;
    }

    private boolean solveViewAttributeReference(View view, ViewAttribute viewAttribute) {
        Attribute attribute;
        if (viewAttribute.getBaseAttributeModelField() instanceof FieldReference && view.getBaseEntityModelType() instanceof DbObject) {
            FieldReference reference = (FieldReference)viewAttribute.getBaseAttributeModelField();
            if (this.replaceViewEntityReferences(view, viewAttribute, reference, attribute = (Attribute)((DbObject)view.getBaseEntity().get()).getAttribute(reference.getName()).getOrNull())) {
                return true;
            }
            if (this.lastStage || attribute != null) {
                if (attribute != null) {
                    reference.solve((ModelField)attribute);
                } else {
                    reference.solve((ModelField)reference);
                }
            }
            if (attribute == null) {
                return false;
            }
        } else {
            return false;
        }
        viewAttribute.setBaseAttribute(attribute);
        return true;
    }

    private boolean solveViewReference(MetaModel type, ModelField field) {
        if (field instanceof ViewAttribute && type instanceof View) {
            return this.solveViewAttributeReference((View)type, (ViewAttribute)field);
        }
        Type t = field.getType();
        return !(t instanceof UnresolvedTypeReference) || this.solveReference(type, (Typed)field, (UnresolvedTypeReference)t);
    }

    private boolean solveViewReferences(@NotNull View view) {
        ArrayList unresolved = new ArrayList();
        view.solveMetaModels(value -> {
            if (value instanceof UnresolvedTypeReference) {
                DbObject dbObject;
                UnresolvedTypeReference ref = (UnresolvedTypeReference)value;
                ModelType modelType = (ModelType)this.repository.getModel(ref.getKey(), ModelType.class).orElse((Object)ref);
                if (this.lastStage || modelType != value) {
                    ref.solve((Type)modelType);
                }
                if (!(modelType instanceof DbObject)) {
                    unresolved.add(modelType);
                } else if (view.isRemote() && !(dbObject = (DbObject)modelType).isRemotable() && !dbObject.isSearchable()) {
                    throw new RuntimeException(new RemoteViewOfNonRemotableException(view.getName(), dbObject.getFullName()).getMessage());
                }
                return modelType;
            }
            return value;
        });
        ArrayList<ModelField> unresolvedFields = new ArrayList<ModelField>();
        view.solveSearchByFields(this.objectFieldReferencesSolver((DbObject)view, unresolvedFields));
        view.solveDescribes(this.objectFieldReferencesSolver((DbObject)view, unresolvedFields));
        return unresolved.isEmpty() && unresolvedFields.isEmpty();
    }

    private static class MultipleTyped
    implements Typed {
        private final boolean multiple;
        private final Typed typed;

        private MultipleTyped(Typed typed) {
            this.typed = typed;
            this.multiple = typed.getType().isArray();
        }

        @NotNull
        public Type getType() {
            Type type = this.typed.getType();
            return this.multiple ? ((ArrayType)type).getElementType() : type;
        }

        public void setType(@NotNull Type type) {
            this.typed.setType((Type)(this.multiple ? Types.arrayType((Type)type) : type));
        }
    }

    private static class EnumSolverAndBinder
    extends SimpleReferenceSolver
    implements SolverAndBinder {
        private EnumSolverAndBinder(EnumType enumType) {
            for (EnumValue value : enumType.getValues()) {
                this.put(value.getName(), value.getName(), (Type)Types.stringType());
            }
        }
    }

    private static interface SolverAndBinder
    extends Binder,
    RefTypeSolver {

        public static class Empty
        extends Binder.Default
        implements SolverAndBinder {
            @NotNull
            public Type doResolve(@NotNull String name, boolean isColumn) {
                throw new SymbolNotFoundException(name);
            }
        }
    }
}

