/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.metadata.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mulesoft.metadata.common.ModelBuilder;
import mulesoft.metadata.common.ModelLinkerImpl;
import mulesoft.metadata.exception.BuilderError;
import mulesoft.metadata.exception.BuilderException;
import mulesoft.metadata.exception.DuplicateDefinitionException;
import mulesoft.repository.ModelRepository;
import mulesoft.type.MetaModel;
import org.jetbrains.annotations.NotNull;

public class ModelSetBuilder {
    private final Map<String, ModelBuilder<?, ?>> modelBuilders = new HashMap();

    public void addModel(@NotNull ModelBuilder<?, ?> e) throws DuplicateDefinitionException {
        if (this.modelBuilders.containsKey(e.getId())) {
            throw new DuplicateDefinitionException(e.getFullName());
        }
        this.modelBuilders.put(e.getId(), e);
    }

    public void build(ModelRepository repository) throws BuilderException {
        ArrayList unsolved = new ArrayList();
        ModelLinkerImpl linker = new ModelLinkerImpl(repository);
        for (ModelBuilder<?, ?> builder : this.modelBuilders.values()) {
            Object model = builder.build();
            repository.add(model);
            if (!linker.link((MetaModel)model)) {
                unsolved.add(model);
            }
            for (BuilderError builderError : builder.check()) {
                if (!(builderError instanceof BuilderException)) continue;
                throw (BuilderException)builderError;
            }
        }
        linker.setLastStage(true);
        for (MetaModel model : unsolved) {
            linker.link(model);
        }
        this.modelBuilders.clear();
    }

    public static ModelRepository buildAll(ModelBuilder<?, ?> ... ds) throws BuilderException {
        ModelSetBuilder b = new ModelSetBuilder();
        for (ModelBuilder<?, ?> builder : ds) {
            b.addModel(builder);
        }
        ModelRepository r = new ModelRepository();
        b.build(r);
        return r;
    }
}

