/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.metadata.entity;

import java.util.Collections;
import mulesoft.field.FieldOption;
import mulesoft.field.TypeField;
import mulesoft.metadata.entity.Attribute;
import mulesoft.metadata.entity.CompositeFieldBuilder;
import mulesoft.metadata.entity.DbObject;
import mulesoft.metadata.exception.BuilderException;
import mulesoft.type.MetaModel;
import mulesoft.type.Type;
import org.jetbrains.annotations.NotNull;

public class AttributeBuilder
extends CompositeFieldBuilder<AttributeBuilder> {
    private String description = "";
    private boolean inner;
    private boolean multiple = false;
    @NotNull
    private String reverseReference = "";
    private String seqName = null;
    private boolean synthesized = false;

    public AttributeBuilder(@NotNull String name, Type type) {
        super(name, type);
    }

    @Override
    @NotNull
    public TypeField build(MetaModel entity) {
        return new Attribute((DbObject)entity, this.getName(), this.getType(), this.description, this.getOptions(), this.inner, this.multiple, this.reverseReference, this.synthesized, this.seqName);
    }

    public AttributeBuilder column(String columnName) {
        try {
            this.withOption(FieldOption.COLUMN, Collections.singletonList(columnName));
        }
        catch (BuilderException builderException) {
            // empty catch block
        }
        return this;
    }

    public AttributeBuilder description(@NotNull String str) {
        this.description = str;
        return this;
    }

    public AttributeBuilder inner() {
        this.inner = true;
        return this;
    }

    public AttributeBuilder multiple() {
        this.multiple = true;
        return this;
    }

    public AttributeBuilder serial() {
        return this.serial("");
    }

    @Override
    public AttributeBuilder serial(String sequenceName) {
        this.seqName = sequenceName;
        return this;
    }

    public AttributeBuilder synthesized() {
        this.synthesized = true;
        return this;
    }

    public AttributeBuilder withReverseReference(@NotNull String attributeName) {
        this.reverseReference = attributeName;
        return this;
    }

    boolean isSerial() {
        return this.seqName != null;
    }
}

