/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.metadata.entity;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import mulesoft.common.Predefined;
import mulesoft.common.collections.Colls;
import mulesoft.common.collections.ImmutableCollection;
import mulesoft.common.core.QName;
import mulesoft.field.TypeField;
import mulesoft.metadata.common.ModelBuilder;
import mulesoft.metadata.entity.CompositeFieldBuilder;
import mulesoft.metadata.exception.BuilderError;
import mulesoft.metadata.exception.DuplicateFieldException;
import mulesoft.metadata.exception.InvalidFieldNameException;
import mulesoft.metadata.exception.InvalidTypeException;
import mulesoft.type.MetaModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CompositeBuilder<T extends MetaModel, F extends TypeField, FB extends CompositeFieldBuilder<FB>, This extends CompositeBuilder<T, F, FB, This>>
extends ModelBuilder.Default<T, This> {
    @NotNull
    final List<BuilderError> builderErrors = new LinkedList<BuilderError>();
    @NotNull
    String defaultForm = "";
    @NotNull
    final Map<String, FB> fields = new LinkedHashMap<String, FB>();

    CompositeBuilder(String sourceName, @NotNull String pkg, @NotNull String name) {
        super(sourceName, pkg, name);
    }

    public void addField(FB a) throws DuplicateFieldException, InvalidFieldNameException, InvalidTypeException {
        this.checkDuplicates(a);
        this.fields.put(((CompositeFieldBuilder)a).getName(), a);
    }

    public final void addInternalField(FB a) {
        if (!this.fields.containsKey(((CompositeFieldBuilder)a).getName())) {
            this.fields.put(((CompositeFieldBuilder)a).getName(), a);
        }
    }

    public This defaultForm(String formId) {
        this.defaultForm = QName.qualify((String)this.getDomain(), (String)formId);
        return (This)((CompositeBuilder)Predefined.cast((Object)this));
    }

    @SafeVarargs
    public final This fields(FB ... fieldBuilders) throws DuplicateFieldException, InvalidFieldNameException, InvalidTypeException {
        for (FB f : fieldBuilders) {
            this.addField(f);
        }
        return (This)((CompositeBuilder)Predefined.cast((Object)this));
    }

    @NotNull
    public ImmutableCollection<FB> getFields() {
        return Colls.immutable(this.fields.values());
    }

    void buildAttributes(Map<String, TypeField> map, MetaModel model) {
        for (CompositeFieldBuilder b : this.fields.values()) {
            TypeField a = b.build(model);
            map.put(a.getName(), a);
        }
    }

    void checkDuplicates(FB a) throws DuplicateFieldException {
        if (this.fields.containsKey(((CompositeFieldBuilder)a).getName())) {
            throw DuplicateFieldException.onEntity(((CompositeFieldBuilder)a).getName(), this.id);
        }
    }

    @Nullable
    final FB getAttribute(String name) {
        return (FB)((CompositeFieldBuilder)this.fields.get(name));
    }
}

