/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.metadata.entity;

import mulesoft.common.Predefined;
import mulesoft.expr.Expression;
import mulesoft.field.FieldOption;
import mulesoft.field.TypeField;
import mulesoft.metadata.entity.FieldBuilder;
import mulesoft.metadata.exception.BuilderException;
import mulesoft.metadata.exception.IncompatibleOptionsException;
import mulesoft.type.MetaModel;
import mulesoft.type.Type;
import org.jetbrains.annotations.NotNull;

public class CompositeFieldBuilder<This extends CompositeFieldBuilder<This>>
extends FieldBuilder<This> {
    @NotNull
    private final String name;
    @NotNull
    private final Type type;

    protected CompositeFieldBuilder(@NotNull String name, @NotNull Type type) {
        this.name = name;
        this.type = type;
    }

    public TypeField build(MetaModel model) {
        return new TypeField(this.getName(), this.getType(), this.getOptions());
    }

    public This defaultValue(Expression expr) throws BuilderException {
        return (This)((CompositeFieldBuilder)this.with(FieldOption.DEFAULT, expr));
    }

    @NotNull
    public This optional() throws BuilderException {
        return (This)((CompositeFieldBuilder)this.with(FieldOption.OPTIONAL, Expression.TRUE));
    }

    @NotNull
    public This readOnly() throws BuilderException {
        return (This)((CompositeFieldBuilder)this.with(FieldOption.READ_ONLY));
    }

    public This serial(String text) {
        return (This)((CompositeFieldBuilder)Predefined.cast((Object)this));
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public Type getType() {
        return this.type;
    }

    @Override
    protected void checkOptionSupport(FieldOption option) throws BuilderException {
        if (option == FieldOption.SIGNED && !this.type.getFinalType().isNumber()) {
            throw new IncompatibleOptionsException(FieldOption.SIGNED, this.type.getFinalType(), this.name);
        }
        if (option == FieldOption.CUSTOM_MASK && !this.type.getFinalType().isString()) {
            throw new IncompatibleOptionsException(FieldOption.CUSTOM_MASK, this.type.getFinalType(), this.name);
        }
    }
}

