/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.metadata.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mulesoft.common.Predefined;
import mulesoft.common.collections.Colls;
import mulesoft.common.collections.Seq;
import mulesoft.common.core.QName;
import mulesoft.field.FieldOption;
import mulesoft.field.ModelField;
import mulesoft.field.TypeField;
import mulesoft.metadata.entity.Attribute;
import mulesoft.metadata.entity.CompositeBuilder;
import mulesoft.metadata.entity.CompositeFieldBuilder;
import mulesoft.metadata.entity.SearchField;
import mulesoft.metadata.entity.SearchFieldBuilder;
import mulesoft.metadata.exception.BuilderException;
import mulesoft.metadata.exception.DuplicateFieldException;
import mulesoft.metadata.exception.DuplicateIndexException;
import mulesoft.metadata.exception.FieldNotFoundException;
import mulesoft.metadata.exception.IllegalAbstractSearchableField;
import mulesoft.metadata.exception.IllegalSearchableField;
import mulesoft.metadata.exception.NoAttributesIndexException;
import mulesoft.type.FieldReference;
import mulesoft.type.MetaModel;
import mulesoft.type.Modifier;
import mulesoft.type.Names;
import org.jetbrains.annotations.NotNull;

public abstract class DbObjectBuilder<T extends MetaModel, F extends TypeField, FB extends CompositeFieldBuilder<FB>, This extends CompositeBuilder<T, F, FB, This>>
extends CompositeBuilder<T, F, FB, This> {
    @NotNull
    protected QName databaseName;
    @NotNull
    protected final Map<String, Collection<ModelField>> indexes;
    protected boolean primaryKeyDefault = false;
    @NotNull
    protected final List<ModelField> primaryKeyFields;
    @NotNull
    protected final Map<String, SearchFieldBuilder> searchByFields;
    @NotNull
    protected final Map<String, Collection<ModelField>> uniqueIndexes = new LinkedHashMap<String, Collection<ModelField>>();
    boolean dbNameGenerated = true;
    private final String defaultSchemaId;

    DbObjectBuilder(String sourceName, @NotNull String pkg, @NotNull String name, @NotNull String defaultSchemaId) {
        super(sourceName, pkg, name);
        this.indexes = new LinkedHashMap<String, Collection<ModelField>>();
        this.primaryKeyFields = new ArrayList<ModelField>();
        this.databaseName = QName.EMPTY;
        this.defaultSchemaId = Names.validateSchemaId((String)defaultSchemaId, (String)pkg);
        this.searchByFields = new LinkedHashMap<String, SearchFieldBuilder>();
    }

    public void addSearchableField(SearchFieldBuilder f) throws DuplicateFieldException {
        String fieldId = f.getId();
        if (this.searchByFields.containsKey(fieldId)) {
            throw DuplicateFieldException.onSearchable(fieldId);
        }
        this.searchByFields.put(fieldId, f);
    }

    public This databaseName(QName dbName) {
        this.databaseName = dbName;
        this.dbNameGenerated = false;
        return (This)((CompositeBuilder)Predefined.cast((Object)this));
    }

    public void defaultSearchable() {
        if (this.searchByFields.isEmpty()) {
            this.withModifier(Modifier.DEFAULT_SEARCHABLE);
        }
    }

    public This primaryKey(String ... fs) {
        return this.primaryKey(this.convertToModelFields(fs));
    }

    public This primaryKey(Collection<ModelField> fs) {
        if (!this.primaryKeyFields.isEmpty()) {
            throw new IllegalStateException("Primary Key already set");
        }
        this.primaryKeyDefault = false;
        this.primaryKeyFields.clear();
        this.primaryKeyFields.addAll(fs);
        return (This)((CompositeBuilder)Predefined.cast((Object)this));
    }

    public This remotable() {
        return (This)((CompositeBuilder)this.withModifier(Modifier.REMOTABLE));
    }

    public This searchable() {
        return (This)((CompositeBuilder)this.withModifier(Modifier.DEFAULT_SEARCHABLE));
    }

    public void searchByDatabase() {
        this.withModifier(Modifier.DATABASE_SEARCHABLE);
    }

    public This withIndex(String indexId, Collection<ModelField> fs) throws DuplicateIndexException, NoAttributesIndexException {
        if (fs.isEmpty()) {
            throw new NoAttributesIndexException(indexId, this.getId());
        }
        if (this.indexes.get(indexId) != null || this.uniqueIndexes.get(indexId) != null) {
            throw new DuplicateIndexException(indexId, this.getId());
        }
        this.indexes.put(indexId, fs);
        return (This)((CompositeBuilder)Predefined.cast((Object)this));
    }

    public This withIndex(String indexId, String ... fs) throws DuplicateIndexException, NoAttributesIndexException {
        return this.withIndex(indexId, this.convertToModelFields(fs));
    }

    public This withUnique(String indexId, String ... fs) throws DuplicateIndexException, NoAttributesIndexException {
        return this.withUnique(indexId, this.convertToModelFields(fs));
    }

    public This withUnique(String indexId, Collection<ModelField> fs) throws DuplicateIndexException, NoAttributesIndexException {
        if (fs.isEmpty()) {
            throw new NoAttributesIndexException(indexId, this.getId());
        }
        if (this.uniqueIndexes.get(indexId) != null || this.indexes.get(indexId) != null) {
            throw new DuplicateIndexException(indexId, this.getId());
        }
        this.uniqueIndexes.put(indexId, fs);
        return (This)((CompositeBuilder)Predefined.cast((Object)this));
    }

    public QName getDatabaseName() {
        return this.dbNameGenerated ? QName.createQName((String)this.defaultSchemaId, (String)Names.tableName((String)this.getId())) : (this.databaseName.getQualification().isEmpty() ? QName.createQName((String)this.defaultSchemaId, (String)this.databaseName.getName()) : this.databaseName);
    }

    protected void addFieldsByName(Map<String, Attribute> attributeMap, Iterable<ModelField> fs, Collection<? super Attribute> destination) {
        for (ModelField field : fs) {
            Attribute attribute = attributeMap.get(field.getName());
            if (attribute != null) {
                destination.add((Attribute)attribute);
                continue;
            }
            this.builderErrors.add(new FieldNotFoundException(this.getId(), field.getName()));
        }
    }

    protected void buildIndexes(Map<String, Collection<ModelField>> indexesMap, Map<String, Attribute> map, Map<String, Seq<Attribute>> finalMap) {
        for (String indexId : indexesMap.keySet()) {
            ArrayList fs = new ArrayList();
            this.addFieldsByName(map, (Iterable<ModelField>)indexesMap.get(indexId), fs);
            finalMap.put(indexId, (Seq<Attribute>)Colls.seq(fs));
        }
    }

    protected List<ModelField> convertToModelFields(String[] fs) {
        ArrayList<ModelField> result = new ArrayList<ModelField>();
        for (String s : fs) {
            result.add((ModelField)FieldReference.unresolvedFieldRef((String)s));
        }
        return result;
    }

    void addAllFields(Map<String, Attribute> attributeMap, Iterable<ModelField> fs, Collection<ModelField> destination) {
        for (ModelField field : fs) {
            Attribute attribute = attributeMap.get(field.getName());
            if (attribute != null) {
                destination.add((ModelField)attribute);
                continue;
            }
            destination.add(field);
        }
    }

    void buildSearchByFields(@NotNull Map<String, SearchFieldBuilder> searchByFieldMap, Map<String, Attribute> attributeMap, @NotNull List<SearchField> searchBy, boolean notFoundError) throws BuilderException {
        for (SearchFieldBuilder b : searchByFieldMap.values()) {
            String fieldName = b.getName();
            if (!attributeMap.containsKey(fieldName) && notFoundError) {
                throw FieldNotFoundException.searchableFieldNotFound(this.getId(), fieldName);
            }
            Attribute attr = attributeMap.get(fieldName);
            if (attr != null && attr.hasOption(FieldOption.ABSTRACT) && !attr.hasOption(FieldOption.READ_ONLY)) {
                throw new IllegalAbstractSearchableField(fieldName);
            }
            if (this.hasModifier(Modifier.DATABASE_SEARCHABLE) && attr != null && attr.hasOption(FieldOption.ABSTRACT)) {
                throw IllegalSearchableField.illegalAbstract(fieldName);
            }
            searchBy.add(b.build());
        }
    }
}

