/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.metadata.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mulesoft.cache.CacheType;
import mulesoft.common.Predefined;
import mulesoft.common.collections.Maps;
import mulesoft.common.collections.Seq;
import mulesoft.common.core.QName;
import mulesoft.common.core.Strings;
import mulesoft.common.core.Tuple;
import mulesoft.field.FieldOption;
import mulesoft.field.ModelField;
import mulesoft.field.TypeField;
import mulesoft.metadata.entity.Attribute;
import mulesoft.metadata.entity.AttributeBuilder;
import mulesoft.metadata.entity.DbObject;
import mulesoft.metadata.entity.DbObjectBuilder;
import mulesoft.metadata.entity.Entity;
import mulesoft.metadata.entity.SearchField;
import mulesoft.metadata.exception.BuilderError;
import mulesoft.metadata.exception.BuilderException;
import mulesoft.metadata.exception.DuplicateFieldException;
import mulesoft.metadata.exception.FieldNotFoundException;
import mulesoft.metadata.exception.InvalidFieldNameException;
import mulesoft.metadata.exception.InvalidTypeException;
import mulesoft.metadata.exception.NoAttributesException;
import mulesoft.metadata.exception.NullableInPrimaryKeyException;
import mulesoft.type.EnumType;
import mulesoft.type.FieldReference;
import mulesoft.type.MetaModel;
import mulesoft.type.Modifier;
import mulesoft.type.Type;
import mulesoft.type.Types;
import org.jetbrains.annotations.NotNull;

public class EntityBuilder
extends DbObjectBuilder<Entity, Attribute, AttributeBuilder, EntityBuilder> {
    private CacheType cacheType = CacheType.NONE;
    @NotNull
    private final List<ModelField> describeFields = new ArrayList<ModelField>();
    private List<ModelField> image;
    private final boolean inner;
    static Map<String, Internal> internalFields = Maps.linkedHashMap(EntityBuilder.internal("id", (Type)Types.intType(), false, true), (Tuple[])new Tuple[]{EntityBuilder.internal("updateTime", (Type)Types.dateTimeType((int)3), false), EntityBuilder.internal("instanceVersion", (Type)Types.longType(), false), EntityBuilder.internal("creationTime", (Type)Types.dateTimeType((int)3), false), EntityBuilder.internal("deprecationTime", (Type)Types.dateTimeType((int)3), true)});
    private static final List<String> auditFields = Collections.singletonList("creationTime");
    private static final List<String> deprecableFields = Collections.singletonList("deprecationTime");

    EntityBuilder(String sourceName, @NotNull String pkg, @NotNull String name, String parent, @NotNull String defaultSchemaId) {
        super(sourceName, pkg, name, defaultSchemaId);
        boolean bl = this.inner = !parent.isEmpty();
        if (this.inner) {
            this.addInnerAttributes(parent);
        }
        this.primaryKeyDefault = true;
        this.image = new ArrayList<ModelField>();
    }

    @Override
    public void addField(AttributeBuilder a) throws DuplicateFieldException, InvalidFieldNameException, InvalidTypeException {
        if (this.fields.isEmpty() && this.primaryKeyDefault) {
            assert (this.primaryKeyFields.isEmpty());
            this.primaryKeyFields.add(FieldReference.unresolvedFieldRef((String)(a.isSerial() ? a : this.addInternalField("id", false)).getName()));
        }
        this.checkValidName(a);
        if (a.getType().isArray() && !a.hasOption(FieldOption.ABSTRACT)) {
            throw new InvalidTypeException(this.getId(), a.getName(), a.getType());
        }
        super.addField(a);
    }

    public EntityBuilder auditable() {
        return (EntityBuilder)this.withModifier(Modifier.AUDITABLE);
    }

    @Override
    public Entity build() throws BuilderException {
        LinkedHashMap<String, TypeField> fieldMap = new LinkedHashMap<String, TypeField>();
        Map attributeMap = (Map)Predefined.cast(fieldMap);
        ArrayList<Attribute> pks = new ArrayList<Attribute>();
        ArrayList<ModelField> describes = new ArrayList<ModelField>();
        ArrayList<SearchField> searchBy = new ArrayList<SearchField>();
        LinkedHashMap<String, Seq<Attribute>> uniqueMap = new LinkedHashMap<String, Seq<Attribute>>();
        LinkedHashMap<String, Seq<Attribute>> indexMap = new LinkedHashMap<String, Seq<Attribute>>();
        boolean protectedEntity = this.modifiers.contains(Modifier.PROTECTED);
        Entity entity = new Entity(this.sourceName, this.domain, this.id, this.label, this.getDatabaseName(), this.dbNameGenerated, this.modifiers, this.primaryKeyDefault, this.defaultForm, attributeMap, pks, describes, uniqueMap, indexMap, searchBy, this.cacheType, protectedEntity, this.image, this.documentation);
        this.addInternalFields();
        this.buildAttributes(fieldMap, (MetaModel)entity);
        this.buildPrimaryKey(attributeMap, pks);
        this.buildDescribes(attributeMap, describes);
        this.buildIndexes(this.uniqueIndexes, attributeMap, uniqueMap);
        this.buildIndexes(this.indexes, attributeMap, indexMap);
        this.buildSearchByFields(this.searchByFields, attributeMap, searchBy, true);
        return entity;
    }

    public EntityBuilder cached() {
        this.cacheType = CacheType.DEFAULT;
        return this;
    }

    public EntityBuilder cached(int size) {
        this.cacheType = CacheType.DEFAULT.withSize(size);
        return this;
    }

    @Override
    @NotNull
    public List<BuilderError> check() {
        if (Predefined.isEmpty(this.fields.entrySet())) {
            this.builderErrors.add(new NoAttributesException(this.id));
        }
        if (!this.inner && this.describeFields.isEmpty()) {
            this.describeFields.addAll(this.primaryKeyFields);
        }
        this.checkIndex(this.primaryKeyFields, true);
        for (Collection f : this.uniqueIndexes.values()) {
            this.checkIndex(f, false);
        }
        for (Collection f : this.indexes.values()) {
            this.checkIndex(f, false);
        }
        return this.builderErrors;
    }

    public EntityBuilder deprecable() {
        return (EntityBuilder)this.withModifier(Modifier.DEPRECABLE);
    }

    public EntityBuilder describedBy(Collection<ModelField> mf) {
        this.describeFields.clear();
        this.describeFields.addAll(mf);
        return this;
    }

    public EntityBuilder describedBy(String ... fs) {
        return this.describedBy(this.convertToModelFields(fs));
    }

    public EntityBuilder fullyCached() {
        this.cacheType = CacheType.FULL;
        return this;
    }

    public EntityBuilder image(ModelField img) {
        this.image = new ArrayList<ModelField>();
        this.image.add(img);
        return this;
    }

    public EntityBuilder optimistic() {
        return (EntityBuilder)this.withModifier(Modifier.OPTIMISTIC_LOCKING);
    }

    @Override
    public EntityBuilder primaryKey(String ... fs) {
        return (EntityBuilder)Predefined.cast(super.primaryKey(this.convertToModelFields(fs)));
    }

    public EntityBuilder primaryKeyFromColumnNames(Seq<String> columnNames) {
        ArrayList<ModelField> fs = new ArrayList<ModelField>();
        for (String s : columnNames) {
            fs.add((ModelField)FieldReference.unresolvedFieldRef((String)this.idFromDbName(s)));
        }
        return (EntityBuilder)this.primaryKey(fs);
    }

    boolean allowOptionalInPrimaryKey() {
        return false;
    }

    void checkValidName(AttributeBuilder a) throws InvalidFieldNameException {
        Internal it = internalFields.get(a.getName());
        if (it == null) {
            return;
        }
        Type type = a.getType().getFinalType();
        if (it.identity ? type != Types.intType() || a.isSerial() : type.equals(it.type) && (it.optional || !a.isOptional())) {
            return;
        }
        throw new InvalidFieldNameException(a.getName(), this.getId());
    }

    private void addInnerAttributes(String parent) {
        String parentFieldName = Strings.deCapitalizeFirst((String)parent);
        try {
            this.addField(EntityBuilder.createAttribute(parentFieldName, (Type)Types.referenceType((String)this.domain, (String)parent)));
            this.addField(EntityBuilder.createAttribute("seqId", (Type)Types.intType()));
            this.primaryKey(parentFieldName, "seqId");
        }
        catch (BuilderException e) {
            throw new IllegalStateException(e);
        }
    }

    private AttributeBuilder addInternalField(String name, boolean readOnly) {
        Internal t = internalFields.get(name);
        AttributeBuilder a = EntityBuilder.createAttribute(name, t.type).synthesized();
        try {
            if (t.optional) {
                a.optional();
            }
            if (readOnly) {
                a.readOnly();
            }
        }
        catch (BuilderException e) {
            throw new IllegalStateException(e);
        }
        if (t.identity) {
            a.serial();
        }
        this.addInternalField(a);
        return a;
    }

    private void addInternalFields() {
        this.addInternalField("updateTime", true);
        if (this.hasModifier(Modifier.OPTIMISTIC_LOCKING)) {
            this.addInternalField("instanceVersion", true);
        }
        if (this.hasModifier(Modifier.DEPRECABLE)) {
            this.addInternalField("deprecationTime", true);
        }
        if (this.hasModifier(Modifier.AUDITABLE)) {
            this.addInternalField("creationTime", true);
        }
    }

    private void buildDescribes(Map<String, Attribute> map, Collection<ModelField> describes) {
        if (this.describeFields.isEmpty()) {
            this.addAllFields(map, this.primaryKeyFields, describes);
        } else {
            this.addAllFields(map, this.describeFields, describes);
        }
    }

    private void buildPrimaryKey(Map<String, Attribute> map, Collection<Attribute> pks) {
        this.addFieldsByName(map, this.primaryKeyFields, pks);
    }

    private void checkIndex(Collection<ModelField> fs, boolean pk) {
        for (ModelField field : fs) {
            String fieldName = field.getName();
            AttributeBuilder attribute = (AttributeBuilder)this.fields.get(fieldName);
            if (attribute == null) {
                if (fieldName.equals("updateTime") || this.hasModifier(Modifier.AUDITABLE) && auditFields.contains(fieldName) || this.hasModifier(Modifier.DEPRECABLE) && deprecableFields.contains(fieldName)) continue;
                this.builderErrors.add(new FieldNotFoundException(this.getId(), fieldName));
                continue;
            }
            if (!pk || !attribute.isOptional() || this.allowOptionalInPrimaryKey()) continue;
            this.builderErrors.add(new NullableInPrimaryKeyException(this.getFullName(), attribute.getName()));
        }
    }

    @NotNull
    private String idFromDbName(String dbName) {
        return Strings.deCapitalizeFirst((String)Strings.toCamelCase((String)dbName));
    }

    public static AttributeBuilder bool(String nm) {
        return new AttributeBuilder(nm, (Type)Types.booleanType());
    }

    public static AttributeBuilder createAttribute(String nm, Type type) {
        return new AttributeBuilder(nm, type);
    }

    public static AttributeBuilder date(String nm) {
        return new AttributeBuilder(nm, (Type)Types.dateType());
    }

    public static AttributeBuilder dateTime(String nm) {
        return new AttributeBuilder(nm, (Type)Types.dateTimeType());
    }

    public static AttributeBuilder dateTime(String nm, int precision) {
        return new AttributeBuilder(nm, (Type)Types.dateTimeType((int)precision));
    }

    public static AttributeBuilder decimal(String nm, int precision) {
        return new AttributeBuilder(nm, (Type)Types.decimalType((int)precision));
    }

    public static AttributeBuilder decimal(String nm, int precision, int decimals) {
        return new AttributeBuilder(nm, (Type)Types.decimalType((int)precision, (int)decimals));
    }

    public static EntityBuilder entity(String packageId, String entityName) {
        return new EntityBuilder("", packageId, entityName, "", "");
    }

    public static EntityBuilder entity(String packageId, String entityName, String schemaId) {
        return new EntityBuilder("", packageId, entityName, "", schemaId);
    }

    public static EntityBuilder entity(String sourceName, String packageId, String entityName, String parent, String schemaId) {
        return new EntityBuilder(sourceName, packageId, entityName, parent, schemaId);
    }

    @NotNull
    public static EntityBuilder entityFromDatabase(String packageName, String schemaName, String tableName) {
        String entityName = Strings.toCamelCase((String)tableName);
        EntityBuilder b = EntityBuilder.entity(packageName, entityName, schemaName);
        if (!Strings.fromCamelCase((String)entityName).equals(tableName)) {
            b.databaseName(QName.createQName((String)schemaName, (String)tableName));
        }
        return b;
    }

    public static AttributeBuilder integer(String nm) {
        return new AttributeBuilder(nm, (Type)Types.intType());
    }

    public static AttributeBuilder integer(String nm, int length) {
        return new AttributeBuilder(nm, (Type)Types.intType((int)length));
    }

    public static AttributeBuilder real(String nm) {
        return new AttributeBuilder(nm, (Type)Types.realType());
    }

    public static AttributeBuilder reference(String nm, EnumType ref) {
        return new AttributeBuilder(nm, (Type)ref);
    }

    public static AttributeBuilder reference(String nm, String fqn) {
        return new AttributeBuilder(nm, (Type)Types.referenceType((String)fqn));
    }

    public static AttributeBuilder reference(String nm, DbObject ref) {
        return new AttributeBuilder(nm, (Type)ref);
    }

    public static AttributeBuilder reference(String nm, String domain, String target) {
        return new AttributeBuilder(nm, (Type)Types.referenceType((String)domain, (String)target));
    }

    public static AttributeBuilder string(String nm) {
        return new AttributeBuilder(nm, (Type)Types.stringType());
    }

    public static AttributeBuilder string(String nm, int length) {
        return new AttributeBuilder(nm, (Type)Types.stringType((int)length));
    }

    @NotNull
    private static Tuple<String, Internal> internal(String name, Type type, boolean optional) {
        return Tuple.tuple((Object)name, (Object)new Internal(type, optional, false));
    }

    @NotNull
    private static Tuple<String, Internal> internal(String name, Type type, boolean optional, boolean identity) {
        return Tuple.tuple((Object)name, (Object)new Internal(type, optional, identity));
    }

    static class Internal {
        final boolean identity;
        final boolean optional;
        final Type type;

        Internal(Type type, boolean optional, boolean identity) {
            this.type = type;
            this.optional = optional;
            this.identity = identity;
        }
    }
}

