/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.metadata.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import mulesoft.common.core.Enumeration;
import mulesoft.common.core.QName;
import mulesoft.field.TypeField;
import mulesoft.metadata.entity.CompositeBuilder;
import mulesoft.metadata.entity.TypeFieldBuilder;
import mulesoft.metadata.exception.BuilderError;
import mulesoft.metadata.exception.FieldNotFoundException;
import mulesoft.metadata.exception.InvalidDefaultValueException;
import mulesoft.metadata.exception.InvalidTypeException;
import mulesoft.type.EnumType;
import mulesoft.type.MetaModel;
import mulesoft.type.Names;
import mulesoft.type.Type;
import mulesoft.type.Types;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnumBuilder
extends CompositeBuilder<EnumType, TypeField, TypeFieldBuilder, EnumBuilder> {
    private String default_ = "";
    private final List<String> documentations;
    private final List<String> ids = new ArrayList<String>();
    private String indexField = "";
    private final List<String> interfaces;
    private final List<String> labels = new ArrayList<String>();
    private String primaryKeyField = "";
    private final String tableName;
    private final List<Serializable[]> valuesList = new ArrayList<Serializable[]>();
    public static final String[] STRINGS = new String[0];

    private EnumBuilder(String sourceName, String pkg, String name) {
        super(sourceName, pkg, name);
        this.interfaces = new ArrayList<String>();
        this.documentations = new ArrayList<String>();
        this.tableName = Names.tableName((String)name);
    }

    @Override
    public EnumType build() {
        if (this.default_.isEmpty() && !this.ids.isEmpty()) {
            this.default_ = this.ids.get(0);
        }
        LinkedHashMap<String, TypeField> fs = new LinkedHashMap<String, TypeField>();
        EnumType type = new EnumType(this.sourceName, this.domain, this.getId(), this.label, this.documentation, this.tableName, this.defaultForm, this.primaryKeyField, this.indexField, this.default_, this.modifiers, this.ids, this.labels, fs, this.valuesList, this.interfaces, this.documentations);
        this.buildAttributes(fs, (MetaModel)type);
        return type;
    }

    @Override
    @NotNull
    public List<BuilderError> check() {
        this.checkField(this.primaryKeyField, null);
        this.checkField(this.indexField, (Type)Types.intType());
        if (!this.default_.isEmpty() && !this.ids.contains(this.default_)) {
            this.builderErrors.add(new InvalidDefaultValueException(this.default_, this.getId()));
        }
        return this.builderErrors;
    }

    public EnumBuilder value(String key, String lbl) {
        return this.value(key, lbl, EnumType.SERIALIZABLES);
    }

    public EnumBuilder value(String key, String lbl, String doc) {
        return this.value(key, lbl, doc, EnumType.SERIALIZABLES);
    }

    public EnumBuilder value(String key, String lbl, Serializable[] values) {
        return this.value(key, lbl, "", values);
    }

    public EnumBuilder value(String key, String lbl, String doc, Serializable[] values) {
        this.ids.add(key);
        this.labels.add(lbl);
        this.valuesList.add(values);
        this.documentations.add(doc);
        return this;
    }

    public EnumBuilder withDefault(String defaultValue) {
        this.default_ = defaultValue;
        return this;
    }

    public EnumBuilder withIndex(String field) {
        this.indexField = field;
        return this;
    }

    public EnumBuilder withInterface(String clazz) {
        this.interfaces.add(clazz);
        return this;
    }

    public EnumBuilder withPrimaryKey(String field) {
        this.primaryKeyField = field;
        return this;
    }

    private void checkField(String field, @Nullable Type requiredType) {
        if (field.isEmpty()) {
            return;
        }
        TypeFieldBuilder tfb = (TypeFieldBuilder)this.fields.get(field);
        if (tfb == null) {
            this.builderErrors.add(new FieldNotFoundException(this.getId(), field));
        } else if (requiredType != null && !tfb.getType().equivalent(requiredType)) {
            this.builderErrors.add(new InvalidTypeException(this.getId(), tfb.getType()));
        }
    }

    public static EnumType enumType(Class<? extends Enum<?>> enumClass) {
        QName name = QName.createQName((String)enumClass.getCanonicalName());
        EnumBuilder builder = new EnumBuilder("", name.getQualification(), name.getName());
        for (Enum<?> e : enumClass.getEnumConstants()) {
            builder.value(e.name(), e instanceof Enumeration ? ((Enumeration)Enumeration.class.cast(e)).label() : "");
        }
        return builder.build();
    }

    public static EnumBuilder enumType(String sourceName, String packageId, String enumName) {
        return new EnumBuilder(sourceName, packageId, enumName);
    }
}

