/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.metadata.entity;

import java.util.List;
import java.util.function.Function;
import mulesoft.aggregate.AggregateFn;
import mulesoft.check.CheckMsg;
import mulesoft.check.CheckType;
import mulesoft.common.Predefined;
import mulesoft.common.core.Tuple;
import mulesoft.common.core.enumeration.Enumerations;
import mulesoft.expr.Expression;
import mulesoft.expr.ExpressionAST;
import mulesoft.field.FieldOption;
import mulesoft.field.FieldOptions;
import mulesoft.field.HasFieldOption;
import mulesoft.field.MetaModelReference;
import mulesoft.metadata.exception.BuilderException;
import mulesoft.metadata.exception.InvalidOptionValueException;
import mulesoft.type.Type;
import org.jetbrains.annotations.NotNull;

public abstract class FieldBuilder<This extends FieldBuilder<This>> {
    @NotNull
    private final FieldOptions options;

    protected FieldBuilder() {
        this(new FieldOptions());
    }

    protected FieldBuilder(@NotNull FieldOptions options) {
        this.options = options;
    }

    public This check(@NotNull Expression e, @NotNull String message) throws BuilderException {
        return this.check(e, new CheckMsg(message));
    }

    public This check(@NotNull ExpressionAST e, @NotNull String message) throws BuilderException {
        return this.check(e.createExpression(), new CheckMsg(message));
    }

    public This check(@NotNull Expression checkExpr, boolean inline, @NotNull CheckType checkType, @NotNull String msg) throws BuilderException {
        return this.check(checkExpr, new CheckMsg(inline, checkType, msg));
    }

    public This id(@NotNull String id) {
        try {
            return this.with(FieldOption.ID, id);
        }
        catch (BuilderException e) {
            throw new IllegalStateException(e);
        }
    }

    public This label(@NotNull String label) {
        try {
            return this.with(FieldOption.LABEL, label);
        }
        catch (BuilderException e) {
            throw new IllegalStateException(e);
        }
    }

    public This with(FieldOption option) throws BuilderException {
        return this.withOption(option, Boolean.TRUE);
    }

    public This with(FieldOption option, String str) throws BuilderException {
        return this.withOption(option, str);
    }

    public This with(FieldOption option, Function<?, ?> supplierRef) throws BuilderException {
        return this.withOption(option, supplierRef);
    }

    public This with(FieldOption option, Enum<?> e) throws BuilderException {
        return this.withOption(option, e);
    }

    public This with(FieldOption option, int n) throws BuilderException {
        return this.withOption(option, n);
    }

    public This with(FieldOption option, Expression expr) throws BuilderException {
        return this.withOption(option, expr);
    }

    public This with(FieldOption option, MetaModelReference reference) throws BuilderException {
        return this.withOption(option, reference);
    }

    public This with(FieldOption option, Type type) throws BuilderException {
        return this.withOption(option, type);
    }

    public void withArgument(Tuple<FieldOption, Object> arg) {
        this.options.put((FieldOption)arg.first(), arg.second());
    }

    public <T extends Enum<T>> This withEnum(FieldOption option, Class<T> c, String txt) throws BuilderException {
        try {
            return this.with(option, Enumerations.valueOf(c, (String)txt.toUpperCase()));
        }
        catch (RuntimeException e) {
            throw new InvalidOptionValueException(this.getName(), option.getId(), txt);
        }
    }

    public This withFieldDocumentation(@NotNull String content) {
        this.options.put(FieldOption.FIELD_DOCUMENTATION, (Object)content);
        return (This)((FieldBuilder)Predefined.cast((Object)this));
    }

    public This withOption(FieldOption option, Object obj) throws BuilderException {
        this.checkOptionSupport(option);
        this.options.put(option, obj);
        return (This)((FieldBuilder)Predefined.cast((Object)this));
    }

    public boolean isOptional() {
        return this.options.getExpression(FieldOption.OPTIONAL) == Expression.TRUE;
    }

    @NotNull
    public FieldOptions getOptions() {
        return this.options;
    }

    protected void addDefaultArguments(List<HasFieldOption> arguments) {
        for (HasFieldOption arg : arguments) {
            Object defaultValue;
            FieldOption opt = arg.getFieldOption();
            if (this.hasOption(opt) || (defaultValue = arg.getDefaultValue()) == null) continue;
            this.options.put(opt, defaultValue);
        }
    }

    protected This aggregate(@NotNull Expression expr, @NotNull AggregateFn fn, @NotNull String ref) throws BuilderException {
        this.withOption(FieldOption.AGGREGATE, this.options.getAggregate(FieldOption.AGGREGATE).add(expr, fn, ref));
        return (This)((FieldBuilder)Predefined.cast((Object)this));
    }

    protected This check(Expression checkExpr, CheckMsg msg) throws BuilderException {
        this.withOption(FieldOption.CHECK, this.options.getCheck(FieldOption.CHECK).addCheck(checkExpr, msg));
        return (This)((FieldBuilder)Predefined.cast((Object)this));
    }

    protected abstract void checkOptionSupport(FieldOption var1) throws BuilderException;

    protected boolean hasOption(FieldOption opt) {
        return this.options.hasOption(opt);
    }

    protected String getName() {
        return this.options.getString(FieldOption.ID);
    }

    boolean getBooleanOption(FieldOption option) {
        return this.options.getBoolean(option);
    }
}

