/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.metadata.entity;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mulesoft.common.core.Option;
import mulesoft.common.core.QName;
import mulesoft.field.TypeField;
import mulesoft.metadata.entity.CompositeBuilder;
import mulesoft.metadata.entity.StructType;
import mulesoft.metadata.entity.TypeFieldBuilder;
import mulesoft.metadata.exception.BuilderError;
import mulesoft.metadata.exception.DuplicateFieldException;
import mulesoft.metadata.exception.inheritance.ExtendsFromFinalException;
import mulesoft.metadata.exception.inheritance.FieldClashesWithUnrelatedTypeException;
import mulesoft.metadata.exception.inheritance.InterfaceExtendsOnlyException;
import mulesoft.metadata.exception.inheritance.MultipleInheritanceException;
import mulesoft.type.MetaModel;
import mulesoft.type.Modifier;
import mulesoft.type.Type;
import org.jetbrains.annotations.NotNull;

public class StructBuilder
extends CompositeBuilder<StructType, TypeField, TypeFieldBuilder, StructBuilder> {
    private final Map<String, TypeField> allFieldsByName;
    private final Map<TypeField, StructType> allFieldsByStruct;
    private final Set<String> args;
    private String defaultWidget = "";
    private final List<StructType> superTypes = new ArrayList<StructType>();

    private StructBuilder(String sourceName, @NotNull String pkg, @NotNull String name) {
        super(sourceName, pkg, name);
        this.allFieldsByName = new HashMap<String, TypeField>();
        this.allFieldsByStruct = new HashMap<TypeField, StructType>();
        this.args = new LinkedHashSet<String>();
    }

    public final StructBuilder addArgument(TypeFieldBuilder a) throws DuplicateFieldException {
        this.checkDuplicates(a);
        this.args.add(a.getName());
        this.fields.put(a.getName(), a);
        return this;
    }

    public StructBuilder asInterface() {
        this.withModifiers(EnumSet.of(Modifier.INTERFACE));
        return this;
    }

    @Override
    public StructType build() {
        LinkedHashMap<String, TypeField> fs = new LinkedHashMap<String, TypeField>();
        StructType type = new StructType(this.sourceName, this.domain, this.id, this.label, this.modifiers, fs, this.args, this.superTypes, this.defaultWidget, this.documentation);
        this.buildAttributes(fs, (MetaModel)type);
        return type;
    }

    @Override
    @NotNull
    public List<BuilderError> check() {
        return this.builderErrors;
    }

    public StructBuilder defaultWidget(@NotNull String w) {
        this.defaultWidget = w;
        return this;
    }

    public StructBuilder withSuperType(StructType parent) throws FieldClashesWithUnrelatedTypeException, InterfaceExtendsOnlyException, MultipleInheritanceException, ExtendsFromFinalException {
        if (parent.isFinal()) {
            throw new ExtendsFromFinalException(parent.getFullName(), this.getFullName());
        }
        if (this.hasModifier(Modifier.INTERFACE)) {
            if (!parent.hasModifier(Modifier.INTERFACE)) {
                throw new InterfaceExtendsOnlyException(parent.getFullName(), this.getFullName());
            }
        } else if (!parent.isInterface()) {
            for (StructType superType : this.superTypes) {
                if (superType.isInterface()) continue;
                throw new MultipleInheritanceException(superType.getFullName(), parent.getFullName(), this.getFullName());
            }
        }
        this.superTypes.add(parent);
        for (TypeField field : parent.getChildren()) {
            Iterator iterator = this.checkIncompatibleClashes(field.getName(), field.getType()).iterator();
            if (iterator.hasNext()) {
                TypeField duplicate = (TypeField)iterator.next();
                throw this.fieldsClashes(duplicate, field.getName(), parent.getFullName(), this.getFullName());
            }
            this.allFieldsByName.put(field.getName(), field);
            this.allFieldsByStruct.put(field, parent);
        }
        return this;
    }

    @Override
    void checkDuplicates(TypeFieldBuilder a) throws DuplicateFieldException {
        Iterator iterator = this.checkIncompatibleClashes(a.getName(), a.getType()).iterator();
        if (iterator.hasNext()) {
            TypeField incompatible = (TypeField)iterator.next();
            throw this.fieldsClashes(incompatible, a.getName(), this.getFullName(), this.getFullName());
        }
        if (this.fields.containsKey(a.getName())) {
            throw DuplicateFieldException.onType(a.getName(), this.id);
        }
    }

    private Option<TypeField> checkIncompatibleClashes(@NotNull String name, @NotNull Type type) {
        TypeField duplicate = this.allFieldsByName.get(name);
        return duplicate != null && !duplicate.getType().equivalent(type) ? Option.some((Object)duplicate) : Option.empty();
    }

    private FieldClashesWithUnrelatedTypeException fieldsClashes(TypeField incompatible, String fieldName, String fieldModel, String model) {
        return new FieldClashesWithUnrelatedTypeException(fieldName, fieldModel, incompatible.getName(), this.allFieldsByStruct.get(incompatible).getFullName(), model);
    }

    public static StructBuilder struct(QName name) {
        return new StructBuilder("", name.getQualification(), name.getName());
    }

    public static StructBuilder struct(String sourceName, String packageId, String name) {
        return new StructBuilder(sourceName, packageId, name);
    }
}

